/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import com.facebook.FacebookSdk;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class CustomTabUtils {
    private static final String[] CHROME_PACKAGES = new String[]{"com.android.chrome", "com.chrome.beta", "com.chrome.dev"};

    public static String getDefaultRedirectURI() {
        return "fbconnect://cct." + FacebookSdk.getApplicationContext().getPackageName();
    }

    public static String getChromePackage() {
        Context context = FacebookSdk.getApplicationContext();
        Intent serviceIntent = new Intent("android.support.customtabs.action.CustomTabsService");
        List resolveInfos = context.getPackageManager().queryIntentServices(serviceIntent, 0);
        if (resolveInfos != null) {
            HashSet<String> chromePackages = new HashSet<String>(Arrays.asList(CHROME_PACKAGES));
            for (ResolveInfo resolveInfo : resolveInfos) {
                ServiceInfo serviceInfo = resolveInfo.serviceInfo;
                if (serviceInfo == null || !chromePackages.contains(serviceInfo.packageName)) continue;
                return serviceInfo.packageName;
            }
        }
        return null;
    }
}

