/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.facebook.share.model.CameraEffectArguments;
import com.facebook.share.model.CameraEffectTextures;
import com.facebook.share.model.ShareContent;

public class ShareCameraEffectContent
extends ShareContent<ShareCameraEffectContent, Builder> {
    private String effectId;
    private CameraEffectArguments arguments;
    private CameraEffectTextures textures;
    public static final Parcelable.Creator<ShareCameraEffectContent> CREATOR = new Parcelable.Creator<ShareCameraEffectContent>(){

        public ShareCameraEffectContent createFromParcel(Parcel in) {
            return new ShareCameraEffectContent(in);
        }

        public ShareCameraEffectContent[] newArray(int size) {
            return new ShareCameraEffectContent[size];
        }
    };

    private ShareCameraEffectContent(Builder builder) {
        super(builder);
        this.effectId = builder.effectId;
        this.arguments = builder.arguments;
        this.textures = builder.textures;
    }

    ShareCameraEffectContent(Parcel in) {
        super(in);
        this.effectId = in.readString();
        this.arguments = new CameraEffectArguments.Builder().readFrom(in).build();
        this.textures = new CameraEffectTextures.Builder().readFrom(in).build();
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        super.writeToParcel(out, flags);
        out.writeString(this.effectId);
        out.writeParcelable((Parcelable)this.arguments, 0);
        out.writeParcelable((Parcelable)this.textures, 0);
    }

    public String getEffectId() {
        return this.effectId;
    }

    public CameraEffectArguments getArguments() {
        return this.arguments;
    }

    public CameraEffectTextures getTextures() {
        return this.textures;
    }

    public static final class Builder
    extends ShareContent.Builder<ShareCameraEffectContent, Builder> {
        private String effectId;
        private CameraEffectArguments arguments;
        private CameraEffectTextures textures;

        public Builder setEffectId(String effectId) {
            this.effectId = effectId;
            return this;
        }

        public Builder setArguments(CameraEffectArguments arguments) {
            this.arguments = arguments;
            return this;
        }

        public Builder setTextures(CameraEffectTextures textures) {
            this.textures = textures;
            return this;
        }

        @Override
        public ShareCameraEffectContent build() {
            return new ShareCameraEffectContent(this);
        }

        @Override
        public Builder readFrom(ShareCameraEffectContent model) {
            if (model == null) {
                return this;
            }
            return ((Builder)super.readFrom(model)).setEffectId(this.effectId).setArguments(this.arguments);
        }
    }
}

