/**
 * Copyright (c) 2014-present, Facebook, Inc. All rights reserved.
 *
 * You are hereby granted a non-exclusive, worldwide, royalty-free license to use,
 * copy, modify, and distribute this software in source code or binary form for use
 * in connection with the web services and APIs provided by Facebook.
 *
 * As with any software that integrates with the Facebook platform, your use of
 * this software is subject to the Facebook Developer Principles and Policies
 * [http://developers.facebook.com/policy/]. This copyright notice shall be
 * included in all copies or substantial portions of the software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.facebook.share.internal;


import android.content.Context;
import android.os.Bundle;

import com.facebook.internal.NativeProtocol;
import com.facebook.internal.PlatformServiceClient;

/**
 * com.facebook.share.internal is solely for the use of other packages within the Facebook SDK for
 * Android. Use of any of the classes in this package is unsupported, and they may be modified or
 * removed without warning at any time.
 *
 * This class executes service calls to fetch like-state of objects from the Facebook Application,
 * if available.
 */
/*
 * @deprecated
 * LikeView is deprecated
 */
@Deprecated
final class LikeStatusClient extends PlatformServiceClient {
    private String objectId;

    LikeStatusClient(Context context, String applicationId, String objectId) {
        super(context,
                NativeProtocol.MESSAGE_GET_LIKE_STATUS_REQUEST,
                NativeProtocol.MESSAGE_GET_LIKE_STATUS_REPLY,
                NativeProtocol.PROTOCOL_VERSION_20141001,
                applicationId);

        this.objectId = objectId;
    }

    @Override
    protected void populateRequestBundle(Bundle data) {
        // Only thing we need to pass in is the object id.
        data.putString(ShareConstants.EXTRA_OBJECT_ID, objectId);
    }
}

