/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.model;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.facebook.share.model.ShareContent;
import com.facebook.share.model.ShareMessengerActionButton;
import java.io.Serializable;

public final class ShareMessengerMediaTemplateContent
extends ShareContent<ShareMessengerMediaTemplateContent, Builder> {
    private final MediaType mediaType;
    private final String attachmentId;
    private final Uri mediaUrl;
    private final ShareMessengerActionButton button;
    public static final Parcelable.Creator<ShareMessengerMediaTemplateContent> CREATOR = new Parcelable.Creator<ShareMessengerMediaTemplateContent>(){

        public ShareMessengerMediaTemplateContent createFromParcel(Parcel in) {
            return new ShareMessengerMediaTemplateContent(in);
        }

        public ShareMessengerMediaTemplateContent[] newArray(int size) {
            return new ShareMessengerMediaTemplateContent[size];
        }
    };

    private ShareMessengerMediaTemplateContent(Builder builder) {
        super(builder);
        this.mediaType = builder.mediaType;
        this.attachmentId = builder.attachmentId;
        this.mediaUrl = builder.mediaUrl;
        this.button = builder.button;
    }

    ShareMessengerMediaTemplateContent(Parcel in) {
        super(in);
        this.mediaType = (MediaType)((Object)in.readSerializable());
        this.attachmentId = in.readString();
        this.mediaUrl = (Uri)in.readParcelable(Uri.class.getClassLoader());
        this.button = (ShareMessengerActionButton)in.readParcelable(ShareMessengerActionButton.class.getClassLoader());
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public String getAttachmentId() {
        return this.attachmentId;
    }

    public Uri getMediaUrl() {
        return this.mediaUrl;
    }

    public ShareMessengerActionButton getButton() {
        return this.button;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeSerializable((Serializable)((Object)this.mediaType));
        dest.writeString(this.attachmentId);
        dest.writeParcelable((Parcelable)this.mediaUrl, flags);
        dest.writeParcelable((Parcelable)this.button, flags);
    }

    public static class Builder
    extends ShareContent.Builder<ShareMessengerMediaTemplateContent, Builder> {
        private MediaType mediaType;
        private String attachmentId;
        private Uri mediaUrl;
        private ShareMessengerActionButton button;

        public Builder setMediaType(MediaType mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public Builder setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public Builder setMediaUrl(Uri mediaUrl) {
            this.mediaUrl = mediaUrl;
            return this;
        }

        public Builder setButton(ShareMessengerActionButton button) {
            this.button = button;
            return this;
        }

        @Override
        public Builder readFrom(ShareMessengerMediaTemplateContent content) {
            if (content == null) {
                return this;
            }
            return ((Builder)super.readFrom(content)).setMediaType(content.getMediaType()).setAttachmentId(content.getAttachmentId()).setMediaUrl(content.getMediaUrl()).setButton(content.getButton());
        }

        @Override
        public ShareMessengerMediaTemplateContent build() {
            return new ShareMessengerMediaTemplateContent(this);
        }
    }

    public static enum MediaType {
        IMAGE,
        VIDEO;

    }
}

