/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.internal;

import com.facebook.share.model.CameraEffectArguments;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J\u0014\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\tH\u0007R2\u0010\u0003\u001a&\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/facebook/share/internal/CameraEffectJSONUtility;", "", "()V", "SETTERS", "Ljava/util/HashMap;", "Ljava/lang/Class;", "Lcom/facebook/share/internal/CameraEffectJSONUtility$Setter;", "Lkotlin/collections/HashMap;", "convertToCameraEffectArguments", "Lcom/facebook/share/model/CameraEffectArguments;", "jsonObject", "Lorg/json/JSONObject;", "convertToJSON", "arguments", "Setter", "facebook-common_release"})
public final class CameraEffectJSONUtility {
    @NotNull
    public static final CameraEffectJSONUtility INSTANCE = new CameraEffectJSONUtility();
    @NotNull
    private static final HashMap<Class<?>, Setter> SETTERS;

    private CameraEffectJSONUtility() {
    }

    @JvmStatic
    @Nullable
    public static final JSONObject convertToJSON(@Nullable CameraEffectArguments arguments) throws JSONException {
        if (arguments == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        for (String key : arguments.keySet()) {
            Setter setter;
            Object value;
            if (arguments.get(key) == null) continue;
            if (SETTERS.get(value.getClass()) == null) {
                throw new IllegalArgumentException("Unsupported type: " + value.getClass());
            }
            setter.setOnJSON(json, key, value);
        }
        return json;
    }

    @JvmStatic
    @Nullable
    public static final CameraEffectArguments convertToCameraEffectArguments(@Nullable JSONObject jsonObject) throws JSONException {
        if (jsonObject == null) {
            return null;
        }
        CameraEffectArguments.Builder builder = new CameraEffectArguments.Builder();
        Iterator jsonIterator = jsonObject.keys();
        while (jsonIterator.hasNext()) {
            Setter setter;
            String key = (String)jsonIterator.next();
            Object value = jsonObject.get(key);
            if (value == JSONObject.NULL) continue;
            if (SETTERS.get(value.getClass()) == null) {
                throw new IllegalArgumentException("Unsupported type: " + value.getClass());
            }
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            setter.setOnArgumentsBuilder(builder, key, value);
        }
        return builder.build();
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(String.class, (Object)new Setter(){

            public void setOnArgumentsBuilder(@NotNull CameraEffectArguments.Builder builder, @NotNull String key, @Nullable Object value) throws JSONException {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
                builder.putArgument(key, (String)value);
            }

            public void setOnJSON(@NotNull JSONObject json, @NotNull String key, @Nullable Object value) throws JSONException {
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                json.put(key, value);
            }
        }), TuplesKt.to(String[].class, (Object)new Setter(){

            public void setOnArgumentsBuilder(@NotNull CameraEffectArguments.Builder builder, @NotNull String key, @Nullable Object value) throws JSONException {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                throw new IllegalArgumentException("Unexpected type from JSON");
            }

            public void setOnJSON(@NotNull JSONObject json, @NotNull String key, @Nullable Object value) throws JSONException {
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                JSONArray jsonArray = new JSONArray();
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.String?>");
                for (String stringValue : (String[])value) {
                    jsonArray.put((Object)stringValue);
                }
                json.put(key, (Object)jsonArray);
            }
        }), TuplesKt.to(JSONArray.class, (Object)new Setter(){

            public void setOnArgumentsBuilder(@NotNull CameraEffectArguments.Builder builder, @NotNull String key, @Nullable Object value) throws JSONException {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type org.json.JSONArray");
                JSONArray jsonArray = (JSONArray)value;
                List argsList = new ArrayList<E>();
                int n = jsonArray.length();
                for (int i = 0; i < n; ++i) {
                    Object current = jsonArray.get(i);
                    if (!(current instanceof String)) {
                        throw new IllegalArgumentException("Unexpected type in an array: " + current.getClass());
                    }
                    argsList.add(current);
                }
                Collection $this$toTypedArray$iv = argsList;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                builder.putArgument(key, thisCollection$iv.toArray(new String[0]));
            }

            public void setOnJSON(@NotNull JSONObject json, @NotNull String key, @Nullable Object value) throws JSONException {
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                throw new IllegalArgumentException("JSONArray's are not supported in bundles.");
            }
        })};
        SETTERS = MapsKt.hashMapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\"\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0001H&J\"\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0001H&\u00a8\u0006\f"}, d2={"Lcom/facebook/share/internal/CameraEffectJSONUtility$Setter;", "", "setOnArgumentsBuilder", "", "builder", "Lcom/facebook/share/model/CameraEffectArguments$Builder;", "key", "", "value", "setOnJSON", "json", "Lorg/json/JSONObject;", "facebook-common_release"})
    private static interface Setter {
        public void setOnArgumentsBuilder(@NotNull CameraEffectArguments.Builder var1, @NotNull String var2, @Nullable Object var3) throws JSONException;

        public void setOnJSON(@NotNull JSONObject var1, @NotNull String var2, @Nullable Object var3) throws JSONException;
    }
}

