/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.facebook.AccessTokenSource;
import com.facebook.CustomTabMainActivity;
import com.facebook.FacebookException;
import com.facebook.FacebookOperationCanceledException;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookSdk;
import com.facebook.FacebookServiceException;
import com.facebook.internal.CustomTab;
import com.facebook.internal.CustomTabUtils;
import com.facebook.internal.InstagramCustomTab;
import com.facebook.internal.Utility;
import com.facebook.login.CustomTabPrefetchHelper;
import com.facebook.login.LoginClient;
import com.facebook.login.WebLoginMethodHandler;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 02\u00020\u0001:\u00010B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0010\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\tH\u0014J\n\u0010\u001a\u001a\u0004\u0018\u00010\tH\u0014J\"\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00182\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u001a\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\t2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020,H\u0002J\u0018\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\u0018H\u0016R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000bR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/facebook/login/CustomTabLoginMethodHandler;", "Lcom/facebook/login/WebLoginMethodHandler;", "loginClient", "Lcom/facebook/login/LoginClient;", "(Lcom/facebook/login/LoginClient;)V", "source", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "chromePackage", "", "getChromePackage", "()Ljava/lang/String;", "currentPackage", "developerDefinedRedirectURI", "getDeveloperDefinedRedirectURI", "expectedChallenge", "nameForLogging", "getNameForLogging", "tokenSource", "Lcom/facebook/AccessTokenSource;", "getTokenSource", "()Lcom/facebook/AccessTokenSource;", "validRedirectURI", "describeContents", "", "getRedirectUrl", "getSSODevice", "onActivityResult", "", "requestCode", "resultCode", "data", "Landroid/content/Intent;", "onCustomTabComplete", "", "url", "request", "Lcom/facebook/login/LoginClient$Request;", "putChallengeParam", "param", "Lorg/json/JSONObject;", "tryAuthorize", "validateChallengeParam", "values", "Landroid/os/Bundle;", "writeToParcel", "dest", "flags", "Companion", "facebook-common_release"})
public final class CustomTabLoginMethodHandler
extends WebLoginMethodHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String currentPackage;
    @Nullable
    private String expectedChallenge;
    @NotNull
    private String validRedirectURI;
    @NotNull
    private final String nameForLogging;
    @NotNull
    private final AccessTokenSource tokenSource;
    private static final int CUSTOM_TAB_REQUEST_CODE = 1;
    private static final int CHALLENGE_LENGTH = 20;
    private static final int API_EC_DIALOG_CANCEL = 4201;
    @NotNull
    public static final String OAUTH_DIALOG = "oauth";
    @JvmField
    public static boolean calledThroughLoggedOutAppSwitch;
    @JvmField
    @NotNull
    public static final Parcelable.Creator<CustomTabLoginMethodHandler> CREATOR;

    public CustomTabLoginMethodHandler(@NotNull LoginClient loginClient) {
        Intrinsics.checkNotNullParameter((Object)loginClient, (String)"loginClient");
        super(loginClient);
        this.nameForLogging = "custom_tab";
        this.tokenSource = AccessTokenSource.CHROME_CUSTOM_TAB;
        this.expectedChallenge = Utility.generateRandomString((int)20);
        calledThroughLoggedOutAppSwitch = false;
        this.validRedirectURI = CustomTabUtils.getValidRedirectURI(this.getDeveloperDefinedRedirectURI());
    }

    @Override
    @NotNull
    public String getNameForLogging() {
        return this.nameForLogging;
    }

    @Override
    @NotNull
    public AccessTokenSource getTokenSource() {
        return this.tokenSource;
    }

    private final String getDeveloperDefinedRedirectURI() {
        return super.getRedirectUrl();
    }

    @Override
    @NotNull
    protected String getRedirectUrl() {
        return this.validRedirectURI;
    }

    @Override
    @Nullable
    protected String getSSODevice() {
        return "chrome_custom_tab";
    }

    @Override
    public int tryAuthorize(@NotNull LoginClient.Request request) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            LoginClient loginClient = this.getLoginClient();
            if (((CharSequence)this.getRedirectUrl()).length() == 0) {
                return 0;
            }
            Bundle parameters = this.getParameters(request);
            parameters = this.addExtraParameters(parameters, request);
            if (calledThroughLoggedOutAppSwitch) {
                parameters.putString("cct_over_app_switch", "1");
            }
            if (FacebookSdk.hasCustomTabsPrefetching) {
                if (request.isInstagramLogin()) {
                    CustomTabPrefetchHelper.Companion.mayLaunchUrl(InstagramCustomTab.Companion.getURIForAction(OAUTH_DIALOG, parameters));
                } else {
                    CustomTabPrefetchHelper.Companion.mayLaunchUrl(CustomTab.Companion.getURIForAction(OAUTH_DIALOG, parameters));
                }
            }
            FragmentActivity fragmentActivity = loginClient.getActivity();
            if (fragmentActivity == null) {
                return 0;
            }
            Activity activity = (Activity)fragmentActivity;
            Intent intent = new Intent((Context)activity, CustomTabMainActivity.class);
            intent.putExtra(CustomTabMainActivity.EXTRA_ACTION, OAUTH_DIALOG);
            intent.putExtra(CustomTabMainActivity.EXTRA_PARAMS, parameters);
            intent.putExtra(CustomTabMainActivity.EXTRA_CHROME_PACKAGE, this.getChromePackage());
            intent.putExtra(CustomTabMainActivity.EXTRA_TARGET_APP, request.getLoginTargetApp().toString());
            Fragment fragment = loginClient.getFragment();
            if (fragment == null) break block6;
            fragment.startActivityForResult(intent, 1);
        }
        return 1;
    }

    private final String getChromePackage() {
        if (this.currentPackage != null) {
            return this.currentPackage;
        }
        this.currentPackage = CustomTabUtils.getChromePackage();
        return this.currentPackage;
    }

    @Override
    public boolean onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        boolean hasNoBrowserException;
        if (data != null && (hasNoBrowserException = data.getBooleanExtra(CustomTabMainActivity.NO_ACTIVITY_EXCEPTION, false))) {
            return super.onActivityResult(requestCode, resultCode, data);
        }
        if (requestCode != 1) {
            return super.onActivityResult(requestCode, resultCode, data);
        }
        LoginClient.Request request = this.getLoginClient().getPendingRequest();
        if (request == null) {
            return false;
        }
        LoginClient.Request request2 = request;
        if (resultCode == -1) {
            String extraUrl = null;
            if (data != null) {
                extraUrl = data.getStringExtra(CustomTabMainActivity.EXTRA_URL);
            }
            this.onCustomTabComplete(extraUrl, request2);
            return true;
        }
        super.onComplete(request2, null, (FacebookException)new FacebookOperationCanceledException());
        return false;
    }

    private final void onCustomTabComplete(String url, LoginClient.Request request) {
        if (url != null && (StringsKt.startsWith$default((String)url, (String)"fbconnect://cct.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)url, (String)super.getRedirectUrl(), (boolean)false, (int)2, null))) {
            int n;
            String errorMessage;
            Uri uri = Uri.parse((String)url);
            Bundle values = Utility.parseUrlQueryString((String)uri.getQuery());
            values.putAll(Utility.parseUrlQueryString((String)uri.getFragment()));
            if (!this.validateChallengeParam(values)) {
                super.onComplete(request, null, new FacebookException("Invalid state parameter"));
                return;
            }
            String error = values.getString("error");
            if (error == null) {
                error = values.getString("error_type");
            }
            if ((errorMessage = values.getString("error_msg")) == null) {
                errorMessage = values.getString("error_message");
            }
            if (errorMessage == null) {
                errorMessage = values.getString("error_description");
            }
            String errorCodeString = values.getString("error_code");
            try {
                String string2 = errorCodeString;
                n = string2 != null ? Integer.parseInt(string2) : -1;
            }
            catch (NumberFormatException ex) {
                n = -1;
            }
            int errorCode = n;
            if (Utility.isNullOrEmpty((String)error) && Utility.isNullOrEmpty((String)errorMessage) && errorCode == -1) {
                if (values.containsKey("access_token")) {
                    super.onComplete(request, values, null);
                    return;
                }
                FacebookSdk.getExecutor().execute(() -> CustomTabLoginMethodHandler.onCustomTabComplete$lambda$0(this, request, values));
            } else if (error != null && (Intrinsics.areEqual((Object)error, (Object)"access_denied") || Intrinsics.areEqual((Object)error, (Object)"OAuthAccessDeniedException"))) {
                super.onComplete(request, null, (FacebookException)new FacebookOperationCanceledException());
            } else if (errorCode == 4201) {
                super.onComplete(request, null, (FacebookException)new FacebookOperationCanceledException());
            } else {
                FacebookRequestError requestError = new FacebookRequestError(errorCode, error, errorMessage);
                super.onComplete(request, null, (FacebookException)new FacebookServiceException(requestError, errorMessage));
            }
        }
    }

    @Override
    public void putChallengeParam(@NotNull JSONObject param) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        param.put("7_challenge", (Object)this.expectedChallenge);
    }

    private final boolean validateChallengeParam(Bundle values) {
        boolean bl;
        try {
            String string2 = values.getString("state");
            if (string2 == null) {
                return false;
            }
            String stateString = string2;
            JSONObject state = new JSONObject(stateString);
            String challenge = state.getString("7_challenge");
            bl = Intrinsics.areEqual((Object)challenge, (Object)this.expectedChallenge);
        }
        catch (JSONException e) {
            bl = false;
        }
        return bl;
    }

    public int describeContents() {
        return 0;
    }

    public CustomTabLoginMethodHandler(@NotNull Parcel source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        super(source);
        this.nameForLogging = "custom_tab";
        this.tokenSource = AccessTokenSource.CHROME_CUSTOM_TAB;
        this.expectedChallenge = source.readString();
        this.validRedirectURI = CustomTabUtils.getValidRedirectURI(this.getDeveloperDefinedRedirectURI());
    }

    @Override
    public void writeToParcel(@NotNull Parcel dest, int flags) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        super.writeToParcel(dest, flags);
        dest.writeString(this.expectedChallenge);
    }

    private static final void onCustomTabComplete$lambda$0(CustomTabLoginMethodHandler this$0, LoginClient.Request $request, Bundle $values) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        Intrinsics.checkNotNullParameter((Object)$values, (String)"$values");
        try {
            Bundle processedValues = this$0.processCodeExchange($request, $values);
            this$0.onComplete($request, processedValues, null);
        }
        catch (FacebookException ex) {
            this$0.onComplete($request, null, ex);
        }
    }

    static {
        CREATOR = (Parcelable.Creator)new Parcelable.Creator<CustomTabLoginMethodHandler>(){

            @NotNull
            public CustomTabLoginMethodHandler createFromParcel(@NotNull Parcel source) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                return new CustomTabLoginMethodHandler(source);
            }

            @NotNull
            public CustomTabLoginMethodHandler[] newArray(int size) {
                return new CustomTabLoginMethodHandler[size];
            }
        };
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/facebook/login/CustomTabLoginMethodHandler$Companion;", "", "()V", "API_EC_DIALOG_CANCEL", "", "CHALLENGE_LENGTH", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/facebook/login/CustomTabLoginMethodHandler;", "CUSTOM_TAB_REQUEST_CODE", "OAUTH_DIALOG", "", "calledThroughLoggedOutAppSwitch", "", "facebook-common_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

