/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import androidx.activity.result.ActivityResultRegistry;
import androidx.activity.result.ActivityResultRegistryOwner;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.annotation.VisibleForTesting;
import com.facebook.CallbackManager;
import com.facebook.FacebookCallback;
import com.facebook.FacebookDialog;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.LoggingBehavior;
import com.facebook.internal.AppCall;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.DialogPresenter;
import com.facebook.internal.FragmentWrapper;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 @*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003:\u0002@AB\u0017\b\u0014\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0017\b\u0014\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bB\u000f\b\u0014\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\fJ\u001e\u0010!\u001a\u0018\u0012\u0014\u0012\u00120\u0018R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00000\u0017H\u0002J\u0015\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010%J\u001d\u0010&\u001a\u00020#2\u0006\u0010$\u001a\u00028\u00002\u0006\u0010'\u001a\u00020(H\u0014\u00a2\u0006\u0002\u0010)J\u001e\u0010*\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020,0+2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J&\u0010*\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020,0+2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010'\u001a\u00020(H\u0004J\u001f\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010$\u001a\u00028\u00002\u0006\u0010'\u001a\u00020(H\u0002\u00a2\u0006\u0002\u0010/J\b\u00100\u001a\u00020.H$J\u0012\u00101\u001a\u0002022\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u001e\u00103\u001a\u0002022\u0006\u0010\u0010\u001a\u00020\u00112\f\u00104\u001a\b\u0012\u0004\u0012\u00028\u000105H\u0016J&\u00103\u001a\u0002022\u0006\u0010\u0010\u001a\u00020\u00112\f\u00104\u001a\b\u0012\u0004\u0012\u00028\u0001052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u00106\u001a\u0002022\u0006\u0010\u0010\u001a\u0002072\f\u00104\u001a\b\u0012\u0004\u0012\u00028\u000105H$J\u0010\u00108\u001a\u0002022\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0015\u00109\u001a\u0002022\u0006\u0010$\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010:J\u001d\u0010;\u001a\u0002022\u0006\u0010$\u001a\u00028\u00002\u0006\u0010'\u001a\u00020(H\u0014\u00a2\u0006\u0002\u0010<J\u0018\u0010=\u001a\u0002022\u0006\u0010>\u001a\u00020?2\u0006\u0010\u0006\u001a\u00020\u0007H\u0004R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\u0004\u0018\u00010\u00058DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u0004\u0018\u00010\u00118AX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0016\u001a\u001a\u0012\u0014\u0012\u00120\u0018R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0019\u001a\u0018\u0012\u0014\u0012\u00120\u0018R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00000\u0017X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010\fR\u000e\u0010 \u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/facebook/internal/FacebookDialogBase;", "CONTENT", "RESULT", "Lcom/facebook/FacebookDialog;", "activity", "Landroid/app/Activity;", "requestCode", "", "(Landroid/app/Activity;I)V", "fragmentWrapper", "Lcom/facebook/internal/FragmentWrapper;", "(Lcom/facebook/internal/FragmentWrapper;I)V", "(I)V", "activityContext", "getActivityContext", "()Landroid/app/Activity;", "callbackManager", "Lcom/facebook/CallbackManager;", "getCallbackManager$facebook_common_release", "()Lcom/facebook/CallbackManager;", "setCallbackManager$facebook_common_release", "(Lcom/facebook/CallbackManager;)V", "modeHandlers", "", "Lcom/facebook/internal/FacebookDialogBase$ModeHandler;", "orderedModeHandlers", "getOrderedModeHandlers", "()Ljava/util/List;", "value", "getRequestCode", "()I", "setRequestCode", "requestCodeField", "cachedModeHandlers", "canShow", "", "content", "(Ljava/lang/Object;)Z", "canShowImpl", "mode", "", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "createActivityResultContractForShowingDialog", "Landroidx/activity/result/contract/ActivityResultContract;", "Lcom/facebook/CallbackManager$ActivityResultParameters;", "createAppCallForMode", "Lcom/facebook/internal/AppCall;", "(Ljava/lang/Object;Ljava/lang/Object;)Lcom/facebook/internal/AppCall;", "createBaseAppCall", "memorizeCallbackManager", "", "registerCallback", "callback", "Lcom/facebook/FacebookCallback;", "registerCallbackImpl", "Lcom/facebook/internal/CallbackManagerImpl;", "setCallbackManager", "show", "(Ljava/lang/Object;)V", "showImpl", "(Ljava/lang/Object;Ljava/lang/Object;)V", "startActivityForResult", "intent", "Landroid/content/Intent;", "Companion", "ModeHandler", "facebook-common_release"})
@SourceDebugExtension(value={"SMAP\nFacebookDialogBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FacebookDialogBase.kt\ncom/facebook/internal/FacebookDialogBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,285:1\n1#2:286\n*E\n"})
public abstract class FacebookDialogBase<CONTENT, RESULT>
implements FacebookDialog<CONTENT, RESULT> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Activity activity;
    @Nullable
    private final FragmentWrapper fragmentWrapper;
    @Nullable
    private List<? extends ModeHandler> modeHandlers;
    private int requestCodeField;
    @Nullable
    private CallbackManager callbackManager;
    @NotNull
    private static final String TAG = "FacebookDialog";
    @JvmField
    @NotNull
    public static final Object BASE_AUTOMATIC_MODE = new Object();

    @VisibleForTesting(otherwise=2)
    @Nullable
    public final CallbackManager getCallbackManager$facebook_common_release() {
        return this.callbackManager;
    }

    public final void setCallbackManager$facebook_common_release(@Nullable CallbackManager callbackManager) {
        this.callbackManager = callbackManager;
    }

    public final void setCallbackManager(@Nullable CallbackManager callbackManager) {
        this.callbackManager = callbackManager;
    }

    protected FacebookDialogBase(@NotNull Activity activity, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.activity = activity;
        this.fragmentWrapper = null;
        this.requestCodeField = requestCode;
        this.callbackManager = null;
    }

    protected FacebookDialogBase(@NotNull FragmentWrapper fragmentWrapper, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)fragmentWrapper, (String)"fragmentWrapper");
        this.fragmentWrapper = fragmentWrapper;
        this.activity = null;
        this.requestCodeField = requestCode;
        if (fragmentWrapper.getActivity() == null) {
            boolean bl = false;
            String string2 = "Cannot use a fragment that is not attached to an activity";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    protected FacebookDialogBase(int requestCode) {
        this.requestCodeField = requestCode;
        this.activity = null;
        this.fragmentWrapper = null;
    }

    @Override
    public void registerCallback(@NotNull CallbackManager callbackManager, @NotNull FacebookCallback<RESULT> callback) {
        Intrinsics.checkNotNullParameter((Object)callbackManager, (String)"callbackManager");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (!(callbackManager instanceof CallbackManagerImpl)) {
            throw new FacebookException("Unexpected CallbackManager, please use the provided Factory.");
        }
        this.memorizeCallbackManager(callbackManager);
        this.registerCallbackImpl((CallbackManagerImpl)callbackManager, callback);
    }

    @Override
    public void registerCallback(@NotNull CallbackManager callbackManager, @NotNull FacebookCallback<RESULT> callback, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)callbackManager, (String)"callbackManager");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.memorizeCallbackManager(callbackManager);
        this.setRequestCode(requestCode);
        this.registerCallback(callbackManager, callback);
    }

    protected abstract void registerCallbackImpl(@NotNull CallbackManagerImpl var1, @NotNull FacebookCallback<RESULT> var2);

    public final int getRequestCode() {
        return this.requestCodeField;
    }

    public final void setRequestCode(int value) {
        if (!(!FacebookSdk.isFacebookRequestCode((int)value))) {
            boolean bl = false;
            String string2 = "Request code " + value + " cannot be within the range reserved by the Facebook SDK.";
            throw new IllegalArgumentException(string2.toString());
        }
        this.requestCodeField = value;
    }

    @Override
    public boolean canShow(CONTENT content) {
        return this.canShowImpl(content, BASE_AUTOMATIC_MODE);
    }

    protected boolean canShowImpl(CONTENT content, @NotNull Object mode) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        boolean anyModeAllowed = mode == BASE_AUTOMATIC_MODE;
        for (ModeHandler handler : this.cachedModeHandlers()) {
            if (!anyModeAllowed && !Utility.areObjectsEqual((Object)handler.getMode(), (Object)mode) || !handler.canShow(content, false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void show(CONTENT content) {
        this.showImpl(content, BASE_AUTOMATIC_MODE);
    }

    @NotNull
    protected final ActivityResultContract<CONTENT, CallbackManager.ActivityResultParameters> createActivityResultContractForShowingDialog(@Nullable CallbackManager callbackManager, @NotNull Object mode) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        return new ActivityResultContract<CONTENT, CallbackManager.ActivityResultParameters>(this, mode, callbackManager){
            final /* synthetic */ FacebookDialogBase<CONTENT, RESULT> this$0;
            final /* synthetic */ Object $mode;
            final /* synthetic */ CallbackManager $callbackManager;
            {
                this.this$0 = $receiver;
                this.$mode = $mode;
                this.$callbackManager = $callbackManager;
            }

            @NotNull
            public Intent createIntent(@NotNull Context context, CONTENT content) {
                Intent intent;
                AppCall appCall;
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                AppCall appCall2 = appCall = FacebookDialogBase.access$createAppCallForMode(this.this$0, content, this.$mode);
                Object object = intent = appCall2 != null ? appCall2.getRequestIntent() : null;
                if (intent != null) {
                    appCall.setPending();
                    return intent;
                }
                throw new FacebookException("Content " + content + " is not supported");
            }

            @NotNull
            public CallbackManager.ActivityResultParameters parseResult(int resultCode, @Nullable Intent intent) {
                block0: {
                    CallbackManager callbackManager = this.$callbackManager;
                    if (callbackManager == null) break block0;
                    callbackManager.onActivityResult(this.this$0.getRequestCode(), resultCode, intent);
                }
                return new CallbackManager.ActivityResultParameters(this.this$0.getRequestCode(), resultCode, intent);
            }
        };
    }

    @Override
    @NotNull
    public ActivityResultContract<CONTENT, CallbackManager.ActivityResultParameters> createActivityResultContractForShowingDialog(@Nullable CallbackManager callbackManager) {
        return this.createActivityResultContractForShowingDialog(callbackManager, BASE_AUTOMATIC_MODE);
    }

    protected void showImpl(CONTENT content, @NotNull Object mode) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        AppCall appCall = this.createAppCallForMode(content, mode);
        if (appCall != null) {
            if (this.getActivityContext() instanceof ActivityResultRegistryOwner) {
                Activity activity = this.getActivityContext();
                Intrinsics.checkNotNull((Object)activity, (String)"null cannot be cast to non-null type androidx.activity.result.ActivityResultRegistryOwner");
                ActivityResultRegistryOwner registryOwner = (ActivityResultRegistryOwner)activity;
                ActivityResultRegistry activityResultRegistry = registryOwner.getActivityResultRegistry();
                Intrinsics.checkNotNullExpressionValue((Object)activityResultRegistry, (String)"registryOwner.activityResultRegistry");
                DialogPresenter.present(appCall, activityResultRegistry, this.callbackManager);
                appCall.setPending();
            } else if (this.fragmentWrapper != null) {
                DialogPresenter.present(appCall, this.fragmentWrapper);
            } else if (this.activity != null) {
                DialogPresenter.present(appCall, this.activity);
            }
        } else {
            String errorMessage = "No code path should ever result in a null appCall";
            Log.e((String)TAG, (String)errorMessage);
            if (!(!FacebookSdk.isDebugEnabled())) {
                boolean bl = false;
                String string2 = errorMessage;
                throw new IllegalStateException(string2.toString());
            }
        }
    }

    @Nullable
    protected final Activity getActivityContext() {
        Object object = this.activity;
        if (object == null) {
            FragmentWrapper fragmentWrapper = this.fragmentWrapper;
            object = fragmentWrapper != null ? fragmentWrapper.getActivity() : null;
        }
        return object;
    }

    protected final void startActivityForResult(@NotNull Intent intent, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        String error = null;
        Activity activity = this.getActivityContext();
        if (activity instanceof ActivityResultRegistryOwner) {
            ActivityResultRegistry activityResultRegistry = ((ActivityResultRegistryOwner)activity).getActivityResultRegistry();
            Intrinsics.checkNotNullExpressionValue((Object)activityResultRegistry, (String)"activity as ActivityResu\u2026r).activityResultRegistry");
            DialogPresenter.startActivityForResultWithAndroidX(activityResultRegistry, this.callbackManager, intent, requestCode);
        } else if (activity != null) {
            activity.startActivityForResult(intent, requestCode);
        } else if (this.fragmentWrapper != null) {
            this.fragmentWrapper.startActivityForResult(intent, requestCode);
        } else {
            error = "Failed to find Activity or Fragment to startActivityForResult ";
        }
        if (error != null) {
            String string2 = this.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this.javaClass.name");
            Logger.Companion.log(LoggingBehavior.DEVELOPER_ERRORS, 6, string2, error);
        }
    }

    private final AppCall createAppCallForMode(CONTENT content, Object mode) {
        boolean anyModeAllowed = mode == BASE_AUTOMATIC_MODE;
        AppCall appCall = null;
        for (ModeHandler handler : this.cachedModeHandlers()) {
            if (!anyModeAllowed && !Utility.areObjectsEqual((Object)handler.getMode(), (Object)mode) || !handler.canShow(content, true)) continue;
            try {
                appCall = handler.createAppCall(content);
                break;
            }
            catch (FacebookException e) {
                appCall = this.createBaseAppCall();
                DialogPresenter.setupAppCallForValidationError(appCall, e);
                break;
            }
        }
        if (appCall == null) {
            appCall = this.createBaseAppCall();
            DialogPresenter.setupAppCallForCannotShowError(appCall);
        }
        return appCall;
    }

    private final void memorizeCallbackManager(CallbackManager callbackManager) {
        if (this.callbackManager == null) {
            this.callbackManager = callbackManager;
        } else if (this.callbackManager != callbackManager) {
            Log.w((String)TAG, (String)"You're registering a callback on a Facebook dialog with two different callback managers. It's almost wrong and may cause unexpected results. Only the first callback manager will be used for handling activity result with androidx.");
        }
    }

    private final List<ModeHandler> cachedModeHandlers() {
        if (this.modeHandlers == null) {
            this.modeHandlers = this.getOrderedModeHandlers();
        }
        List<ModeHandler> list = this.modeHandlers;
        Intrinsics.checkNotNull(list, (String)"null cannot be cast to non-null type kotlin.collections.List<com.facebook.internal.FacebookDialogBase.ModeHandler<CONTENT of com.facebook.internal.FacebookDialogBase, RESULT of com.facebook.internal.FacebookDialogBase>>");
        return list;
    }

    @NotNull
    protected abstract List<ModeHandler> getOrderedModeHandlers();

    @NotNull
    protected abstract AppCall createBaseAppCall();

    public static final /* synthetic */ AppCall access$createAppCallForMode(FacebookDialogBase $this, Object content, Object mode) {
        return $this.createAppCallForMode(content, mode);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/internal/FacebookDialogBase$Companion;", "", "()V", "BASE_AUTOMATIC_MODE", "TAG", "", "facebook-common_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00a4\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\tH&\u00a2\u0006\u0002\u0010\fJ\u0017\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u000fR\u001a\u0010\u0003\u001a\u00020\u0001X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/facebook/internal/FacebookDialogBase$ModeHandler;", "", "(Lcom/facebook/internal/FacebookDialogBase;)V", "mode", "getMode", "()Ljava/lang/Object;", "setMode", "(Ljava/lang/Object;)V", "canShow", "", "content", "isBestEffort", "(Ljava/lang/Object;Z)Z", "createAppCall", "Lcom/facebook/internal/AppCall;", "(Ljava/lang/Object;)Lcom/facebook/internal/AppCall;", "facebook-common_release"})
    protected abstract class ModeHandler {
        @NotNull
        private Object mode = BASE_AUTOMATIC_MODE;

        @NotNull
        public Object getMode() {
            return this.mode;
        }

        public void setMode(@NotNull Object object) {
            Intrinsics.checkNotNullParameter((Object)object, (String)"<set-?>");
            this.mode = object;
        }

        public abstract boolean canShow(CONTENT var1, boolean var2);

        @Nullable
        public abstract AppCall createAppCall(CONTENT var1);
    }
}

