/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.text.TextUtils;
import com.facebook.appevents.InternalAppEventsLogger;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import com.facebook.login.LoginClient;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 (2\u00020\u0001:\u0001(B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J`\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0018\u0010\u0013\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0007J(\u0010\u0016\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0007J(\u0010\u0017\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0007J\\\u0010\u0018\u001a\u00020\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00142\b\u0010\u0010\u001a\u0004\u0018\u00010\u001a2\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0007J\u0012\u0010\u001e\u001a\u00020\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u0002J\u0018\u0010\u001f\u001a\u00020\r2\b\u0010 \u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010!\u001a\u00020\r2\b\u0010 \u001a\u0004\u0018\u00010\u0005J\u0010\u0010\"\u001a\u00020\r2\b\u0010 \u001a\u0004\u0018\u00010\u0005J\u0010\u0010#\u001a\u00020\r2\b\u0010 \u001a\u0004\u0018\u00010\u0005J\u001c\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020&2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0007J(\u0010'\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/facebook/login/LoginLogger;", "", "context", "Landroid/content/Context;", "applicationId", "", "(Landroid/content/Context;Ljava/lang/String;)V", "getApplicationId", "()Ljava/lang/String;", "facebookVersion", "logger", "Lcom/facebook/appevents/InternalAppEventsLogger;", "logAuthorizationMethodComplete", "", "authId", "method", "result", "errorMessage", "errorCode", "loggingExtras", "", "eventName", "logAuthorizationMethodNotTried", "logAuthorizationMethodStart", "logCompleteLogin", "loginRequestId", "Lcom/facebook/login/LoginClient$Result$Code;", "resultExtras", "exception", "Ljava/lang/Exception;", "logHeartbeatEvent", "logLoginStatusError", "loggerRef", "logLoginStatusFailure", "logLoginStatusStart", "logLoginStatusSuccess", "logStartLogin", "pendingLoginRequest", "Lcom/facebook/login/LoginClient$Request;", "logUnexpectedError", "Companion", "facebook-common_release"})
public final class LoginLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String applicationId;
    @NotNull
    private final InternalAppEventsLogger logger;
    @Nullable
    private String facebookVersion;
    @NotNull
    public static final String EVENT_NAME_LOGIN_METHOD_START = "fb_mobile_login_method_start";
    @NotNull
    public static final String EVENT_NAME_LOGIN_METHOD_COMPLETE = "fb_mobile_login_method_complete";
    @NotNull
    public static final String EVENT_NAME_LOGIN_METHOD_NOT_TRIED = "fb_mobile_login_method_not_tried";
    @NotNull
    public static final String EVENT_PARAM_METHOD_RESULT_SKIPPED = "skipped";
    @NotNull
    public static final String EVENT_NAME_LOGIN_START = "fb_mobile_login_start";
    @NotNull
    public static final String EVENT_NAME_LOGIN_COMPLETE = "fb_mobile_login_complete";
    @NotNull
    public static final String EVENT_NAME_LOGIN_STATUS_START = "fb_mobile_login_status_start";
    @NotNull
    public static final String EVENT_NAME_LOGIN_STATUS_COMPLETE = "fb_mobile_login_status_complete";
    @NotNull
    public static final String EVENT_NAME_LOGIN_HEARTBEAT = "fb_mobile_login_heartbeat";
    @NotNull
    public static final String EVENT_NAME_FOA_LOGIN_METHOD_START = "foa_mobile_login_method_start";
    @NotNull
    public static final String EVENT_NAME_FOA_LOGIN_METHOD_COMPLETE = "foa_mobile_login_method_complete";
    @NotNull
    public static final String EVENT_NAME_FOA_LOGIN_METHOD_NOT_TRIED = "foa_mobile_login_method_not_tried";
    @NotNull
    public static final String EVENT_PARAM_FOA_METHOD_RESULT_SKIPPED = "foa_skipped";
    @NotNull
    public static final String EVENT_NAME_FOA_LOGIN_START = "foa_mobile_login_start";
    @NotNull
    public static final String EVENT_NAME_FOA_LOGIN_COMPLETE = "foa_mobile_login_complete";
    @NotNull
    public static final String EVENT_PARAM_AUTH_LOGGER_ID = "0_auth_logger_id";
    @NotNull
    public static final String EVENT_PARAM_TIMESTAMP = "1_timestamp_ms";
    @NotNull
    public static final String EVENT_PARAM_LOGIN_RESULT = "2_result";
    @NotNull
    public static final String EVENT_PARAM_METHOD = "3_method";
    @NotNull
    public static final String EVENT_PARAM_ERROR_CODE = "4_error_code";
    @NotNull
    public static final String EVENT_PARAM_ERROR_MESSAGE = "5_error_message";
    @NotNull
    public static final String EVENT_PARAM_EXTRAS = "6_extras";
    @NotNull
    public static final String EVENT_PARAM_CHALLENGE = "7_challenge";
    @NotNull
    public static final String EVENT_EXTRAS_TRY_LOGIN_ACTIVITY = "try_login_activity";
    @NotNull
    public static final String EVENT_EXTRAS_MISSING_INTERNET_PERMISSION = "no_internet_permission";
    @NotNull
    public static final String EVENT_EXTRAS_NOT_TRIED = "not_tried";
    @NotNull
    public static final String EVENT_EXTRAS_NEW_PERMISSIONS = "new_permissions";
    @NotNull
    public static final String EVENT_EXTRAS_LOGIN_BEHAVIOR = "login_behavior";
    @NotNull
    public static final String EVENT_EXTRAS_REQUEST_CODE = "request_code";
    @NotNull
    public static final String EVENT_EXTRAS_PERMISSIONS = "permissions";
    @NotNull
    public static final String EVENT_EXTRAS_DEFAULT_AUDIENCE = "default_audience";
    @NotNull
    public static final String EVENT_EXTRAS_IS_REAUTHORIZE = "isReauthorize";
    @NotNull
    public static final String EVENT_EXTRAS_FACEBOOK_VERSION = "facebookVersion";
    @NotNull
    public static final String EVENT_EXTRAS_FAILURE = "failure";
    @NotNull
    public static final String EVENT_EXTRAS_TARGET_APP = "target_app";
    @NotNull
    public static final String FACEBOOK_PACKAGE_NAME = "com.facebook.katana";
    private static final ScheduledExecutorService worker = Executors.newSingleThreadScheduledExecutor();

    public LoginLogger(@NotNull Context context, @NotNull String applicationId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        this.applicationId = applicationId;
        this.logger = new InternalAppEventsLogger(context, this.applicationId);
        try {
            PackageInfo facebookInfo;
            PackageManager packageManager = context.getPackageManager();
            if (packageManager != null && (facebookInfo = packageManager.getPackageInfo(FACEBOOK_PACKAGE_NAME, 0)) != null) {
                this.facebookVersion = facebookInfo.versionName;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
        }
    }

    @NotNull
    public final String getApplicationId() {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return null;
        }
        try {
            return this.applicationId;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final void logStartLogin(@NotNull LoginClient.Request request, @Nullable String string2) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void eventName;
            void pendingLoginRequest;
            Intrinsics.checkNotNullParameter((Object)pendingLoginRequest, (String)"pendingLoginRequest");
            Bundle bundle = LoginLogger.Companion.newAuthorizationLoggingBundle(pendingLoginRequest.getAuthId());
            try {
                JSONObject extras = new JSONObject();
                extras.put(EVENT_EXTRAS_LOGIN_BEHAVIOR, (Object)pendingLoginRequest.getLoginBehavior().toString());
                extras.put(EVENT_EXTRAS_REQUEST_CODE, LoginClient.Companion.getLoginRequestCode());
                extras.put(EVENT_EXTRAS_PERMISSIONS, (Object)TextUtils.join((CharSequence)",", (Iterable)pendingLoginRequest.getPermissions()));
                extras.put(EVENT_EXTRAS_DEFAULT_AUDIENCE, (Object)pendingLoginRequest.getDefaultAudience().toString());
                extras.put(EVENT_EXTRAS_IS_REAUTHORIZE, pendingLoginRequest.isRerequest());
                if (this.facebookVersion != null) {
                    extras.put(EVENT_EXTRAS_FACEBOOK_VERSION, (Object)this.facebookVersion);
                }
                if (pendingLoginRequest.getLoginTargetApp() != null) {
                    extras.put(EVENT_EXTRAS_TARGET_APP, (Object)pendingLoginRequest.getLoginTargetApp().toString());
                }
                bundle.putString(EVENT_PARAM_EXTRAS, extras.toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            this.logger.logEventImplicitly((String)eventName, bundle);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    public static /* synthetic */ void logStartLogin$default(LoginLogger loginLogger, LoginClient.Request request, String string2, int n, Object object) {
        if (CrashShieldHandler.isObjectCrashing(LoginLogger.class)) {
            return;
        }
        try {
            if ((n & 2) != 0) {
                string2 = EVENT_NAME_LOGIN_START;
            }
            loginLogger.logStartLogin(request, string2);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, LoginLogger.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final void logCompleteLogin(@Nullable String string2, @NotNull Map<String, String> map, @Nullable LoginClient.Result.Code code, @Nullable Map<String, String> map2, @Nullable Exception exception, @Nullable String string3) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void eventName;
            void resultExtras;
            void exception2;
            void var8_8;
            void result;
            void loginRequestId;
            void loggingExtras;
            Intrinsics.checkNotNullParameter((Object)loggingExtras, (String)"loggingExtras");
            Bundle bundle = LoginLogger.Companion.newAuthorizationLoggingBundle((String)loginRequestId);
            if (result != null) {
                bundle.putString(EVENT_PARAM_LOGIN_RESULT, result.getLoggingValue());
            }
            if (((var8_8 = exception2) == null ? null : var8_8.getMessage()) != null) {
                bundle.putString(EVENT_PARAM_ERROR_MESSAGE, exception2.getMessage());
            }
            JSONObject jsonObject = null;
            Iterator iterator = loggingExtras;
            boolean bl = false;
            if (!iterator.isEmpty()) {
                jsonObject = new JSONObject((Map)loggingExtras);
            }
            if (resultExtras != null) {
                if (jsonObject == null) {
                    jsonObject = new JSONObject();
                }
                try {
                    Map.Entry entry = resultExtras;
                    boolean bl2 = false;
                    iterator = entry.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry2 = entry = iterator.next();
                        boolean bl3 = false;
                        String key = (String)entry2.getKey();
                        Map.Entry entry3 = entry;
                        boolean bl4 = false;
                        String value = (String)entry3.getValue();
                        if (key == null) continue;
                        jsonObject.put(key, (Object)value);
                    }
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            if (jsonObject != null) {
                bundle.putString(EVENT_PARAM_EXTRAS, jsonObject.toString());
            }
            this.logger.logEventImplicitly((String)eventName, bundle);
            if (result == LoginClient.Result.Code.SUCCESS) {
                this.logHeartbeatEvent((String)loginRequestId);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    public static /* synthetic */ void logCompleteLogin$default(LoginLogger loginLogger, String string2, Map map, LoginClient.Result.Code code, Map map2, Exception exception, String string3, int n, Object object) {
        if (CrashShieldHandler.isObjectCrashing(LoginLogger.class)) {
            return;
        }
        try {
            if ((n & 0x20) != 0) {
                string3 = EVENT_NAME_LOGIN_COMPLETE;
            }
            loginLogger.logCompleteLogin(string2, map, code, map2, exception, string3);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, LoginLogger.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void logHeartbeatEvent(String string2) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void loginRequestId;
            Bundle bundle = LoginLogger.Companion.newAuthorizationLoggingBundle((String)loginRequestId);
            Runnable runnable = () -> LoginLogger.logHeartbeatEvent$lambda-0(this, bundle);
            worker.schedule(runnable, 5L, TimeUnit.SECONDS);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final void logAuthorizationMethodStart(@Nullable String string2, @Nullable String string3, @Nullable String string4) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void eventName;
            void method;
            void authId;
            Bundle bundle = LoginLogger.Companion.newAuthorizationLoggingBundle((String)authId);
            bundle.putString(EVENT_PARAM_METHOD, (String)method);
            this.logger.logEventImplicitly((String)eventName, bundle);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    public static /* synthetic */ void logAuthorizationMethodStart$default(LoginLogger loginLogger, String string2, String string3, String string4, int n, Object object) {
        if (CrashShieldHandler.isObjectCrashing(LoginLogger.class)) {
            return;
        }
        try {
            if ((n & 4) != 0) {
                string4 = EVENT_NAME_LOGIN_METHOD_START;
            }
            loginLogger.logAuthorizationMethodStart(string2, string3, string4);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, LoginLogger.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final void logAuthorizationMethodComplete(@Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6, @Nullable Map<String, String> map, @Nullable String string7) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void eventName;
            void method;
            void loggingExtras;
            void errorCode;
            void errorMessage;
            void result;
            void authId;
            Bundle bundle = LoginLogger.Companion.newAuthorizationLoggingBundle((String)authId);
            if (result != null) {
                bundle.putString(EVENT_PARAM_LOGIN_RESULT, (String)result);
            }
            if (errorMessage != null) {
                bundle.putString(EVENT_PARAM_ERROR_MESSAGE, (String)errorMessage);
            }
            if (errorCode != null) {
                bundle.putString(EVENT_PARAM_ERROR_CODE, (String)errorCode);
            }
            if (loggingExtras != null) {
                void var9_9 = loggingExtras;
                boolean bl = false;
                if (!var9_9.isEmpty()) {
                    Map map2;
                    void $this$filterKeys$iv = loggingExtras;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap result$iv = new LinkedHashMap();
                    void var13_14 = $this$filterKeys$iv;
                    boolean bl2 = false;
                    for (Map.Entry entry$iv : var13_14.entrySet()) {
                        String it = (String)entry$iv.getKey();
                        boolean bl3 = false;
                        if (!(it != null)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    Map map3 = map2 = (Map)result$iv;
                    JSONObject jsonObject = new JSONObject(map3);
                    bundle.putString(EVENT_PARAM_EXTRAS, jsonObject.toString());
                }
            }
            bundle.putString(EVENT_PARAM_METHOD, (String)method);
            this.logger.logEventImplicitly((String)eventName, bundle);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    public static /* synthetic */ void logAuthorizationMethodComplete$default(LoginLogger loginLogger, String string2, String string3, String string4, String string5, String string6, Map map, String string7, int n, Object object) {
        if (CrashShieldHandler.isObjectCrashing(LoginLogger.class)) {
            return;
        }
        try {
            if ((n & 0x40) != 0) {
                string7 = EVENT_NAME_LOGIN_METHOD_COMPLETE;
            }
            loginLogger.logAuthorizationMethodComplete(string2, string3, string4, string5, string6, map, string7);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, LoginLogger.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final void logAuthorizationMethodNotTried(@Nullable String string2, @Nullable String string3, @Nullable String string4) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void eventName;
            void method;
            void authId;
            Bundle bundle = LoginLogger.Companion.newAuthorizationLoggingBundle((String)authId);
            bundle.putString(EVENT_PARAM_METHOD, (String)method);
            this.logger.logEventImplicitly((String)eventName, bundle);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    public static /* synthetic */ void logAuthorizationMethodNotTried$default(LoginLogger loginLogger, String string2, String string3, String string4, int n, Object object) {
        if (CrashShieldHandler.isObjectCrashing(LoginLogger.class)) {
            return;
        }
        try {
            if ((n & 4) != 0) {
                string4 = EVENT_NAME_LOGIN_METHOD_NOT_TRIED;
            }
            loginLogger.logAuthorizationMethodNotTried(string2, string3, string4);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, LoginLogger.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void logLoginStatusStart(@Nullable String string2) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void loggerRef;
            Bundle bundle = LoginLogger.Companion.newAuthorizationLoggingBundle((String)loggerRef);
            this.logger.logEventImplicitly(EVENT_NAME_LOGIN_STATUS_START, bundle);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void logLoginStatusSuccess(@Nullable String string2) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void loggerRef;
            Bundle bundle = LoginLogger.Companion.newAuthorizationLoggingBundle((String)loggerRef);
            bundle.putString(EVENT_PARAM_LOGIN_RESULT, LoginClient.Result.Code.SUCCESS.getLoggingValue());
            this.logger.logEventImplicitly(EVENT_NAME_LOGIN_STATUS_COMPLETE, bundle);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void logLoginStatusFailure(@Nullable String string2) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void loggerRef;
            Bundle bundle = LoginLogger.Companion.newAuthorizationLoggingBundle((String)loggerRef);
            bundle.putString(EVENT_PARAM_LOGIN_RESULT, EVENT_EXTRAS_FAILURE);
            this.logger.logEventImplicitly(EVENT_NAME_LOGIN_STATUS_COMPLETE, bundle);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void logLoginStatusError(@Nullable String string2, @NotNull Exception exception) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void loggerRef;
            void exception2;
            Intrinsics.checkNotNullParameter((Object)exception2, (String)"exception");
            Bundle bundle = LoginLogger.Companion.newAuthorizationLoggingBundle((String)loggerRef);
            bundle.putString(EVENT_PARAM_LOGIN_RESULT, LoginClient.Result.Code.ERROR.getLoggingValue());
            bundle.putString(EVENT_PARAM_ERROR_MESSAGE, exception2.toString());
            this.logger.logEventImplicitly(EVENT_NAME_LOGIN_STATUS_COMPLETE, bundle);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final void logUnexpectedError(@Nullable String string2, @Nullable String string3, @Nullable String string4) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void eventName;
            void method;
            void errorMessage;
            Bundle bundle = LoginLogger.Companion.newAuthorizationLoggingBundle("");
            bundle.putString(EVENT_PARAM_LOGIN_RESULT, LoginClient.Result.Code.ERROR.getLoggingValue());
            bundle.putString(EVENT_PARAM_ERROR_MESSAGE, (String)errorMessage);
            bundle.putString(EVENT_PARAM_METHOD, (String)method);
            this.logger.logEventImplicitly((String)eventName, bundle);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    public static /* synthetic */ void logUnexpectedError$default(LoginLogger loginLogger, String string2, String string3, String string4, int n, Object object) {
        if (CrashShieldHandler.isObjectCrashing(LoginLogger.class)) {
            return;
        }
        try {
            if ((n & 4) != 0) {
                string4 = "";
            }
            loginLogger.logUnexpectedError(string2, string3, string4);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, LoginLogger.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final void logStartLogin(@NotNull LoginClient.Request request) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void pendingLoginRequest;
            Intrinsics.checkNotNullParameter((Object)pendingLoginRequest, (String)"pendingLoginRequest");
            LoginLogger.logStartLogin$default(this, (LoginClient.Request)pendingLoginRequest, null, 2, null);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final void logCompleteLogin(@Nullable String string2, @NotNull Map<String, String> map, @Nullable LoginClient.Result.Code code, @Nullable Map<String, String> map2, @Nullable Exception exception) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void exception2;
            void resultExtras;
            void result;
            void loginRequestId;
            void loggingExtras;
            Intrinsics.checkNotNullParameter((Object)loggingExtras, (String)"loggingExtras");
            LoginLogger.logCompleteLogin$default(this, (String)loginRequestId, (Map)loggingExtras, (LoginClient.Result.Code)result, (Map)resultExtras, (Exception)exception2, null, 32, null);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final void logAuthorizationMethodStart(@Nullable String string2, @Nullable String string3) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void method;
            void authId;
            LoginLogger.logAuthorizationMethodStart$default(this, (String)authId, (String)method, null, 4, null);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final void logAuthorizationMethodComplete(@Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6, @Nullable Map<String, String> map) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void loggingExtras;
            void errorCode;
            void errorMessage;
            void result;
            void method;
            void authId;
            LoginLogger.logAuthorizationMethodComplete$default(this, (String)authId, (String)method, (String)result, (String)errorMessage, (String)errorCode, (Map)loggingExtras, null, 64, null);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final void logAuthorizationMethodNotTried(@Nullable String string2, @Nullable String string3) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void method;
            void authId;
            LoginLogger.logAuthorizationMethodNotTried$default(this, (String)authId, (String)method, null, 4, null);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final void logUnexpectedError(@Nullable String string2, @Nullable String string3) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void errorMessage;
            void eventName;
            LoginLogger.logUnexpectedError$default(this, (String)eventName, (String)errorMessage, null, 4, null);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void logHeartbeatEvent$lambda-0(LoginLogger loginLogger, Bundle bundle) {
        if (CrashShieldHandler.isObjectCrashing(LoginLogger.class)) {
            return;
        }
        try {
            void $bundle;
            LoginLogger this$0;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$bundle, (String)"$bundle");
            this$0.logger.logEventImplicitly(EVENT_NAME_LOGIN_HEARTBEAT, (Bundle)$bundle);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, LoginLogger.class);
            return;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010(\u001a\n **\u0004\u0018\u00010)0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/facebook/login/LoginLogger$Companion;", "", "()V", "EVENT_EXTRAS_DEFAULT_AUDIENCE", "", "EVENT_EXTRAS_FACEBOOK_VERSION", "EVENT_EXTRAS_FAILURE", "EVENT_EXTRAS_IS_REAUTHORIZE", "EVENT_EXTRAS_LOGIN_BEHAVIOR", "EVENT_EXTRAS_MISSING_INTERNET_PERMISSION", "EVENT_EXTRAS_NEW_PERMISSIONS", "EVENT_EXTRAS_NOT_TRIED", "EVENT_EXTRAS_PERMISSIONS", "EVENT_EXTRAS_REQUEST_CODE", "EVENT_EXTRAS_TARGET_APP", "EVENT_EXTRAS_TRY_LOGIN_ACTIVITY", "EVENT_NAME_FOA_LOGIN_COMPLETE", "EVENT_NAME_FOA_LOGIN_METHOD_COMPLETE", "EVENT_NAME_FOA_LOGIN_METHOD_NOT_TRIED", "EVENT_NAME_FOA_LOGIN_METHOD_START", "EVENT_NAME_FOA_LOGIN_START", "EVENT_NAME_LOGIN_COMPLETE", "EVENT_NAME_LOGIN_HEARTBEAT", "EVENT_NAME_LOGIN_METHOD_COMPLETE", "EVENT_NAME_LOGIN_METHOD_NOT_TRIED", "EVENT_NAME_LOGIN_METHOD_START", "EVENT_NAME_LOGIN_START", "EVENT_NAME_LOGIN_STATUS_COMPLETE", "EVENT_NAME_LOGIN_STATUS_START", "EVENT_PARAM_AUTH_LOGGER_ID", "EVENT_PARAM_CHALLENGE", "EVENT_PARAM_ERROR_CODE", "EVENT_PARAM_ERROR_MESSAGE", "EVENT_PARAM_EXTRAS", "EVENT_PARAM_FOA_METHOD_RESULT_SKIPPED", "EVENT_PARAM_LOGIN_RESULT", "EVENT_PARAM_METHOD", "EVENT_PARAM_METHOD_RESULT_SKIPPED", "EVENT_PARAM_TIMESTAMP", "FACEBOOK_PACKAGE_NAME", "worker", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "newAuthorizationLoggingBundle", "Landroid/os/Bundle;", "authLoggerId", "facebook-common_release"})
    public static final class Companion {
        private Companion() {
        }

        private final Bundle newAuthorizationLoggingBundle(String authLoggerId) {
            Bundle bundle = new Bundle();
            bundle.putLong(LoginLogger.EVENT_PARAM_TIMESTAMP, System.currentTimeMillis());
            bundle.putString(LoginLogger.EVENT_PARAM_AUTH_LOGGER_ID, authLoggerId);
            bundle.putString(LoginLogger.EVENT_PARAM_METHOD, "");
            bundle.putString(LoginLogger.EVENT_PARAM_LOGIN_RESULT, "");
            bundle.putString(LoginLogger.EVENT_PARAM_ERROR_MESSAGE, "");
            bundle.putString(LoginLogger.EVENT_PARAM_ERROR_CODE, "");
            bundle.putString(LoginLogger.EVENT_PARAM_EXTRAS, "");
            return bundle;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

