/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.devicerequests.internal;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.net.nsd.NsdManager;
import android.net.nsd.NsdServiceInfo;
import android.os.Build;
import com.facebook.FacebookSdk;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.SmartLoginOption;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010\u0014\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0003J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0004H\u0007J\b\u0010\u0018\u001a\u00020\u0004H\u0007J\u001e\u0010\u0018\u001a\u00020\u00042\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001aH\u0007J\b\u0010\u001b\u001a\u00020\u001cH\u0007J\u0012\u0010\u001d\u001a\u00020\u001c2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010\u001e\u001a\u00020\u001c2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \f*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\r\u001a\"\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u000f0\u000ej\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/facebook/devicerequests/internal/DeviceRequestsHelper;", "", "()V", "DEVICE_INFO_DEVICE", "", "DEVICE_INFO_MODEL", "DEVICE_INFO_PARAM", "DEVICE_TARGET_USER_ID", "SDK_FLAVOR", "SDK_HEADER", "SERVICE_TYPE", "TAG", "kotlin.jvm.PlatformType", "deviceRequestsListeners", "Ljava/util/HashMap;", "Landroid/net/nsd/NsdManager$RegistrationListener;", "Lkotlin/collections/HashMap;", "cleanUpAdvertisementService", "", "userCode", "cleanUpAdvertisementServiceImpl", "generateQRCode", "Landroid/graphics/Bitmap;", "url", "getDeviceInfo", "deviceInfo", "", "isAvailable", "", "startAdvertisementService", "startAdvertisementServiceImpl", "facebook-common_release"})
public final class DeviceRequestsHelper {
    @NotNull
    public static final DeviceRequestsHelper INSTANCE = new DeviceRequestsHelper();
    private static final String TAG = DeviceRequestsHelper.class.getCanonicalName();
    @NotNull
    public static final String DEVICE_INFO_PARAM = "device_info";
    @NotNull
    public static final String DEVICE_TARGET_USER_ID = "target_user_id";
    @NotNull
    public static final String DEVICE_INFO_DEVICE = "device";
    @NotNull
    public static final String DEVICE_INFO_MODEL = "model";
    @NotNull
    public static final String SDK_HEADER = "fbsdk";
    @NotNull
    public static final String SDK_FLAVOR = "android";
    @NotNull
    public static final String SERVICE_TYPE = "_fb._tcp.";
    @NotNull
    private static final HashMap<String, NsdManager.RegistrationListener> deviceRequestsListeners = new HashMap();

    private DeviceRequestsHelper() {
    }

    @JvmStatic
    @NotNull
    public static final String getDeviceInfo(@Nullable Map<String, String> map) {
        if (CrashShieldHandler.isObjectCrashing(DeviceRequestsHelper.class)) {
            return null;
        }
        try {
            Map deviceInfo;
            Object object = deviceInfo;
            Map deviceInfo2 = object == null ? (Map)new HashMap() : object;
            object = deviceInfo2;
            String string = DEVICE_INFO_DEVICE;
            String string2 = Build.DEVICE;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DEVICE");
            boolean bl = false;
            object.put(string, string2);
            object = deviceInfo2;
            string = DEVICE_INFO_MODEL;
            string2 = Build.MODEL;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MODEL");
            bl = false;
            object.put(string, string2);
            object = new JSONObject(deviceInfo2).toString();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"JSONObject(deviceInfo as Map<*, *>).toString()");
            return object;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, DeviceRequestsHelper.class);
            return null;
        }
    }

    @JvmStatic
    @NotNull
    public static final String getDeviceInfo() {
        if (CrashShieldHandler.isObjectCrashing(DeviceRequestsHelper.class)) {
            return null;
        }
        try {
            return DeviceRequestsHelper.getDeviceInfo(null);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, DeviceRequestsHelper.class);
            return null;
        }
    }

    @JvmStatic
    public static final boolean startAdvertisementService(@Nullable String string) {
        if (CrashShieldHandler.isObjectCrashing(DeviceRequestsHelper.class)) {
            return false;
        }
        try {
            String userCode;
            return INSTANCE.isAvailable() ? INSTANCE.startAdvertisementServiceImpl(userCode) : false;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, DeviceRequestsHelper.class);
            return false;
        }
    }

    @JvmStatic
    public static final boolean isAvailable() {
        if (CrashShieldHandler.isObjectCrashing(DeviceRequestsHelper.class)) {
            return false;
        }
        try {
            FetchedAppSettings settings = FetchedAppSettingsManager.getAppSettingsWithoutQuery((String)FacebookSdk.INSTANCE.getApplicationId());
            return Build.VERSION.SDK_INT >= 16 && settings != null && settings.getSmartLoginOptions().contains(SmartLoginOption.Enabled);
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, DeviceRequestsHelper.class);
            return false;
        }
    }

    @JvmStatic
    @Nullable
    public static final Bitmap generateQRCode(@Nullable String string) {
        if (CrashShieldHandler.isObjectCrashing(DeviceRequestsHelper.class)) {
            return null;
        }
        try {
            Map hints;
            Bitmap qrCode = null;
            Map map = hints = (Map)new EnumMap(EncodeHintType.class);
            EncodeHintType encodeHintType = EncodeHintType.MARGIN;
            Integer n = 2;
            boolean bl = false;
            map.put(encodeHintType, n);
            try {
                String url;
                BitMatrix matrix = new MultiFormatWriter().encode(url, BarcodeFormat.QR_CODE, 200, 200, hints);
                int h = matrix.getHeight();
                int w = matrix.getWidth();
                int[] pixels = new int[h * w];
                int n2 = 0;
                if (n2 < h) {
                    do {
                        int i = n2++;
                        int offset = i * w;
                        int n3 = 0;
                        if (n3 >= w) continue;
                        do {
                            int j;
                            int n4 = pixels[offset + j] = matrix.get(j = n3++, i) ? -16777216 : -1;
                        } while (n3 < w);
                    } while (n2 < h);
                }
                qrCode = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                qrCode.setPixels(pixels, 0, w, 0, 0, w, h);
            }
            catch (WriterException writerException) {
                // empty catch block
            }
            return qrCode;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, DeviceRequestsHelper.class);
            return null;
        }
    }

    @JvmStatic
    public static final void cleanUpAdvertisementService(@Nullable String string) {
        if (CrashShieldHandler.isObjectCrashing(DeviceRequestsHelper.class)) {
            return;
        }
        try {
            String userCode;
            INSTANCE.cleanUpAdvertisementServiceImpl(userCode);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, DeviceRequestsHelper.class);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=16)
    private final boolean startAdvertisementServiceImpl(String string) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return false;
        }
        try {
            void userCode;
            if (deviceRequestsListeners.containsKey(userCode)) {
                return true;
            }
            String sdkVersion = StringsKt.replace$default((String)FacebookSdk.INSTANCE.getSdkVersion(), (char)'.', (char)'|', (boolean)false, (int)4, null);
            String sdkVersionWithFlavor = Intrinsics.stringPlus((String)"android-", (Object)sdkVersion);
            String nsdServiceName = "fbsdk_" + sdkVersionWithFlavor + '_' + userCode;
            NsdServiceInfo nsdLoginAdvertisementService = new NsdServiceInfo();
            nsdLoginAdvertisementService.setServiceType(SERVICE_TYPE);
            nsdLoginAdvertisementService.setServiceName(nsdServiceName);
            nsdLoginAdvertisementService.setPort(80);
            Object object = FacebookSdk.INSTANCE.getApplicationContext().getSystemService("servicediscovery");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.net.nsd.NsdManager");
            }
            NsdManager nsdManager = (NsdManager)object;
            NsdManager.RegistrationListener nsdRegistrationListener2 = new NsdManager.RegistrationListener(nsdServiceName, (String)userCode){
                final /* synthetic */ String $nsdServiceName;
                final /* synthetic */ String $userCode;
                {
                    this.$nsdServiceName = $nsdServiceName;
                    this.$userCode = $userCode;
                }

                public void onServiceRegistered(@NotNull NsdServiceInfo NsdServiceInfo2) {
                    Intrinsics.checkNotNullParameter((Object)NsdServiceInfo2, (String)"NsdServiceInfo");
                    if (!Intrinsics.areEqual((Object)this.$nsdServiceName, (Object)NsdServiceInfo2.getServiceName())) {
                        DeviceRequestsHelper.cleanUpAdvertisementService(this.$userCode);
                    }
                }

                public void onServiceUnregistered(@NotNull NsdServiceInfo serviceInfo) {
                    Intrinsics.checkNotNullParameter((Object)serviceInfo, (String)"serviceInfo");
                }

                public void onRegistrationFailed(@NotNull NsdServiceInfo serviceInfo, int errorCode) {
                    Intrinsics.checkNotNullParameter((Object)serviceInfo, (String)"serviceInfo");
                    DeviceRequestsHelper.cleanUpAdvertisementService(this.$userCode);
                }

                public void onUnregistrationFailed(@NotNull NsdServiceInfo serviceInfo, int errorCode) {
                    Intrinsics.checkNotNullParameter((Object)serviceInfo, (String)"serviceInfo");
                }
            };
            Map map = deviceRequestsListeners;
            boolean bl = false;
            map.put(userCode, nsdRegistrationListener2);
            nsdManager.registerService(nsdLoginAdvertisementService, 1, nsdRegistrationListener2);
            return true;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=16)
    private final void cleanUpAdvertisementServiceImpl(String string) {
        if (CrashShieldHandler.isObjectCrashing((Object)this)) {
            return;
        }
        try {
            void userCode;
            NsdManager.RegistrationListener nsdRegistrationListener2 = deviceRequestsListeners.get(userCode);
            if (nsdRegistrationListener2 != null) {
                Object object = FacebookSdk.INSTANCE.getApplicationContext().getSystemService("servicediscovery");
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.net.nsd.NsdManager");
                }
                NsdManager nsdManager = (NsdManager)object;
                try {
                    nsdManager.unregisterService(nsdRegistrationListener2);
                }
                catch (IllegalArgumentException e) {
                    Utility.logd((String)TAG, (Exception)e);
                }
                deviceRequestsListeners.remove(userCode);
            }
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
            return;
        }
    }
}

