/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.internal;

import android.annotation.SuppressLint;
import android.net.Uri;
import android.os.Bundle;
import com.facebook.FacebookException;
import com.facebook.internal.Utility;
import com.facebook.share.internal.ShareFeedContent;
import com.facebook.share.internal.ShareInternalUtility;
import com.facebook.share.model.AppGroupCreationContent;
import com.facebook.share.model.GameRequestContent;
import com.facebook.share.model.ShareContent;
import com.facebook.share.model.ShareHashtag;
import com.facebook.share.model.ShareLinkContent;
import com.facebook.share.model.ShareOpenGraphAction;
import com.facebook.share.model.ShareOpenGraphContent;
import com.facebook.share.model.SharePhoto;
import com.facebook.share.model.SharePhotoContent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\u000f\u001a\u00020\u00042\u000e\u0010\u0010\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u0015"}, d2={"Lcom/facebook/share/internal/WebDialogParameters;", "", "()V", "create", "Landroid/os/Bundle;", "appGroupCreationContent", "Lcom/facebook/share/model/AppGroupCreationContent;", "gameRequestContent", "Lcom/facebook/share/model/GameRequestContent;", "shareLinkContent", "Lcom/facebook/share/model/ShareLinkContent;", "shareOpenGraphContent", "Lcom/facebook/share/model/ShareOpenGraphContent;", "sharePhotoContent", "Lcom/facebook/share/model/SharePhotoContent;", "createBaseParameters", "shareContent", "Lcom/facebook/share/model/ShareContent;", "createForFeed", "shareFeedContent", "Lcom/facebook/share/internal/ShareFeedContent;", "facebook-common_release"})
public final class WebDialogParameters {
    @NotNull
    public static final WebDialogParameters INSTANCE = new WebDialogParameters();

    private WebDialogParameters() {
    }

    @JvmStatic
    @NotNull
    public static final Bundle create(@NotNull AppGroupCreationContent appGroupCreationContent) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)appGroupCreationContent, (String)"appGroupCreationContent");
        Bundle webParams = new Bundle();
        Utility.putNonEmptyString((Bundle)webParams, (String)"name", (String)appGroupCreationContent.getName());
        Utility.putNonEmptyString((Bundle)webParams, (String)"description", (String)appGroupCreationContent.getDescription());
        AppGroupCreationContent.AppGroupPrivacy appGroupPrivacy = appGroupCreationContent.getAppGroupPrivacy();
        if (appGroupPrivacy == null) {
            string2 = null;
        } else {
            String string3 = appGroupPrivacy.toString();
            if (string3 == null) {
                string2 = null;
            } else {
                String string4 = string3;
                Locale locale = Locale.ENGLISH;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
                boolean bl = false;
                String string5 = string4.toLowerCase(locale);
                string2 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
            }
        }
        Utility.putNonEmptyString((Bundle)webParams, (String)"privacy", string2);
        return webParams;
    }

    @JvmStatic
    @NotNull
    public static final Bundle create(@NotNull GameRequestContent gameRequestContent) {
        String string2;
        boolean bl;
        Locale locale;
        String string3;
        String string4;
        String string5;
        Intrinsics.checkNotNullParameter((Object)gameRequestContent, (String)"gameRequestContent");
        Bundle webParams = new Bundle();
        Utility.putNonEmptyString((Bundle)webParams, (String)"message", (String)gameRequestContent.getMessage());
        Utility.putCommaSeparatedStringList((Bundle)webParams, (String)"to", gameRequestContent.getRecipients());
        Utility.putNonEmptyString((Bundle)webParams, (String)"title", (String)gameRequestContent.getTitle());
        Utility.putNonEmptyString((Bundle)webParams, (String)"data", (String)gameRequestContent.getData());
        Enum enum_ = gameRequestContent.getActionType();
        if (enum_ == null) {
            string5 = null;
        } else {
            string4 = enum_.toString();
            if (string4 == null) {
                string5 = null;
            } else {
                string3 = string4;
                locale = Locale.ENGLISH;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
                bl = false;
                String string6 = string3.toLowerCase(locale);
                string5 = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toLowerCase(locale)");
            }
        }
        Utility.putNonEmptyString((Bundle)webParams, (String)"action_type", string5);
        Utility.putNonEmptyString((Bundle)webParams, (String)"object_id", (String)gameRequestContent.getObjectId());
        enum_ = gameRequestContent.getFilters();
        if (enum_ == null) {
            string2 = null;
        } else {
            string4 = enum_.toString();
            if (string4 == null) {
                string2 = null;
            } else {
                string3 = string4;
                locale = Locale.ENGLISH;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
                bl = false;
                String string7 = string3.toLowerCase(locale);
                string2 = string7;
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).toLowerCase(locale)");
            }
        }
        Utility.putNonEmptyString((Bundle)webParams, (String)"filters", string2);
        Utility.putCommaSeparatedStringList((Bundle)webParams, (String)"suggestions", gameRequestContent.getSuggestions());
        return webParams;
    }

    @JvmStatic
    @NotNull
    public static final Bundle create(@NotNull ShareLinkContent shareLinkContent) {
        Intrinsics.checkNotNullParameter((Object)shareLinkContent, (String)"shareLinkContent");
        Bundle params = WebDialogParameters.createBaseParameters(shareLinkContent);
        Utility.putUri((Bundle)params, (String)"href", (Uri)shareLinkContent.getContentUrl());
        Utility.putNonEmptyString((Bundle)params, (String)"quote", (String)shareLinkContent.getQuote());
        return params;
    }

    @JvmStatic
    @NotNull
    public static final Bundle create(@NotNull ShareOpenGraphContent shareOpenGraphContent) {
        Intrinsics.checkNotNullParameter((Object)shareOpenGraphContent, (String)"shareOpenGraphContent");
        Bundle params = WebDialogParameters.createBaseParameters(shareOpenGraphContent);
        ShareOpenGraphAction shareOpenGraphAction = shareOpenGraphContent.getAction();
        Utility.putNonEmptyString((Bundle)params, (String)"action_type", (String)(shareOpenGraphAction == null ? null : shareOpenGraphAction.getActionType()));
        try {
            JSONObject ogJSON = ShareInternalUtility.toJSONObjectForWeb(shareOpenGraphContent);
            ogJSON = ShareInternalUtility.removeNamespacesFromOGJsonObject(ogJSON, false);
            JSONObject jSONObject = ogJSON;
            Utility.putNonEmptyString((Bundle)params, (String)"action_properties", (String)(jSONObject == null ? null : jSONObject.toString()));
        }
        catch (JSONException e) {
            throw new FacebookException("Unable to serialize the ShareOpenGraphContent to JSON", (Throwable)e);
        }
        return params;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Bundle create(@NotNull SharePhotoContent sharePhotoContent) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)sharePhotoContent, (String)"sharePhotoContent");
        Bundle params = WebDialogParameters.createBaseParameters(sharePhotoContent);
        List<SharePhoto> list = sharePhotoContent.getPhotos();
        List<SharePhoto> photos = list == null ? CollectionsKt.emptyList() : list;
        Iterable $this$map$iv = photos;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SharePhoto sharePhoto = (SharePhoto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = String.valueOf(it.getImageUrl());
            collection.add(string2);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] urls = stringArray;
        params.putStringArray("media", urls);
        return params;
    }

    @JvmStatic
    @NotNull
    public static final Bundle createBaseParameters(@NotNull ShareContent<?, ?> shareContent) {
        Intrinsics.checkNotNullParameter(shareContent, (String)"shareContent");
        Bundle params = new Bundle();
        ShareHashtag shareHashtag = shareContent.getShareHashtag();
        Utility.putNonEmptyString((Bundle)params, (String)"hashtag", (String)(shareHashtag == null ? null : shareHashtag.getHashtag()));
        return params;
    }

    @JvmStatic
    @SuppressLint(value={"DeprecatedMethod"})
    @NotNull
    public static final Bundle createForFeed(@NotNull ShareLinkContent shareLinkContent) {
        Intrinsics.checkNotNullParameter((Object)shareLinkContent, (String)"shareLinkContent");
        Bundle webParams = new Bundle();
        Utility.putNonEmptyString((Bundle)webParams, (String)"link", (String)Utility.getUriString((Uri)shareLinkContent.getContentUrl()));
        Utility.putNonEmptyString((Bundle)webParams, (String)"quote", (String)shareLinkContent.getQuote());
        ShareHashtag shareHashtag = shareLinkContent.getShareHashtag();
        Utility.putNonEmptyString((Bundle)webParams, (String)"hashtag", (String)(shareHashtag == null ? null : shareHashtag.getHashtag()));
        return webParams;
    }

    @JvmStatic
    @NotNull
    public static final Bundle createForFeed(@NotNull ShareFeedContent shareFeedContent) {
        Intrinsics.checkNotNullParameter((Object)shareFeedContent, (String)"shareFeedContent");
        Bundle webParams = new Bundle();
        Utility.putNonEmptyString((Bundle)webParams, (String)"to", (String)shareFeedContent.getToId());
        Utility.putNonEmptyString((Bundle)webParams, (String)"link", (String)shareFeedContent.getLink());
        Utility.putNonEmptyString((Bundle)webParams, (String)"picture", (String)shareFeedContent.getPicture());
        Utility.putNonEmptyString((Bundle)webParams, (String)"source", (String)shareFeedContent.getMediaSource());
        Utility.putNonEmptyString((Bundle)webParams, (String)"name", (String)shareFeedContent.getLinkName());
        Utility.putNonEmptyString((Bundle)webParams, (String)"caption", (String)shareFeedContent.getLinkCaption());
        Utility.putNonEmptyString((Bundle)webParams, (String)"description", (String)shareFeedContent.getLinkDescription());
        return webParams;
    }
}

