/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.internal;

import android.net.Uri;
import android.os.Bundle;
import com.facebook.FacebookException;
import com.facebook.internal.Utility;
import com.facebook.share.internal.ShareInternalUtility;
import com.facebook.share.model.ShareContent;
import com.facebook.share.model.ShareLinkContent;
import com.facebook.share.model.ShareOpenGraphAction;
import com.facebook.share.model.ShareOpenGraphContent;
import com.facebook.share.model.SharePhotoContent;
import com.facebook.share.model.ShareVideoContent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0014\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00152\u0006\u0010\u0016\u001a\u00020\bH\u0007J \u0010\u0017\u001a\u00020\u00042\u000e\u0010\u0018\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0019"}, d2={"Lcom/facebook/share/internal/LegacyNativeDialogParameters;", "", "()V", "create", "Landroid/os/Bundle;", "linkContent", "Lcom/facebook/share/model/ShareLinkContent;", "dataErrorsFatal", "", "openGraphContent", "Lcom/facebook/share/model/ShareOpenGraphContent;", "openGraphActionJSON", "Lorg/json/JSONObject;", "photoContent", "Lcom/facebook/share/model/SharePhotoContent;", "imageUrls", "", "", "callId", "Ljava/util/UUID;", "shareContent", "Lcom/facebook/share/model/ShareContent;", "shouldFailOnDataError", "createBaseParameters", "content", "facebook-common_release"})
public final class LegacyNativeDialogParameters {
    @NotNull
    public static final LegacyNativeDialogParameters INSTANCE = new LegacyNativeDialogParameters();

    private LegacyNativeDialogParameters() {
    }

    @JvmStatic
    @Nullable
    public static final Bundle create(@NotNull UUID callId, @NotNull ShareContent<?, ?> shareContent, boolean shouldFailOnDataError) {
        Intrinsics.checkNotNullParameter((Object)callId, (String)"callId");
        Intrinsics.checkNotNullParameter(shareContent, (String)"shareContent");
        Bundle nativeParams = null;
        ShareContent<?, ?> shareContent2 = shareContent;
        if (shareContent2 instanceof ShareLinkContent) {
            nativeParams = INSTANCE.create((ShareLinkContent)shareContent, shouldFailOnDataError);
        } else if (shareContent2 instanceof SharePhotoContent) {
            List list;
            List list2 = ShareInternalUtility.getPhotoUrls((SharePhotoContent)shareContent, callId);
            if (list2 == null) {
                boolean bl = false;
                list = CollectionsKt.emptyList();
            } else {
                list = list2;
            }
            List photoUrls = list;
            nativeParams = INSTANCE.create((SharePhotoContent)shareContent, photoUrls, shouldFailOnDataError);
        } else if (shareContent2 instanceof ShareVideoContent) {
            nativeParams = null;
        } else if (shareContent2 instanceof ShareOpenGraphContent) {
            Bundle bundle;
            try {
                JSONObject openGraphActionJSON = ShareInternalUtility.toJSONObjectForCall(callId, (ShareOpenGraphContent)shareContent);
                bundle = INSTANCE.create((ShareOpenGraphContent)shareContent, openGraphActionJSON, shouldFailOnDataError);
            }
            catch (JSONException e) {
                throw new FacebookException(Intrinsics.stringPlus((String)"Unable to create a JSON Object from the provided ShareOpenGraphContent: ", (Object)e.getMessage()));
            }
            nativeParams = bundle;
        }
        return nativeParams;
    }

    private final Bundle create(ShareLinkContent linkContent, boolean dataErrorsFatal) {
        return this.createBaseParameters(linkContent, dataErrorsFatal);
    }

    private final Bundle create(SharePhotoContent photoContent, List<String> imageUrls, boolean dataErrorsFatal) {
        Bundle params = this.createBaseParameters(photoContent, dataErrorsFatal);
        params.putStringArrayList("com.facebook.platform.extra.PHOTOS", new ArrayList(imageUrls));
        return params;
    }

    private final Bundle create(ShareOpenGraphContent openGraphContent, JSONObject openGraphActionJSON, boolean dataErrorsFatal) {
        Bundle params = this.createBaseParameters(openGraphContent, dataErrorsFatal);
        Utility.putNonEmptyString((Bundle)params, (String)"com.facebook.platform.extra.PREVIEW_PROPERTY_NAME", (String)openGraphContent.getPreviewPropertyName());
        ShareOpenGraphAction shareOpenGraphAction = openGraphContent.getAction();
        Utility.putNonEmptyString((Bundle)params, (String)"com.facebook.platform.extra.ACTION_TYPE", (String)(shareOpenGraphAction == null ? null : shareOpenGraphAction.getActionType()));
        Utility.putNonEmptyString((Bundle)params, (String)"com.facebook.platform.extra.ACTION", (String)String.valueOf(openGraphActionJSON));
        return params;
    }

    private final Bundle createBaseParameters(ShareContent<?, ?> content, boolean dataErrorsFatal) {
        Bundle params = new Bundle();
        Utility.putUri((Bundle)params, (String)"com.facebook.platform.extra.LINK", (Uri)content.getContentUrl());
        Utility.putNonEmptyString((Bundle)params, (String)"com.facebook.platform.extra.PLACE", (String)content.getPlaceId());
        Utility.putNonEmptyString((Bundle)params, (String)"com.facebook.platform.extra.REF", (String)content.getRef());
        params.putBoolean("com.facebook.platform.extra.DATA_FAILURES_FATAL", dataErrorsFatal);
        List<String> peopleIds = content.getPeopleIds();
        Collection collection = peopleIds;
        boolean bl = false;
        boolean bl2 = false;
        if (!(collection == null || collection.isEmpty())) {
            params.putStringArrayList("com.facebook.platform.extra.FRIENDS", new ArrayList(peopleIds));
        }
        return params;
    }
}

