/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.RestrictTo;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.facebook.AccessToken;
import com.facebook.AuthenticationToken;
import com.facebook.CustomTabMainActivity;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.common.R;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.login.CodeChallengeMethod;
import com.facebook.login.CustomTabLoginMethodHandler;
import com.facebook.login.DefaultAudience;
import com.facebook.login.DeviceAuthMethodHandler;
import com.facebook.login.GetTokenLoginMethodHandler;
import com.facebook.login.InstagramAppLoginMethodHandler;
import com.facebook.login.KatanaProxyLoginMethodHandler;
import com.facebook.login.LoginBehavior;
import com.facebook.login.LoginLogger;
import com.facebook.login.LoginManager;
import com.facebook.login.LoginMethodHandler;
import com.facebook.login.LoginTargetApp;
import com.facebook.login.WebViewLoginMethodHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0017\u0018\u0000 q2\u00020\u0001:\u0005pqrstB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010H\u001a\u00020\u0013J \u0010I\u001a\u00020F2\u0006\u0010G\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010H\u001a\u00020\u0013H\u0002J\u0010\u0010J\u001a\u00020F2\b\u0010K\u001a\u0004\u0018\u00010@J\u0006\u0010L\u001a\u00020FJ\u0006\u0010M\u001a\u00020\u0013J\u000e\u0010N\u001a\u00020\u00192\u0006\u0010O\u001a\u00020\u001cJ\u000e\u0010P\u001a\u00020F2\u0006\u0010Q\u001a\u00020RJ\u000e\u0010S\u001a\u00020F2\u0006\u0010Q\u001a\u00020RJ\b\u0010T\u001a\u00020FH\u0002J\b\u0010U\u001a\u00020\u0019H\u0016J\b\u0010V\u001a\u0004\u0018\u00010'J\u001d\u0010(\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010&2\u0006\u0010K\u001a\u00020@H\u0014\u00a2\u0006\u0002\u0010WJ2\u0010X\u001a\u00020F2\u0006\u0010Y\u001a\u00020\u001c2\u0006\u0010Z\u001a\u00020R2\u0018\u00103\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0018\u00010[H\u0002JF\u0010X\u001a\u00020F2\u0006\u0010Y\u001a\u00020\u001c2\u0006\u0010Z\u001a\u00020\u001c2\b\u0010\\\u001a\u0004\u0018\u00010\u001c2\b\u0010]\u001a\u0004\u0018\u00010\u001c2\u0018\u00103\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0018\u00010[H\u0002J\u0006\u0010^\u001a\u00020FJ\u0006\u0010_\u001a\u00020FJ\u0010\u0010`\u001a\u00020F2\u0006\u0010Q\u001a\u00020RH\u0002J \u0010a\u001a\u00020\u00132\u0006\u0010b\u001a\u00020\u00192\u0006\u0010c\u001a\u00020\u00192\b\u0010d\u001a\u0004\u0018\u00010eJ\u0010\u0010f\u001a\u00020F2\u0006\u0010g\u001a\u00020\u0019H\u0004J\u0010\u0010h\u001a\u00020F2\b\u0010K\u001a\u0004\u0018\u00010@J\u0006\u0010i\u001a\u00020\u0013J\u0006\u0010j\u001a\u00020FJ\u000e\u0010k\u001a\u00020F2\u0006\u0010l\u001a\u00020RJ\u0018\u0010m\u001a\u00020F2\u0006\u0010n\u001a\u00020\u00062\u0006\u0010o\u001a\u00020\u0019H\u0016R\u0013\u0010\b\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R(\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010!\u001a\u0004\u0018\u00010\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010\u0004R$\u0010%\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010&X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010,\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0011\u0010-\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0015R\u0014\u0010/\u001a\u0002008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R(\u00103\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u001e\"\u0004\b5\u0010 R\u0010\u00106\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u00109\u001a\u0004\u0018\u00010:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u001c\u0010?\u001a\u0004\u0018\u00010@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010D\u00a8\u0006u"}, d2={"Lcom/facebook/login/LoginClient;", "Landroid/os/Parcelable;", "fragment", "Landroidx/fragment/app/Fragment;", "(Landroidx/fragment/app/Fragment;)V", "source", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "activity", "Landroidx/fragment/app/FragmentActivity;", "getActivity", "()Landroidx/fragment/app/FragmentActivity;", "backgroundProcessingListener", "Lcom/facebook/login/LoginClient$BackgroundProcessingListener;", "getBackgroundProcessingListener", "()Lcom/facebook/login/LoginClient$BackgroundProcessingListener;", "setBackgroundProcessingListener", "(Lcom/facebook/login/LoginClient$BackgroundProcessingListener;)V", "checkedInternetPermission", "", "getCheckedInternetPermission", "()Z", "setCheckedInternetPermission", "(Z)V", "currentHandler", "", "extraData", "", "", "getExtraData", "()Ljava/util/Map;", "setExtraData", "(Ljava/util/Map;)V", "value", "getFragment", "()Landroidx/fragment/app/Fragment;", "setFragment", "handlersToTry", "", "Lcom/facebook/login/LoginMethodHandler;", "getHandlersToTry", "()[Lcom/facebook/login/LoginMethodHandler;", "setHandlersToTry", "([Lcom/facebook/login/LoginMethodHandler;)V", "[Lcom/facebook/login/LoginMethodHandler;", "inProgress", "getInProgress", "logger", "Lcom/facebook/login/LoginLogger;", "getLogger", "()Lcom/facebook/login/LoginLogger;", "loggingExtras", "getLoggingExtras", "setLoggingExtras", "loginLogger", "numActivitiesReturned", "numTotalIntentsFired", "onCompletedListener", "Lcom/facebook/login/LoginClient$OnCompletedListener;", "getOnCompletedListener", "()Lcom/facebook/login/LoginClient$OnCompletedListener;", "setOnCompletedListener", "(Lcom/facebook/login/LoginClient$OnCompletedListener;)V", "pendingRequest", "Lcom/facebook/login/LoginClient$Request;", "getPendingRequest", "()Lcom/facebook/login/LoginClient$Request;", "setPendingRequest", "(Lcom/facebook/login/LoginClient$Request;)V", "addExtraData", "", "key", "accumulate", "addLoggingExtra", "authorize", "request", "cancelCurrentHandler", "checkInternetPermission", "checkPermission", "permission", "complete", "outcome", "Lcom/facebook/login/LoginClient$Result;", "completeAndValidate", "completeWithFailure", "describeContents", "getCurrentHandler", "(Lcom/facebook/login/LoginClient$Request;)[Lcom/facebook/login/LoginMethodHandler;", "logAuthorizationMethodComplete", "method", "result", "", "errorMessage", "errorCode", "notifyBackgroundProcessingStart", "notifyBackgroundProcessingStop", "notifyOnCompleteListener", "onActivityResult", "requestCode", "resultCode", "data", "Landroid/content/Intent;", "setCurrentHandlerIndex", "index", "startOrContinueAuth", "tryCurrentHandler", "tryNextHandler", "validateSameFbidAndFinish", "pendingResult", "writeToParcel", "dest", "flags", "BackgroundProcessingListener", "Companion", "OnCompletedListener", "Request", "Result", "facebook-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class LoginClient
implements Parcelable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private LoginMethodHandler[] handlersToTry;
    private int currentHandler;
    @Nullable
    private Fragment fragment;
    @Nullable
    private OnCompletedListener onCompletedListener;
    @Nullable
    private BackgroundProcessingListener backgroundProcessingListener;
    private boolean checkedInternetPermission;
    @Nullable
    private Request pendingRequest;
    @Nullable
    private Map<String, String> loggingExtras;
    @Nullable
    private Map<String, String> extraData;
    @Nullable
    private LoginLogger loginLogger;
    private int numActivitiesReturned;
    private int numTotalIntentsFired;
    @JvmField
    @NotNull
    public static final Parcelable.Creator<LoginClient> CREATOR = (Parcelable.Creator)new Parcelable.Creator<LoginClient>(){

        @NotNull
        public LoginClient createFromParcel(@NotNull Parcel source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return new LoginClient(source);
        }

        @NotNull
        public LoginClient[] newArray(int size) {
            return new LoginClient[size];
        }
    };

    @Nullable
    public final LoginMethodHandler[] getHandlersToTry() {
        return this.handlersToTry;
    }

    public final void setHandlersToTry(@Nullable LoginMethodHandler[] loginMethodHandlerArray) {
        this.handlersToTry = loginMethodHandlerArray;
    }

    @Nullable
    public final Fragment getFragment() {
        return this.fragment;
    }

    public final void setFragment(@Nullable Fragment value) {
        if (this.fragment != null) {
            throw new FacebookException("Can't set fragment once it is already set.");
        }
        this.fragment = value;
    }

    @Nullable
    public final OnCompletedListener getOnCompletedListener() {
        return this.onCompletedListener;
    }

    public final void setOnCompletedListener(@Nullable OnCompletedListener onCompletedListener) {
        this.onCompletedListener = onCompletedListener;
    }

    @Nullable
    public final BackgroundProcessingListener getBackgroundProcessingListener() {
        return this.backgroundProcessingListener;
    }

    public final void setBackgroundProcessingListener(@Nullable BackgroundProcessingListener backgroundProcessingListener) {
        this.backgroundProcessingListener = backgroundProcessingListener;
    }

    public final boolean getCheckedInternetPermission() {
        return this.checkedInternetPermission;
    }

    public final void setCheckedInternetPermission(boolean bl) {
        this.checkedInternetPermission = bl;
    }

    @Nullable
    public final Request getPendingRequest() {
        return this.pendingRequest;
    }

    public final void setPendingRequest(@Nullable Request request) {
        this.pendingRequest = request;
    }

    @Nullable
    public final Map<String, String> getLoggingExtras() {
        return this.loggingExtras;
    }

    public final void setLoggingExtras(@Nullable Map<String, String> map) {
        this.loggingExtras = map;
    }

    @Nullable
    public final Map<String, String> getExtraData() {
        return this.extraData;
    }

    public final void setExtraData(@Nullable Map<String, String> map) {
        this.extraData = map;
    }

    public LoginClient(@NotNull Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this.currentHandler = -1;
        this.setFragment(fragment);
    }

    @Nullable
    public final FragmentActivity getActivity() {
        Fragment fragment = this.fragment;
        return fragment == null ? null : fragment.getActivity();
    }

    public final void startOrContinueAuth(@Nullable Request request) {
        if (!this.getInProgress()) {
            this.authorize(request);
        }
    }

    public final void authorize(@Nullable Request request) {
        if (request == null) {
            return;
        }
        if (this.pendingRequest != null) {
            throw new FacebookException("Attempted to authorize while a request is pending.");
        }
        if (AccessToken.Companion.isCurrentAccessTokenActive() && !this.checkInternetPermission()) {
            return;
        }
        this.pendingRequest = request;
        this.handlersToTry = this.getHandlersToTry(request);
        this.tryNextHandler();
    }

    public final boolean getInProgress() {
        return this.pendingRequest != null && this.currentHandler >= 0;
    }

    public final void cancelCurrentHandler() {
        LoginMethodHandler loginMethodHandler = this.getCurrentHandler();
        if (loginMethodHandler != null) {
            loginMethodHandler.cancel();
        }
    }

    @Nullable
    public final LoginMethodHandler getCurrentHandler() {
        LoginMethodHandler[] loginMethodHandlerArray;
        return this.currentHandler >= 0 ? ((loginMethodHandlerArray = this.handlersToTry) == null ? null : loginMethodHandlerArray[this.currentHandler]) : (LoginMethodHandler)null;
    }

    protected final void setCurrentHandlerIndex(int index) {
        this.currentHandler = index;
    }

    public final boolean onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        LoginClient loginClient = this;
        int n = loginClient.numActivitiesReturned;
        loginClient.numActivitiesReturned = n + 1;
        if (this.pendingRequest != null) {
            boolean hasNoBrowserException;
            if (data != null && (hasNoBrowserException = data.getBooleanExtra(CustomTabMainActivity.NO_ACTIVITY_EXCEPTION, false))) {
                this.tryNextHandler();
                return false;
            }
            LoginMethodHandler currentHandler = this.getCurrentHandler();
            if (!(currentHandler == null || currentHandler.shouldKeepTrackOfMultipleIntents() && data == null && this.numActivitiesReturned < this.numTotalIntentsFired)) {
                return currentHandler.onActivityResult(requestCode, resultCode, data);
            }
        }
        return false;
    }

    @Nullable
    protected LoginMethodHandler[] getHandlersToTry(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ArrayList<LoginMethodHandler> handlers = new ArrayList<LoginMethodHandler>();
        LoginBehavior behavior = request.getLoginBehavior();
        if (request.isInstagramLogin()) {
            if (!FacebookSdk.bypassAppSwitch && behavior.allowsInstagramAppAuth()) {
                handlers.add(new InstagramAppLoginMethodHandler(this));
            }
        } else {
            if (behavior.allowsGetTokenAuth()) {
                handlers.add(new GetTokenLoginMethodHandler(this));
            }
            if (!FacebookSdk.bypassAppSwitch && behavior.allowsKatanaAuth()) {
                handlers.add(new KatanaProxyLoginMethodHandler(this));
            }
        }
        if (behavior.allowsCustomTabAuth()) {
            handlers.add(new CustomTabLoginMethodHandler(this));
        }
        if (behavior.allowsWebViewAuth()) {
            handlers.add(new WebViewLoginMethodHandler(this));
        }
        if (!request.isInstagramLogin() && behavior.allowsDeviceAuth()) {
            handlers.add(new DeviceAuthMethodHandler(this));
        }
        Collection $this$toTypedArray$iv = handlers;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        LoginMethodHandler[] loginMethodHandlerArray = thisCollection$iv.toArray(new LoginMethodHandler[0]);
        if (loginMethodHandlerArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return loginMethodHandlerArray;
    }

    public final boolean checkInternetPermission() {
        if (this.checkedInternetPermission) {
            return true;
        }
        int permissionCheck = this.checkPermission("android.permission.INTERNET");
        if (permissionCheck != 0) {
            Activity activity = (Activity)this.getActivity();
            Activity activity2 = activity;
            String errorType = activity2 == null ? null : activity2.getString(R.string.com_facebook_internet_permission_error_title);
            Activity activity3 = activity;
            String errorDescription = activity3 == null ? null : activity3.getString(R.string.com_facebook_internet_permission_error_message);
            this.complete(Result.Companion.createErrorResult$default(Result.Companion, this.pendingRequest, errorType, errorDescription, null, 8, null));
            return false;
        }
        this.checkedInternetPermission = true;
        return true;
    }

    public final void tryNextHandler() {
        LoginMethodHandler currentHandlerObject = this.getCurrentHandler();
        if (currentHandlerObject != null) {
            this.logAuthorizationMethodComplete(currentHandlerObject.getNameForLogging(), "skipped", null, null, currentHandlerObject.getMethodLoggingExtras());
        }
        LoginMethodHandler[] handlersToTry = this.handlersToTry;
        while (handlersToTry != null && this.currentHandler < handlersToTry.length - 1) {
            LoginClient loginClient = this;
            int n = loginClient.currentHandler;
            loginClient.currentHandler = n + 1;
            boolean started = this.tryCurrentHandler();
            if (!started) continue;
            return;
        }
        if (this.pendingRequest != null) {
            this.completeWithFailure();
        }
    }

    private final void completeWithFailure() {
        this.complete(Result.Companion.createErrorResult$default(Result.Companion, this.pendingRequest, "Login attempt failed.", null, null, 8, null));
    }

    private final void addLoggingExtra(String key, String value, boolean accumulate) {
        Map extras;
        String value2 = value;
        Map map = this.loggingExtras;
        Map map2 = extras = map == null ? (Map)new HashMap() : map;
        if (this.loggingExtras == null) {
            this.loggingExtras = extras;
        }
        if (extras.containsKey(key) && accumulate) {
            value2 = extras.get(key) + ',' + value2;
        }
        map = extras;
        boolean bl = false;
        map.put(key, value2);
    }

    public final void addExtraData(@NotNull String key, @NotNull String value, boolean accumulate) {
        Map extras;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String value2 = value;
        Map map = this.extraData;
        Map map2 = extras = map == null ? (Map)new HashMap() : map;
        if (this.extraData == null) {
            this.extraData = extras;
        }
        if (extras.containsKey(key) && accumulate) {
            value2 = extras.get(key) + ',' + value2;
        }
        map = extras;
        boolean bl = false;
        map.put(key, value2);
    }

    public final boolean tryCurrentHandler() {
        LoginMethodHandler loginMethodHandler = this.getCurrentHandler();
        if (loginMethodHandler == null) {
            return false;
        }
        LoginMethodHandler handler = loginMethodHandler;
        if (handler.needsInternetPermission() && !this.checkInternetPermission()) {
            this.addLoggingExtra("no_internet_permission", "1", false);
            return false;
        }
        Request request = this.pendingRequest;
        if (request == null) {
            return false;
        }
        Request pendingRequest = request;
        int numTried = handler.tryAuthorize(pendingRequest);
        this.numActivitiesReturned = 0;
        if (numTried > 0) {
            this.getLogger().logAuthorizationMethodStart(pendingRequest.getAuthId(), handler.getNameForLogging(), pendingRequest.isFamilyLogin() ? "foa_mobile_login_method_start" : "fb_mobile_login_method_start");
            this.numTotalIntentsFired = numTried;
        } else {
            this.getLogger().logAuthorizationMethodNotTried(pendingRequest.getAuthId(), handler.getNameForLogging(), pendingRequest.isFamilyLogin() ? "foa_mobile_login_method_not_tried" : "fb_mobile_login_method_not_tried");
            this.addLoggingExtra("not_tried", handler.getNameForLogging(), true);
        }
        return numTried > 0;
    }

    public final void completeAndValidate(@NotNull Result outcome) {
        Intrinsics.checkNotNullParameter((Object)outcome, (String)"outcome");
        if (outcome.token != null && AccessToken.Companion.isCurrentAccessTokenActive()) {
            this.validateSameFbidAndFinish(outcome);
        } else {
            this.complete(outcome);
        }
    }

    public final void complete(@NotNull Result outcome) {
        Intrinsics.checkNotNullParameter((Object)outcome, (String)"outcome");
        LoginMethodHandler handler = this.getCurrentHandler();
        if (handler != null) {
            this.logAuthorizationMethodComplete(handler.getNameForLogging(), outcome, handler.getMethodLoggingExtras());
        }
        if (this.loggingExtras != null) {
            outcome.loggingExtras = this.loggingExtras;
        }
        if (this.extraData != null) {
            outcome.extraData = this.extraData;
        }
        this.handlersToTry = null;
        this.currentHandler = -1;
        this.pendingRequest = null;
        this.loggingExtras = null;
        this.numActivitiesReturned = 0;
        this.numTotalIntentsFired = 0;
        this.notifyOnCompleteListener(outcome);
    }

    public final int checkPermission(@NotNull String permission) {
        int n;
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        FragmentActivity fragmentActivity = this.getActivity();
        return fragmentActivity == null ? -1 : (n = fragmentActivity.checkCallingOrSelfPermission(permission));
    }

    public final void validateSameFbidAndFinish(@NotNull Result pendingResult) {
        Intrinsics.checkNotNullParameter((Object)pendingResult, (String)"pendingResult");
        if (pendingResult.token == null) {
            throw new FacebookException("Can't validate without a token");
        }
        AccessToken previousToken = AccessToken.Companion.getCurrentAccessToken();
        AccessToken newToken = pendingResult.token;
        try {
            Result result = null;
            result = previousToken != null && Intrinsics.areEqual((Object)previousToken.getUserId(), (Object)newToken.getUserId()) ? Result.Companion.createCompositeTokenResult(this.pendingRequest, pendingResult.token, pendingResult.authenticationToken) : Result.Companion.createErrorResult$default(Result.Companion, this.pendingRequest, "User logged in as different Facebook user.", null, null, 8, null);
            this.complete(result);
        }
        catch (Exception ex) {
            this.complete(Result.Companion.createErrorResult$default(Result.Companion, this.pendingRequest, "Caught exception", ex.getMessage(), null, 8, null));
        }
    }

    private final LoginLogger getLogger() {
        Request request;
        LoginLogger loggerToReturn = this.loginLogger;
        if (loggerToReturn == null || !Intrinsics.areEqual((Object)loggerToReturn.getApplicationId(), (Object)((request = this.pendingRequest) == null ? null : request.getApplicationId()))) {
            request = this.getActivity();
            Context context = request == null ? FacebookSdk.INSTANCE.getApplicationContext() : (Context)request;
            request = this.pendingRequest;
            this.loginLogger = loggerToReturn = new LoginLogger(context, request == null ? FacebookSdk.INSTANCE.getApplicationId() : request.getApplicationId());
        }
        return loggerToReturn;
    }

    private final void notifyOnCompleteListener(Result outcome) {
        OnCompletedListener onCompletedListener = this.onCompletedListener;
        if (onCompletedListener != null) {
            onCompletedListener.onCompleted(outcome);
        }
    }

    public final void notifyBackgroundProcessingStart() {
        BackgroundProcessingListener backgroundProcessingListener = this.backgroundProcessingListener;
        if (backgroundProcessingListener != null) {
            backgroundProcessingListener.onBackgroundProcessingStarted();
        }
    }

    public final void notifyBackgroundProcessingStop() {
        BackgroundProcessingListener backgroundProcessingListener = this.backgroundProcessingListener;
        if (backgroundProcessingListener != null) {
            backgroundProcessingListener.onBackgroundProcessingStopped();
        }
    }

    private final void logAuthorizationMethodComplete(String method, Result result, Map<String, String> loggingExtras) {
        this.logAuthorizationMethodComplete(method, result.code.getLoggingValue(), result.errorMessage, result.errorCode, loggingExtras);
    }

    private final void logAuthorizationMethodComplete(String method, String result, String errorMessage, String errorCode, Map<String, String> loggingExtras) {
        Request pendingRequest = this.pendingRequest;
        if (pendingRequest == null) {
            this.getLogger().logUnexpectedError("fb_mobile_login_method_complete", "Unexpected call to logCompleteLogin with null pendingAuthorizationRequest.", method);
        } else {
            this.getLogger().logAuthorizationMethodComplete(pendingRequest.getAuthId(), method, result, errorMessage, errorCode, loggingExtras, pendingRequest.isFamilyLogin() ? "foa_mobile_login_method_complete" : "fb_mobile_login_method_complete");
        }
    }

    /*
     * WARNING - void declaration
     */
    public LoginClient(@NotNull Parcel source) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Parcelable[] o;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.currentHandler = -1;
        Object object = source.readParcelableArray(LoginMethodHandler.class.getClassLoader());
        object = o = object == null ? new Parcelable[]{} : object;
        LoginClient loginClient = this;
        boolean $i$f$mapNotNull = false;
        void var5_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var10_11 = $this$forEach$iv$iv$iv;
        int n = ((void)var10_11).length;
        for (int i = 0; i < n; ++i) {
            LoginMethodHandler loginMethodHandler;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = var10_11[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            LoginMethodHandler handler = it instanceof LoginMethodHandler ? (LoginMethodHandler)it : null;
            LoginMethodHandler loginMethodHandler2 = handler;
            if (loginMethodHandler2 != null) {
                loginMethodHandler2.setLoginClient(this);
            }
            if (handler == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            LoginMethodHandler it$iv$iv = loginMethodHandler;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        LoginMethodHandler[] loginMethodHandlerArray = thisCollection$iv.toArray(new LoginMethodHandler[0]);
        if (loginMethodHandlerArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        loginClient.handlersToTry = loginMethodHandlerArray;
        this.currentHandler = source.readInt();
        this.pendingRequest = (Request)source.readParcelable(Request.class.getClassLoader());
        object = Utility.readNonnullStringMapFromParcel((Parcel)source);
        this.loggingExtras = object == null ? null : MapsKt.toMutableMap((Map)object);
        object = Utility.readNonnullStringMapFromParcel((Parcel)source);
        this.extraData = object == null ? null : MapsKt.toMutableMap((Map)object);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel dest, int flags) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.writeParcelableArray((Parcelable[])this.handlersToTry, flags);
        dest.writeInt(this.currentHandler);
        dest.writeParcelable((Parcelable)this.pendingRequest, flags);
        Utility.writeNonnullStringMapToParcel((Parcel)dest, this.loggingExtras);
        Utility.writeNonnullStringMapToParcel((Parcel)dest, this.extraData);
    }

    @JvmStatic
    public static final int getLoginRequestCode() {
        return Companion.getLoginRequestCode();
    }

    @JvmStatic
    @NotNull
    public static final String getE2E() {
        return Companion.getE2E();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/facebook/login/LoginClient$OnCompletedListener;", "", "onCompleted", "", "result", "Lcom/facebook/login/LoginClient$Result;", "facebook-common_release"})
    public static interface OnCompletedListener {
        public void onCompleted(@NotNull Result var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&\u00a8\u0006\u0005"}, d2={"Lcom/facebook/login/LoginClient$BackgroundProcessingListener;", "", "onBackgroundProcessingStarted", "", "onBackgroundProcessingStopped", "facebook-common_release"})
    public static interface BackgroundProcessingListener {
        public void onBackgroundProcessingStarted();

        public void onBackgroundProcessingStopped();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0018\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 K2\u00020\u0001:\u0001KB{\b\u0011\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0013B\u000f\b\u0012\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\b\u0010C\u001a\u00020DH\u0016J\u0006\u0010E\u001a\u00020+J\u000e\u0010F\u001a\u00020G2\u0006\u0010B\u001a\u00020+J\u0006\u0010B\u001a\u00020+J\u0018\u0010H\u001a\u00020G2\u0006\u0010I\u001a\u00020\u00152\u0006\u0010J\u001a\u00020DH\u0016R\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0018\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\t\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0018\"\u0004\b\u001d\u0010\u001bR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0018R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0018R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001c\u0010$\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0018\"\u0004\b&\u0010\u001bR\u001c\u0010'\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0018\"\u0004\b)\u0010\u001bR\u001a\u0010*\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010,\"\u0004\b-\u0010.R\u0011\u0010/\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b/\u0010,R\u001a\u00100\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010,\"\u0004\b1\u0010.R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0011\u00104\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u001c\u00107\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\u0018\"\u0004\b9\u0010\u001bR\u0011\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010\u0018R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u001a\u0010?\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010,\"\u0004\bA\u0010.R\u000e\u0010B\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lcom/facebook/login/LoginClient$Request;", "Landroid/os/Parcelable;", "loginBehavior", "Lcom/facebook/login/LoginBehavior;", "permissions", "", "", "defaultAudience", "Lcom/facebook/login/DefaultAudience;", "authType", "applicationId", "authId", "targetApp", "Lcom/facebook/login/LoginTargetApp;", "nonce", "codeVerifier", "codeChallenge", "codeChallengeMethod", "Lcom/facebook/login/CodeChallengeMethod;", "(Lcom/facebook/login/LoginBehavior;Ljava/util/Set;Lcom/facebook/login/DefaultAudience;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/facebook/login/LoginTargetApp;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/facebook/login/CodeChallengeMethod;)V", "parcel", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "getApplicationId", "()Ljava/lang/String;", "getAuthId", "setAuthId", "(Ljava/lang/String;)V", "getAuthType", "setAuthType", "getCodeChallenge", "getCodeChallengeMethod", "()Lcom/facebook/login/CodeChallengeMethod;", "getCodeVerifier", "getDefaultAudience", "()Lcom/facebook/login/DefaultAudience;", "deviceAuthTargetUserId", "getDeviceAuthTargetUserId", "setDeviceAuthTargetUserId", "deviceRedirectUriString", "getDeviceRedirectUriString", "setDeviceRedirectUriString", "isFamilyLogin", "", "()Z", "setFamilyLogin", "(Z)V", "isInstagramLogin", "isRerequest", "setRerequest", "getLoginBehavior", "()Lcom/facebook/login/LoginBehavior;", "loginTargetApp", "getLoginTargetApp", "()Lcom/facebook/login/LoginTargetApp;", "messengerPageId", "getMessengerPageId", "setMessengerPageId", "getNonce", "getPermissions", "()Ljava/util/Set;", "setPermissions", "(Ljava/util/Set;)V", "resetMessengerState", "getResetMessengerState", "setResetMessengerState", "shouldSkipAccountDeduplication", "describeContents", "", "hasPublishPermission", "setShouldSkipAccountDeduplication", "", "writeToParcel", "dest", "flags", "Companion", "facebook-common_release"})
    public static final class Request
    implements Parcelable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final LoginBehavior loginBehavior;
        @NotNull
        private Set<String> permissions;
        @NotNull
        private final DefaultAudience defaultAudience;
        @NotNull
        private final String applicationId;
        @NotNull
        private String authId;
        private boolean isRerequest;
        @Nullable
        private String deviceRedirectUriString;
        @NotNull
        private String authType;
        @Nullable
        private String deviceAuthTargetUserId;
        @Nullable
        private String messengerPageId;
        private boolean resetMessengerState;
        @NotNull
        private final LoginTargetApp loginTargetApp;
        private boolean isFamilyLogin;
        private boolean shouldSkipAccountDeduplication;
        @NotNull
        private final String nonce;
        @Nullable
        private final String codeVerifier;
        @Nullable
        private final String codeChallenge;
        @Nullable
        private final CodeChallengeMethod codeChallengeMethod;
        @JvmField
        @NotNull
        public static final Parcelable.Creator<Request> CREATOR = (Parcelable.Creator)new Parcelable.Creator<Request>(){

            @NotNull
            public Request createFromParcel(@NotNull Parcel source) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                return new Request(source, null);
            }

            @NotNull
            public Request[] newArray(int size) {
                return new Request[size];
            }
        };

        @NotNull
        public final LoginBehavior getLoginBehavior() {
            return this.loginBehavior;
        }

        @NotNull
        public final Set<String> getPermissions() {
            return this.permissions;
        }

        public final void setPermissions(@NotNull Set<String> set) {
            Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
            this.permissions = set;
        }

        @NotNull
        public final DefaultAudience getDefaultAudience() {
            return this.defaultAudience;
        }

        @NotNull
        public final String getApplicationId() {
            return this.applicationId;
        }

        @NotNull
        public final String getAuthId() {
            return this.authId;
        }

        public final void setAuthId(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.authId = string2;
        }

        public final boolean isRerequest() {
            return this.isRerequest;
        }

        public final void setRerequest(boolean bl) {
            this.isRerequest = bl;
        }

        @Nullable
        public final String getDeviceRedirectUriString() {
            return this.deviceRedirectUriString;
        }

        public final void setDeviceRedirectUriString(@Nullable String string2) {
            this.deviceRedirectUriString = string2;
        }

        @NotNull
        public final String getAuthType() {
            return this.authType;
        }

        public final void setAuthType(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.authType = string2;
        }

        @Nullable
        public final String getDeviceAuthTargetUserId() {
            return this.deviceAuthTargetUserId;
        }

        public final void setDeviceAuthTargetUserId(@Nullable String string2) {
            this.deviceAuthTargetUserId = string2;
        }

        @Nullable
        public final String getMessengerPageId() {
            return this.messengerPageId;
        }

        public final void setMessengerPageId(@Nullable String string2) {
            this.messengerPageId = string2;
        }

        public final boolean getResetMessengerState() {
            return this.resetMessengerState;
        }

        public final void setResetMessengerState(boolean bl) {
            this.resetMessengerState = bl;
        }

        @NotNull
        public final LoginTargetApp getLoginTargetApp() {
            return this.loginTargetApp;
        }

        public final boolean isFamilyLogin() {
            return this.isFamilyLogin;
        }

        public final void setFamilyLogin(boolean bl) {
            this.isFamilyLogin = bl;
        }

        @NotNull
        public final String getNonce() {
            return this.nonce;
        }

        @Nullable
        public final String getCodeVerifier() {
            return this.codeVerifier;
        }

        @Nullable
        public final String getCodeChallenge() {
            return this.codeChallenge;
        }

        @Nullable
        public final CodeChallengeMethod getCodeChallengeMethod() {
            return this.codeChallengeMethod;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @JvmOverloads
        public Request(@NotNull LoginBehavior loginBehavior, @Nullable Set<String> permissions, @NotNull DefaultAudience defaultAudience, @NotNull String authType, @NotNull String applicationId, @NotNull String authId, @Nullable LoginTargetApp targetApp, @Nullable String nonce, @Nullable String codeVerifier, @Nullable String codeChallenge, @Nullable CodeChallengeMethod codeChallengeMethod) {
            Intrinsics.checkNotNullParameter((Object)loginBehavior, (String)"loginBehavior");
            Intrinsics.checkNotNullParameter((Object)defaultAudience, (String)"defaultAudience");
            Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
            Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
            Intrinsics.checkNotNullParameter((Object)authId, (String)"authId");
            super();
            this.loginBehavior = loginBehavior;
            var12_12 = permissions;
            this.permissions = var12_12 == null ? (Set)new HashSet<E>() : var12_12;
            this.defaultAudience = defaultAudience;
            this.authType = authType;
            this.applicationId = applicationId;
            this.authId = authId;
            var12_12 = targetApp;
            v0 /* !! */  = this.loginTargetApp = var12_12 == null ? LoginTargetApp.FACEBOOK : var12_12;
            if (nonce == null) ** GOTO lbl-1000
            var12_12 = nonce;
            var13_13 = false;
            if (var12_12.length() == 0) lbl-1000:
            // 2 sources

            {
                var12_12 = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue((Object)var12_12, (String)"randomUUID().toString()");
                this.nonce = var12_12;
            } else {
                this.nonce = nonce;
            }
            this.codeVerifier = codeVerifier;
            this.codeChallenge = codeChallenge;
            this.codeChallengeMethod = codeChallengeMethod;
        }

        public /* synthetic */ Request(LoginBehavior loginBehavior, Set set, DefaultAudience defaultAudience, String string2, String string3, String string4, LoginTargetApp loginTargetApp, String string5, String string6, String string7, CodeChallengeMethod codeChallengeMethod, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x40) != 0) {
                loginTargetApp = LoginTargetApp.FACEBOOK;
            }
            if ((n & 0x80) != 0) {
                string5 = null;
            }
            if ((n & 0x100) != 0) {
                string6 = null;
            }
            if ((n & 0x200) != 0) {
                string7 = null;
            }
            if ((n & 0x400) != 0) {
                codeChallengeMethod = null;
            }
            this(loginBehavior, set, defaultAudience, string2, string3, string4, loginTargetApp, string5, string6, string7, codeChallengeMethod);
        }

        public final boolean shouldSkipAccountDeduplication() {
            return this.shouldSkipAccountDeduplication;
        }

        public final void setShouldSkipAccountDeduplication(boolean shouldSkipAccountDeduplication) {
            this.shouldSkipAccountDeduplication = shouldSkipAccountDeduplication;
        }

        public final boolean hasPublishPermission() {
            for (String permission : this.permissions) {
                if (!LoginManager.Companion.isPublishPermission(permission)) continue;
                return true;
            }
            return false;
        }

        public final boolean isInstagramLogin() {
            return this.loginTargetApp == LoginTargetApp.INSTAGRAM;
        }

        /*
         * WARNING - void declaration
         */
        private Request(Parcel parcel) {
            CodeChallengeMethod codeChallengeMethod;
            String loginBehaviorEnumValue = Validate.notNullOrEmpty((String)parcel.readString(), (String)"loginBehavior");
            this.loginBehavior = LoginBehavior.valueOf(loginBehaviorEnumValue);
            ArrayList permissionsList = new ArrayList();
            parcel.readStringList((List)permissionsList);
            this.permissions = new HashSet(permissionsList);
            String defaultAudienceEnumValue = parcel.readString();
            this.defaultAudience = defaultAudienceEnumValue != null ? DefaultAudience.valueOf((String)defaultAudienceEnumValue) : DefaultAudience.NONE;
            this.applicationId = Validate.notNullOrEmpty((String)parcel.readString(), (String)"applicationId");
            this.authId = Validate.notNullOrEmpty((String)parcel.readString(), (String)"authId");
            this.isRerequest = parcel.readByte() != 0;
            this.deviceRedirectUriString = parcel.readString();
            this.authType = Validate.notNullOrEmpty((String)parcel.readString(), (String)"authType");
            this.deviceAuthTargetUserId = parcel.readString();
            this.messengerPageId = parcel.readString();
            this.resetMessengerState = parcel.readByte() != 0;
            String loginTargetAppEnumValue = parcel.readString();
            this.loginTargetApp = loginTargetAppEnumValue != null ? LoginTargetApp.valueOf((String)loginTargetAppEnumValue) : LoginTargetApp.FACEBOOK;
            this.isFamilyLogin = parcel.readByte() != 0;
            this.shouldSkipAccountDeduplication = parcel.readByte() != 0;
            this.nonce = Validate.notNullOrEmpty((String)parcel.readString(), (String)"nonce");
            this.codeVerifier = parcel.readString();
            this.codeChallenge = parcel.readString();
            String codeChallengeMethodEnumVal = parcel.readString();
            Request request = this;
            String string2 = codeChallengeMethodEnumVal;
            if (string2 == null) {
                codeChallengeMethod = null;
            } else {
                void it;
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String string4 = string3;
                Request request2 = request;
                boolean bl3 = false;
                CodeChallengeMethod codeChallengeMethod2 = CodeChallengeMethod.valueOf((String)it);
                request = request2;
                codeChallengeMethod = codeChallengeMethod2;
            }
            request.codeChallengeMethod = codeChallengeMethod;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel dest, int flags) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            dest.writeString(this.loginBehavior.name());
            dest.writeStringList((List)new ArrayList(this.permissions));
            dest.writeString(this.defaultAudience.name());
            dest.writeString(this.applicationId);
            dest.writeString(this.authId);
            dest.writeByte((byte)(this.isRerequest ? 1 : 0));
            dest.writeString(this.deviceRedirectUriString);
            dest.writeString(this.authType);
            dest.writeString(this.deviceAuthTargetUserId);
            dest.writeString(this.messengerPageId);
            dest.writeByte((byte)(this.resetMessengerState ? 1 : 0));
            dest.writeString(this.loginTargetApp.name());
            dest.writeByte((byte)(this.isFamilyLogin ? 1 : 0));
            dest.writeByte((byte)(this.shouldSkipAccountDeduplication ? 1 : 0));
            dest.writeString(this.nonce);
            dest.writeString(this.codeVerifier);
            dest.writeString(this.codeChallenge);
            CodeChallengeMethod codeChallengeMethod = this.codeChallengeMethod;
            dest.writeString(codeChallengeMethod == null ? null : codeChallengeMethod.name());
        }

        @JvmOverloads
        public Request(@NotNull LoginBehavior loginBehavior, @Nullable Set<String> permissions, @NotNull DefaultAudience defaultAudience, @NotNull String authType, @NotNull String applicationId, @NotNull String authId, @Nullable LoginTargetApp targetApp, @Nullable String nonce, @Nullable String codeVerifier, @Nullable String codeChallenge) {
            Intrinsics.checkNotNullParameter((Object)((Object)loginBehavior), (String)"loginBehavior");
            Intrinsics.checkNotNullParameter((Object)defaultAudience, (String)"defaultAudience");
            Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
            Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
            Intrinsics.checkNotNullParameter((Object)authId, (String)"authId");
            this(loginBehavior, permissions, defaultAudience, authType, applicationId, authId, targetApp, nonce, codeVerifier, codeChallenge, null, 1024, null);
        }

        @JvmOverloads
        public Request(@NotNull LoginBehavior loginBehavior, @Nullable Set<String> permissions, @NotNull DefaultAudience defaultAudience, @NotNull String authType, @NotNull String applicationId, @NotNull String authId, @Nullable LoginTargetApp targetApp, @Nullable String nonce, @Nullable String codeVerifier) {
            Intrinsics.checkNotNullParameter((Object)((Object)loginBehavior), (String)"loginBehavior");
            Intrinsics.checkNotNullParameter((Object)defaultAudience, (String)"defaultAudience");
            Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
            Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
            Intrinsics.checkNotNullParameter((Object)authId, (String)"authId");
            this(loginBehavior, permissions, defaultAudience, authType, applicationId, authId, targetApp, nonce, codeVerifier, null, null, 1536, null);
        }

        @JvmOverloads
        public Request(@NotNull LoginBehavior loginBehavior, @Nullable Set<String> permissions, @NotNull DefaultAudience defaultAudience, @NotNull String authType, @NotNull String applicationId, @NotNull String authId, @Nullable LoginTargetApp targetApp, @Nullable String nonce) {
            Intrinsics.checkNotNullParameter((Object)((Object)loginBehavior), (String)"loginBehavior");
            Intrinsics.checkNotNullParameter((Object)defaultAudience, (String)"defaultAudience");
            Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
            Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
            Intrinsics.checkNotNullParameter((Object)authId, (String)"authId");
            this(loginBehavior, permissions, defaultAudience, authType, applicationId, authId, targetApp, nonce, null, null, null, 1792, null);
        }

        @JvmOverloads
        public Request(@NotNull LoginBehavior loginBehavior, @Nullable Set<String> permissions, @NotNull DefaultAudience defaultAudience, @NotNull String authType, @NotNull String applicationId, @NotNull String authId, @Nullable LoginTargetApp targetApp) {
            Intrinsics.checkNotNullParameter((Object)((Object)loginBehavior), (String)"loginBehavior");
            Intrinsics.checkNotNullParameter((Object)defaultAudience, (String)"defaultAudience");
            Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
            Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
            Intrinsics.checkNotNullParameter((Object)authId, (String)"authId");
            this(loginBehavior, permissions, defaultAudience, authType, applicationId, authId, targetApp, null, null, null, null, 1920, null);
        }

        @JvmOverloads
        public Request(@NotNull LoginBehavior loginBehavior, @Nullable Set<String> permissions, @NotNull DefaultAudience defaultAudience, @NotNull String authType, @NotNull String applicationId, @NotNull String authId) {
            Intrinsics.checkNotNullParameter((Object)((Object)loginBehavior), (String)"loginBehavior");
            Intrinsics.checkNotNullParameter((Object)defaultAudience, (String)"defaultAudience");
            Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
            Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
            Intrinsics.checkNotNullParameter((Object)authId, (String)"authId");
            this(loginBehavior, permissions, defaultAudience, authType, applicationId, authId, null, null, null, null, null, 1984, null);
        }

        public /* synthetic */ Request(Parcel parcel, DefaultConstructorMarker $constructor_marker) {
            this(parcel);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/login/LoginClient$Request$Companion;", "", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/facebook/login/LoginClient$Request;", "facebook-common_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB7\b\u0010\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bBA\b\u0010\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000fB\u000f\b\u0012\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0017H\u0016R\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\u00148\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\u00148\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/facebook/login/LoginClient$Result;", "Landroid/os/Parcelable;", "request", "Lcom/facebook/login/LoginClient$Request;", "code", "Lcom/facebook/login/LoginClient$Result$Code;", "token", "Lcom/facebook/AccessToken;", "errorMessage", "", "errorCode", "(Lcom/facebook/login/LoginClient$Request;Lcom/facebook/login/LoginClient$Result$Code;Lcom/facebook/AccessToken;Ljava/lang/String;Ljava/lang/String;)V", "accessToken", "authenticationToken", "Lcom/facebook/AuthenticationToken;", "(Lcom/facebook/login/LoginClient$Request;Lcom/facebook/login/LoginClient$Result$Code;Lcom/facebook/AccessToken;Lcom/facebook/AuthenticationToken;Ljava/lang/String;Ljava/lang/String;)V", "parcel", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "extraData", "", "loggingExtras", "describeContents", "", "writeToParcel", "", "dest", "flags", "Code", "Companion", "facebook-common_release"})
    public static final class Result
    implements Parcelable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @JvmField
        @NotNull
        public final Code code;
        @JvmField
        @Nullable
        public final AccessToken token;
        @JvmField
        @Nullable
        public final AuthenticationToken authenticationToken;
        @JvmField
        @Nullable
        public final String errorMessage;
        @JvmField
        @Nullable
        public final String errorCode;
        @JvmField
        @Nullable
        public final Request request;
        @JvmField
        @Nullable
        public Map<String, String> loggingExtras;
        @JvmField
        @Nullable
        public Map<String, String> extraData;
        @JvmField
        @NotNull
        public static final Parcelable.Creator<Result> CREATOR = (Parcelable.Creator)new Parcelable.Creator<Result>(){

            @NotNull
            public Result createFromParcel(@NotNull Parcel source) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                return new Result(source, null);
            }

            @NotNull
            public Result[] newArray(int size) {
                return new Result[size];
            }
        };

        public Result(@Nullable Request request, @NotNull Code code, @Nullable AccessToken token, @Nullable String errorMessage, @Nullable String errorCode) {
            Intrinsics.checkNotNullParameter((Object)((Object)code), (String)"code");
            this(request, code, token, null, errorMessage, errorCode);
        }

        public Result(@Nullable Request request, @NotNull Code code, @Nullable AccessToken accessToken, @Nullable AuthenticationToken authenticationToken, @Nullable String errorMessage, @Nullable String errorCode) {
            Intrinsics.checkNotNullParameter((Object)((Object)code), (String)"code");
            this.request = request;
            this.token = accessToken;
            this.authenticationToken = authenticationToken;
            this.errorMessage = errorMessage;
            this.code = code;
            this.errorCode = errorCode;
        }

        private Result(Parcel parcel) {
            String string2 = parcel.readString();
            String string3 = string2 == null ? "error" : string2;
            this.code = Code.valueOf(string3);
            this.token = (AccessToken)parcel.readParcelable(AccessToken.class.getClassLoader());
            this.authenticationToken = (AuthenticationToken)parcel.readParcelable(AuthenticationToken.class.getClassLoader());
            this.errorMessage = parcel.readString();
            this.errorCode = parcel.readString();
            this.request = (Request)parcel.readParcelable(Request.class.getClassLoader());
            this.loggingExtras = Utility.readNonnullStringMapFromParcel((Parcel)parcel);
            this.extraData = Utility.readNonnullStringMapFromParcel((Parcel)parcel);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel dest, int flags) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            dest.writeString(this.code.name());
            dest.writeParcelable((Parcelable)this.token, flags);
            dest.writeParcelable((Parcelable)this.authenticationToken, flags);
            dest.writeString(this.errorMessage);
            dest.writeString(this.errorCode);
            dest.writeParcelable((Parcelable)this.request, flags);
            Utility.writeNonnullStringMapToParcel((Parcel)dest, this.loggingExtras);
            Utility.writeNonnullStringMapToParcel((Parcel)dest, this.extraData);
        }

        @JvmStatic
        @NotNull
        public static final Result createTokenResult(@Nullable Request request, @NotNull AccessToken token) {
            return Companion.createTokenResult(request, token);
        }

        @JvmStatic
        @NotNull
        public static final Result createCompositeTokenResult(@Nullable Request request, @Nullable AccessToken accessToken, @Nullable AuthenticationToken authenticationToken) {
            return Companion.createCompositeTokenResult(request, accessToken, authenticationToken);
        }

        @JvmStatic
        @NotNull
        public static final Result createCancelResult(@Nullable Request request, @Nullable String message) {
            return Companion.createCancelResult(request, message);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public static final Result createErrorResult(@Nullable Request request, @Nullable String errorType, @Nullable String errorDescription, @Nullable String errorCode) {
            return Companion.createErrorResult(request, errorType, errorDescription, errorCode);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public static final Result createErrorResult(@Nullable Request request, @Nullable String errorType, @Nullable String errorDescription) {
            return Companion.createErrorResult(request, errorType, errorDescription);
        }

        public /* synthetic */ Result(Parcel parcel, DefaultConstructorMarker $constructor_marker) {
            this(parcel);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/facebook/login/LoginClient$Result$Code;", "", "loggingValue", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getLoggingValue", "()Ljava/lang/String;", "SUCCESS", "CANCEL", "ERROR", "facebook-common_release"})
        public static final class Code
        extends Enum<Code> {
            @NotNull
            private final String loggingValue;
            public static final /* enum */ Code SUCCESS = new Code("success");
            public static final /* enum */ Code CANCEL = new Code("cancel");
            public static final /* enum */ Code ERROR = new Code("error");
            private static final /* synthetic */ Code[] $VALUES;

            private Code(String loggingValue) {
                this.loggingValue = loggingValue;
            }

            @NotNull
            public final String getLoggingValue() {
                return this.loggingValue;
            }

            public static Code[] values() {
                Code[] codeArray = $VALUES;
                return Arrays.copyOf(codeArray, codeArray.length);
            }

            public static Code valueOf(String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return Enum.valueOf(Code.class, value);
            }

            static {
                $VALUES = codeArray = new Code[]{Code.SUCCESS, Code.CANCEL, Code.ERROR};
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J&\u0010\u000b\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J2\u0010\u0010\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\nH\u0007J\u001a\u0010\u0014\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\rH\u0007R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/facebook/login/LoginClient$Result$Companion;", "", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/facebook/login/LoginClient$Result;", "createCancelResult", "request", "Lcom/facebook/login/LoginClient$Request;", "message", "", "createCompositeTokenResult", "accessToken", "Lcom/facebook/AccessToken;", "authenticationToken", "Lcom/facebook/AuthenticationToken;", "createErrorResult", "errorType", "errorDescription", "errorCode", "createTokenResult", "token", "facebook-common_release"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Result createTokenResult(@Nullable Request request, @NotNull AccessToken token) {
                Intrinsics.checkNotNullParameter((Object)token, (String)"token");
                return new Result(request, Code.SUCCESS, token, null, null);
            }

            @JvmStatic
            @NotNull
            public final Result createCompositeTokenResult(@Nullable Request request, @Nullable AccessToken accessToken, @Nullable AuthenticationToken authenticationToken) {
                return new Result(request, Code.SUCCESS, accessToken, authenticationToken, null, null);
            }

            @JvmStatic
            @NotNull
            public final Result createCancelResult(@Nullable Request request, @Nullable String message) {
                return new Result(request, Code.CANCEL, null, message, null);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public final Result createErrorResult(@Nullable Request request, @Nullable String errorType, @Nullable String errorDescription, @Nullable String errorCode) {
                ArrayList<String> messageParts = new ArrayList<String>();
                if (errorType != null) {
                    messageParts.add(errorType);
                }
                if (errorDescription != null) {
                    messageParts.add(errorDescription);
                }
                String message = TextUtils.join((CharSequence)": ", (Iterable)messageParts);
                return new Result(request, Code.ERROR, null, message, errorCode);
            }

            public static /* synthetic */ Result createErrorResult$default(Companion companion, Request request, String string2, String string3, String string4, int n, Object object) {
                if ((n & 8) != 0) {
                    string4 = null;
                }
                return companion.createErrorResult(request, string2, string3, string4);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public final Result createErrorResult(@Nullable Request request, @Nullable String errorType, @Nullable String errorDescription) {
                return com.facebook.login.LoginClient$Result$Companion.createErrorResult$default(this, request, errorType, errorDescription, null, 8, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\tH\u0007R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/facebook/login/LoginClient$Companion;", "", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/facebook/login/LoginClient;", "getE2E", "", "getLoginRequestCode", "", "facebook-common_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final int getLoginRequestCode() {
            return CallbackManagerImpl.RequestCodeOffset.Login.toRequestCode();
        }

        @JvmStatic
        @NotNull
        public final String getE2E() {
            JSONObject e2e = new JSONObject();
            try {
                e2e.put("init", System.currentTimeMillis());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            String string2 = e2e.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"e2e.toString()");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

