/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.common.R;
import com.facebook.internal.FacebookDialogFragment;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.Utility;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import com.facebook.internal.logging.dumpsys.EndToEndDumper;
import com.facebook.login.LoginFragment;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J7\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0011H\u0017\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0004H\u0014J\b\u0010\u0014\u001a\u00020\tH\u0002J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016R\"\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lcom/facebook/FacebookActivity;", "Landroidx/fragment/app/FragmentActivity;", "()V", "<set-?>", "Landroidx/fragment/app/Fragment;", "currentFragment", "getCurrentFragment", "()Landroidx/fragment/app/Fragment;", "dump", "", "prefix", "", "fd", "Ljava/io/FileDescriptor;", "writer", "Ljava/io/PrintWriter;", "args", "", "(Ljava/lang/String;Ljava/io/FileDescriptor;Ljava/io/PrintWriter;[Ljava/lang/String;)V", "getFragment", "handlePassThroughError", "onConfigurationChanged", "newConfig", "Landroid/content/res/Configuration;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "Companion", "facebook-common_release"})
public class FacebookActivity
extends FragmentActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Fragment currentFragment;
    @NotNull
    public static final String PASS_THROUGH_CANCEL_ACTION = "PassThrough";
    @NotNull
    private static final String FRAGMENT_TAG = "SingleFragment";
    @NotNull
    private static final String TAG;

    @Nullable
    public final Fragment getCurrentFragment() {
        return this.currentFragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        if (!FacebookSdk.INSTANCE.isInitialized()) {
            Utility.logd((String)TAG, (String)"Facebook SDK not initialized. Make sure you call sdkInitialize inside your Application's onCreate method.");
            Context context = this.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
            FacebookSdk.sdkInitialize((Context)context);
        }
        this.setContentView(R.layout.com_facebook_activity_layout);
        if (Intrinsics.areEqual((Object)PASS_THROUGH_CANCEL_ACTION, (Object)intent.getAction())) {
            this.handlePassThroughError();
            return;
        }
        this.currentFragment = this.getFragment();
    }

    @NotNull
    protected Fragment getFragment() {
        Intent intent = this.getIntent();
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"supportFragmentManager");
        FragmentManager manager = fragmentManager;
        Fragment fragment = manager.findFragmentByTag(FRAGMENT_TAG);
        if (fragment == null) {
            if (Intrinsics.areEqual((Object)"FacebookDialogFragment", (Object)intent.getAction())) {
                FacebookDialogFragment dialogFragment = new FacebookDialogFragment();
                dialogFragment.setRetainInstance(true);
                dialogFragment.show(manager, FRAGMENT_TAG);
                fragment = (Fragment)dialogFragment;
            } else {
                fragment = new LoginFragment();
                ((LoginFragment)fragment).setRetainInstance(true);
                manager.beginTransaction().add(R.id.com_facebook_fragment_container, fragment, FRAGMENT_TAG).commit();
            }
        }
        return fragment;
    }

    public void onConfigurationChanged(@NotNull Configuration newConfig) {
        Intrinsics.checkNotNullParameter((Object)newConfig, (String)"newConfig");
        super.onConfigurationChanged(newConfig);
        Fragment fragment = this.currentFragment;
        if (fragment != null) {
            fragment.onConfigurationChanged(newConfig);
        }
    }

    private final void handlePassThroughError() {
        Intent requestIntent = this.getIntent();
        Intrinsics.checkNotNullExpressionValue((Object)requestIntent, (String)"requestIntent");
        Bundle errorResults = NativeProtocol.getMethodArgumentsFromIntent((Intent)requestIntent);
        FacebookException exception = NativeProtocol.getExceptionFromErrorData((Bundle)errorResults);
        Intent intent = this.getIntent();
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"intent");
        Intent resultIntent = NativeProtocol.createProtocolResultIntent((Intent)intent, null, (FacebookException)exception);
        this.setResult(0, resultIntent);
        this.finish();
    }

    /*
     * WARNING - void declaration
     */
    public void dump(@NotNull String string, @Nullable FileDescriptor fileDescriptor, @NotNull PrintWriter printWriter, @Nullable String[] stringArray) {
        if (CrashShieldHandler.isObjectCrashing((Object)((Object)this))) {
            return;
        }
        try {
            void fd;
            void args;
            void writer;
            void prefix;
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            EndToEndDumper endToEndDumper = EndToEndDumper.Companion.getInstance();
            if (Intrinsics.areEqual(endToEndDumper == null ? null : Boolean.valueOf(endToEndDumper.maybeDump((String)prefix, (PrintWriter)writer, (String[])args)), (Object)true)) {
                return;
            }
            super.dump((String)prefix, (FileDescriptor)fd, (PrintWriter)writer, (String[])args);
            return;
        }
        catch (Throwable throwable) {
            CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)((Object)this));
            return;
        }
    }

    static {
        String string = FacebookActivity.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FacebookActivity::class.java.name");
        TAG = string;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/facebook/FacebookActivity$Companion;", "", "()V", "FRAGMENT_TAG", "", "PASS_THROUGH_CANCEL_ACTION", "TAG", "facebook-common_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

