/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.facebook.share.model.ShareContent;
import com.facebook.share.model.ShareMedia;
import com.facebook.share.model.SharePhoto;
import com.facebook.share.model.ShareVideo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class ShareMediaContent
extends ShareContent<ShareMediaContent, Builder> {
    private final List<ShareMedia> media;
    public static final Parcelable.Creator<ShareMediaContent> CREATOR = new Parcelable.Creator<ShareMediaContent>(){

        public ShareMediaContent createFromParcel(Parcel in) {
            return new ShareMediaContent(in);
        }

        public ShareMediaContent[] newArray(int size) {
            return new ShareMediaContent[size];
        }
    };

    private ShareMediaContent(Builder builder) {
        super(builder);
        this.media = Collections.unmodifiableList(builder.media);
    }

    ShareMediaContent(Parcel in) {
        super(in);
        ShareMedia[] shareMedia = (ShareMedia[])in.readParcelableArray(ShareMedia.class.getClassLoader());
        this.media = Arrays.asList(shareMedia);
    }

    @Nullable
    public List<ShareMedia> getMedia() {
        return this.media;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        super.writeToParcel(out, flags);
        out.writeParcelableArray((Parcelable[])((ShareMedia[])this.media.toArray()), flags);
    }

    public static class Builder
    extends ShareContent.Builder<ShareMediaContent, Builder> {
        private final List<ShareMedia> media = new ArrayList<ShareMedia>();

        public Builder addMedium(@Nullable ShareMedia medium) {
            if (medium != null) {
                ShareMedia mediumToAdd;
                if (medium instanceof SharePhoto) {
                    mediumToAdd = new SharePhoto.Builder().readFrom((SharePhoto)medium).build();
                } else if (medium instanceof ShareVideo) {
                    mediumToAdd = new ShareVideo.Builder().readFrom((ShareVideo)medium).build();
                } else {
                    throw new IllegalArgumentException("medium must be either a SharePhoto or ShareVideo");
                }
                this.media.add(mediumToAdd);
            }
            return this;
        }

        public Builder addMedia(@Nullable List<ShareMedia> media) {
            if (media != null) {
                for (ShareMedia medium : media) {
                    this.addMedium(medium);
                }
            }
            return this;
        }

        @Override
        public ShareMediaContent build() {
            return new ShareMediaContent(this);
        }

        @Override
        public Builder readFrom(ShareMediaContent model) {
            if (model == null) {
                return this;
            }
            return ((Builder)super.readFrom(model)).addMedia(model.getMedia());
        }

        public Builder setMedia(@Nullable List<ShareMedia> media) {
            this.media.clear();
            this.addMedia(media);
            return this;
        }
    }
}

