/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.fragment.app.FragmentActivity;
import com.facebook.AccessToken;
import com.facebook.AccessTokenSource;
import com.facebook.login.DeviceAuthDialog;
import com.facebook.login.LoginClient;
import com.facebook.login.LoginMethodHandler;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.ScheduledThreadPoolExecutor;

class DeviceAuthMethodHandler
extends LoginMethodHandler {
    private static ScheduledThreadPoolExecutor backgroundExecutor;
    public static final Parcelable.Creator<DeviceAuthMethodHandler> CREATOR;

    DeviceAuthMethodHandler(LoginClient loginClient) {
        super(loginClient);
    }

    @Override
    public int tryAuthorize(LoginClient.Request request) {
        this.showDialog(request);
        return 1;
    }

    private void showDialog(LoginClient.Request request) {
        FragmentActivity activity = this.getLoginClient().getActivity();
        if (activity == null || activity.isFinishing()) {
            return;
        }
        DeviceAuthDialog dialog = this.createDeviceAuthDialog();
        dialog.show(activity.getSupportFragmentManager(), "login_with_facebook");
        dialog.startLogin(request);
    }

    protected DeviceAuthDialog createDeviceAuthDialog() {
        return new DeviceAuthDialog();
    }

    public void onCancel() {
        LoginClient.Result outcome = LoginClient.Result.createCancelResult(this.getLoginClient().getPendingRequest(), "User canceled log in.");
        this.getLoginClient().completeAndValidate(outcome);
    }

    public void onError(Exception ex) {
        LoginClient.Result outcome = LoginClient.Result.createErrorResult(this.getLoginClient().getPendingRequest(), null, ex.getMessage());
        this.getLoginClient().completeAndValidate(outcome);
    }

    public void onSuccess(String accessToken, String applicationId, String userId, Collection<String> permissions, Collection<String> declinedPermissions, Collection<String> expiredPermissions, AccessTokenSource accessTokenSource, Date expirationTime, Date lastRefreshTime, Date dataAccessExpirationTime) {
        AccessToken token = new AccessToken(accessToken, applicationId, userId, permissions, declinedPermissions, expiredPermissions, accessTokenSource, expirationTime, lastRefreshTime, dataAccessExpirationTime);
        LoginClient.Result outcome = LoginClient.Result.createTokenResult(this.getLoginClient().getPendingRequest(), token);
        this.getLoginClient().completeAndValidate(outcome);
    }

    public static synchronized ScheduledThreadPoolExecutor getBackgroundExecutor() {
        if (backgroundExecutor == null) {
            backgroundExecutor = new ScheduledThreadPoolExecutor(1);
        }
        return backgroundExecutor;
    }

    protected DeviceAuthMethodHandler(Parcel parcel) {
        super(parcel);
    }

    @Override
    public String getNameForLogging() {
        return "device_auth";
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
    }

    static {
        CREATOR = new Parcelable.Creator(){

            public DeviceAuthMethodHandler createFromParcel(Parcel source) {
                return new DeviceAuthMethodHandler(source);
            }

            public DeviceAuthMethodHandler[] newArray(int size) {
                return new DeviceAuthMethodHandler[size];
            }
        };
    }
}

