/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.webkit.WebView;
import com.facebook.internal.BundleJSONConverter;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.Utility;
import com.facebook.internal.WebDialog;
import com.facebook.internal.instrument.crashshield.CrashShieldHandler;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/facebook/internal/FacebookWebFallbackDialog;", "Lcom/facebook/internal/WebDialog;", "context", "Landroid/content/Context;", "url", "", "expectedRedirectUrl", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;)V", "waitingForDialogToClose", "", "cancel", "", "parseResponseUri", "Landroid/os/Bundle;", "Companion", "facebook-common_release"})
public final class FacebookWebFallbackDialog
extends WebDialog {
    private boolean waitingForDialogToClose;
    private static final String TAG;
    private static final int OS_BACK_BUTTON_RESPONSE_TIMEOUT_MILLISECONDS = 1500;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public Bundle parseResponseUri(@Nullable String url) {
        Uri responseUri;
        Uri uri = responseUri = Uri.parse((String)url);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"responseUri");
        Bundle queryParams = Utility.parseUrlQueryString((String)uri.getQuery());
        String bridgeArgsJSONString = queryParams.getString("bridge_args");
        queryParams.remove("bridge_args");
        if (!Utility.isNullOrEmpty((String)bridgeArgsJSONString)) {
            try {
                JSONObject bridgeArgsJSON = new JSONObject(bridgeArgsJSONString);
                Bundle bridgeArgs = BundleJSONConverter.convertToBundle((JSONObject)bridgeArgsJSON);
                queryParams.putBundle("com.facebook.platform.protocol.BRIDGE_ARGS", bridgeArgs);
            }
            catch (JSONException je) {
                Utility.logd((String)TAG, (String)"Unable to parse bridge_args JSON", (Throwable)je);
            }
        }
        String methodResultsJSONString = queryParams.getString("method_results");
        queryParams.remove("method_results");
        if (!Utility.isNullOrEmpty((String)methodResultsJSONString)) {
            try {
                JSONObject methodArgsJSON = new JSONObject(methodResultsJSONString);
                Bundle methodResults = BundleJSONConverter.convertToBundle((JSONObject)methodArgsJSON);
                queryParams.putBundle("com.facebook.platform.protocol.RESULT_ARGS", methodResults);
            }
            catch (JSONException je) {
                Utility.logd((String)TAG, (String)"Unable to parse bridge_args JSON", (Throwable)je);
            }
        }
        queryParams.remove("version");
        queryParams.putInt("com.facebook.platform.protocol.PROTOCOL_VERSION", NativeProtocol.getLatestKnownVersion());
        return queryParams;
    }

    @Override
    public void cancel() {
        WebView webView = this.getWebView();
        if (!this.isPageFinished() || this.isListenerCalled() || webView == null || !webView.isShown()) {
            super.cancel();
            return;
        }
        if (this.waitingForDialogToClose) {
            return;
        }
        this.waitingForDialogToClose = true;
        String eventJS = "(function() {  var event = document.createEvent('Event');  event.initEvent('fbPlatformDialogMustClose',true,true);  document.dispatchEvent(event);})();";
        webView.loadUrl("javascript:" + eventJS);
        Handler handler = new Handler(Looper.getMainLooper());
        handler.postDelayed(new Runnable(this){
            final /* synthetic */ FacebookWebFallbackDialog this$0;

            public final void run() {
                if (CrashShieldHandler.isObjectCrashing((Object)this)) {
                    return;
                }
                try {
                    FacebookWebFallbackDialog.access$cancel$s1906818296(this.this$0);
                    return;
                }
                catch (Throwable throwable) {
                    CrashShieldHandler.handleThrowable((Throwable)throwable, (Object)this);
                    return;
                }
            }
            {
                this.this$0 = facebookWebFallbackDialog;
            }
        }, (long)1500);
    }

    private FacebookWebFallbackDialog(Context context, String url, String expectedRedirectUrl) {
        super(context, url);
        this.setExpectedRedirectUrl(expectedRedirectUrl);
    }

    static {
        Companion = new Companion(null);
        String string2 = FacebookWebFallbackDialog.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"FacebookWebFallbackDialog::class.java.name");
        TAG = string2;
    }

    public static final /* synthetic */ void access$cancel$s1906818296(FacebookWebFallbackDialog $this) {
        super.cancel();
    }

    public /* synthetic */ FacebookWebFallbackDialog(Context context, String url, String expectedRedirectUrl, DefaultConstructorMarker $constructor_marker) {
        this(context, url, expectedRedirectUrl);
    }

    @JvmStatic
    @NotNull
    public static final FacebookWebFallbackDialog newInstance(@NotNull Context context, @NotNull String url, @NotNull String expectedRedirectUrl) {
        return Companion.newInstance(context, url, expectedRedirectUrl);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/facebook/internal/FacebookWebFallbackDialog$Companion;", "", "()V", "OS_BACK_BUTTON_RESPONSE_TIMEOUT_MILLISECONDS", "", "TAG", "", "newInstance", "Lcom/facebook/internal/FacebookWebFallbackDialog;", "context", "Landroid/content/Context;", "url", "expectedRedirectUrl", "facebook-common_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final FacebookWebFallbackDialog newInstance(@NotNull Context context, @NotNull String url, @NotNull String expectedRedirectUrl) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)expectedRedirectUrl, (String)"expectedRedirectUrl");
            WebDialog.Companion.initDefaultTheme(context);
            return new FacebookWebFallbackDialog(context, url, expectedRedirectUrl, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

