/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.app.Activity;
import android.content.Intent;
import android.util.Log;
import androidx.activity.result.ActivityResultRegistry;
import androidx.activity.result.ActivityResultRegistryOwner;
import androidx.annotation.VisibleForTesting;
import com.facebook.CallbackManager;
import com.facebook.FacebookCallback;
import com.facebook.FacebookDialog;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.LoggingBehavior;
import com.facebook.internal.AppCall;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.DialogPresenter;
import com.facebook.internal.FragmentWrapper;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 =*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003:\u0002=>B\u0017\b\u0014\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0017\b\u0014\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010!\u001a\u0018\u0012\u0014\u0012\u00120\u0017R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00000\u0016H\u0002J\u0015\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010%J\u001d\u0010&\u001a\u00020#2\u0006\u0010$\u001a\u00028\u00002\u0006\u0010'\u001a\u00020(H\u0014\u00a2\u0006\u0002\u0010)J\u001f\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010$\u001a\u00028\u00002\u0006\u0010'\u001a\u00020(H\u0002\u00a2\u0006\u0002\u0010,J\b\u0010-\u001a\u00020+H$J\u0012\u0010.\u001a\u00020/2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u001e\u00100\u001a\u00020/2\u0006\u0010\u000f\u001a\u00020\u00102\f\u00101\u001a\b\u0012\u0004\u0012\u00028\u000102H\u0016J&\u00100\u001a\u00020/2\u0006\u0010\u000f\u001a\u00020\u00102\f\u00101\u001a\b\u0012\u0004\u0012\u00028\u0001022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u00103\u001a\u00020/2\u0006\u0010\u000f\u001a\u0002042\f\u00101\u001a\b\u0012\u0004\u0012\u00028\u000102H$J\u0010\u00105\u001a\u00020/2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0015\u00106\u001a\u00020/2\u0006\u0010$\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00107J\u001d\u00108\u001a\u00020/2\u0006\u0010$\u001a\u00028\u00002\u0006\u0010'\u001a\u00020(H\u0014\u00a2\u0006\u0002\u00109J\u0018\u0010:\u001a\u00020/2\u0006\u0010;\u001a\u00020<2\u0006\u0010\u0006\u001a\u00020\u0007H\u0004R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u0004\u0018\u00010\u00058DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u0004\u0018\u00010\u00108AX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0015\u001a\u001a\u0012\u0014\u0012\u00120\u0017R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0018\u001a\u0018\u0012\u0014\u0012\u00120\u0017R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00000\u0016X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/facebook/internal/FacebookDialogBase;", "CONTENT", "RESULT", "Lcom/facebook/FacebookDialog;", "activity", "Landroid/app/Activity;", "requestCode", "", "(Landroid/app/Activity;I)V", "fragmentWrapper", "Lcom/facebook/internal/FragmentWrapper;", "(Lcom/facebook/internal/FragmentWrapper;I)V", "activityContext", "getActivityContext", "()Landroid/app/Activity;", "callbackManager", "Lcom/facebook/CallbackManager;", "getCallbackManager$facebook_common_release", "()Lcom/facebook/CallbackManager;", "setCallbackManager$facebook_common_release", "(Lcom/facebook/CallbackManager;)V", "modeHandlers", "", "Lcom/facebook/internal/FacebookDialogBase$ModeHandler;", "orderedModeHandlers", "getOrderedModeHandlers", "()Ljava/util/List;", "value", "getRequestCode", "()I", "setRequestCode", "(I)V", "requestCodeField", "cachedModeHandlers", "canShow", "", "content", "(Ljava/lang/Object;)Z", "canShowImpl", "mode", "", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "createAppCallForMode", "Lcom/facebook/internal/AppCall;", "(Ljava/lang/Object;Ljava/lang/Object;)Lcom/facebook/internal/AppCall;", "createBaseAppCall", "memorizeCallbackManager", "", "registerCallback", "callback", "Lcom/facebook/FacebookCallback;", "registerCallbackImpl", "Lcom/facebook/internal/CallbackManagerImpl;", "setCallbackManager", "show", "(Ljava/lang/Object;)V", "showImpl", "(Ljava/lang/Object;Ljava/lang/Object;)V", "startActivityForResult", "intent", "Landroid/content/Intent;", "Companion", "ModeHandler", "facebook-common_release"})
public abstract class FacebookDialogBase<CONTENT, RESULT>
implements FacebookDialog<CONTENT, RESULT> {
    private final Activity activity;
    private final FragmentWrapper fragmentWrapper;
    private List<? extends ModeHandler> modeHandlers;
    private int requestCodeField;
    @Nullable
    private CallbackManager callbackManager;
    private static final String TAG = "FacebookDialog";
    @JvmField
    @NotNull
    public static final Object BASE_AUTOMATIC_MODE;
    @NotNull
    public static final Companion Companion;

    @VisibleForTesting(otherwise=2)
    @Nullable
    public final CallbackManager getCallbackManager$facebook_common_release() {
        return this.callbackManager;
    }

    public final void setCallbackManager$facebook_common_release(@Nullable CallbackManager callbackManager) {
        this.callbackManager = callbackManager;
    }

    public final void setCallbackManager(@Nullable CallbackManager callbackManager) {
        this.callbackManager = callbackManager;
    }

    @Override
    public void registerCallback(@NotNull CallbackManager callbackManager, @NotNull FacebookCallback<RESULT> callback2) {
        Intrinsics.checkNotNullParameter((Object)callbackManager, (String)"callbackManager");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        if (!(callbackManager instanceof CallbackManagerImpl)) {
            throw (Throwable)new FacebookException("Unexpected CallbackManager, please use the provided Factory.");
        }
        this.memorizeCallbackManager(callbackManager);
        this.registerCallbackImpl((CallbackManagerImpl)callbackManager, callback2);
    }

    @Override
    public void registerCallback(@NotNull CallbackManager callbackManager, @NotNull FacebookCallback<RESULT> callback2, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)callbackManager, (String)"callbackManager");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        this.memorizeCallbackManager(callbackManager);
        this.setRequestCode(requestCode);
        this.registerCallback(callbackManager, callback2);
    }

    protected abstract void registerCallbackImpl(@NotNull CallbackManagerImpl var1, @NotNull FacebookCallback<RESULT> var2);

    public final int getRequestCode() {
        return this.requestCodeField;
    }

    public final void setRequestCode(int value) {
        boolean bl = !FacebookSdk.isFacebookRequestCode((int)value);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Request code " + value + " cannot be within the range reserved by the Facebook SDK.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        this.requestCodeField = value;
    }

    @Override
    public boolean canShow(CONTENT content) {
        return this.canShowImpl(content, BASE_AUTOMATIC_MODE);
    }

    protected boolean canShowImpl(CONTENT content, @NotNull Object mode) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        boolean anyModeAllowed = mode == BASE_AUTOMATIC_MODE;
        for (ModeHandler handler : this.cachedModeHandlers()) {
            if (!anyModeAllowed && !Utility.areObjectsEqual((Object)handler.getMode(), (Object)mode) || !handler.canShow(content, false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void show(CONTENT content) {
        this.showImpl(content, BASE_AUTOMATIC_MODE);
    }

    protected void showImpl(CONTENT content, @NotNull Object mode) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        AppCall appCall = this.createAppCallForMode(content, mode);
        if (appCall != null) {
            if (this.getActivityContext() instanceof ActivityResultRegistryOwner) {
                Activity activity = this.getActivityContext();
                if (activity == null) {
                    throw new NullPointerException("null cannot be cast to non-null type androidx.activity.result.ActivityResultRegistryOwner");
                }
                ActivityResultRegistryOwner registryOwner = (ActivityResultRegistryOwner)activity;
                ActivityResultRegistry activityResultRegistry = registryOwner.getActivityResultRegistry();
                Intrinsics.checkNotNullExpressionValue((Object)activityResultRegistry, (String)"registryOwner.activityResultRegistry");
                DialogPresenter.present(appCall, activityResultRegistry, this.callbackManager);
                appCall.setPending();
            } else if (this.fragmentWrapper != null) {
                DialogPresenter.present(appCall, this.fragmentWrapper);
            } else if (this.activity != null) {
                DialogPresenter.present(appCall, this.activity);
            }
        } else {
            String errorMessage = "No code path should ever result in a null appCall";
            Log.e((String)TAG, (String)errorMessage);
            boolean bl = !FacebookSdk.isDebugEnabled();
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string2 = errorMessage;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
        }
    }

    @Nullable
    protected final Activity getActivityContext() {
        Object object = this.activity;
        if (object == null) {
            FragmentWrapper fragmentWrapper = this.fragmentWrapper;
            object = fragmentWrapper != null ? fragmentWrapper.getActivity() : null;
        }
        return object;
    }

    protected final void startActivityForResult(@NotNull Intent intent, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        String error = null;
        Activity activity = this.getActivityContext();
        if (activity instanceof ActivityResultRegistryOwner) {
            ActivityResultRegistry activityResultRegistry = ((ActivityResultRegistryOwner)activity).getActivityResultRegistry();
            Intrinsics.checkNotNullExpressionValue((Object)activityResultRegistry, (String)"(activity as ActivityRes\u2026r).activityResultRegistry");
            DialogPresenter.startActivityForResultWithAndroidX(activityResultRegistry, this.callbackManager, intent, requestCode);
        } else if (activity != null) {
            activity.startActivityForResult(intent, requestCode);
        } else if (this.fragmentWrapper != null) {
            this.fragmentWrapper.startActivityForResult(intent, requestCode);
        } else {
            error = "Failed to find Activity or Fragment to startActivityForResult ";
        }
        if (error != null) {
            String string2 = this.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this.javaClass.name");
            Logger.Companion.log(LoggingBehavior.DEVELOPER_ERRORS, 6, string2, error);
        }
    }

    private final AppCall createAppCallForMode(CONTENT content, Object mode) {
        boolean anyModeAllowed = mode == BASE_AUTOMATIC_MODE;
        AppCall appCall = null;
        for (ModeHandler handler : this.cachedModeHandlers()) {
            if (!anyModeAllowed && !Utility.areObjectsEqual((Object)handler.getMode(), (Object)mode) || !handler.canShow(content, true)) continue;
            try {
                appCall = handler.createAppCall(content);
            }
            catch (FacebookException e) {
                appCall = this.createBaseAppCall();
                DialogPresenter.setupAppCallForValidationError(appCall, e);
            }
            break;
        }
        if (appCall == null) {
            appCall = this.createBaseAppCall();
            DialogPresenter.setupAppCallForCannotShowError(appCall);
        }
        return appCall;
    }

    private final void memorizeCallbackManager(CallbackManager callbackManager) {
        if (this.callbackManager == null) {
            this.callbackManager = callbackManager;
        } else if (this.callbackManager != callbackManager) {
            Log.w((String)TAG, (String)"You're registering a callback on a Facebook dialog with two different callback managers. It's almost wrong and may cause unexpected results. Only the first callback manager will be used for handling activity result with androidx.");
        }
    }

    private final List<ModeHandler> cachedModeHandlers() {
        if (this.modeHandlers == null) {
            this.modeHandlers = this.getOrderedModeHandlers();
        }
        List<ModeHandler> list = this.modeHandlers;
        if (list == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<com.facebook.internal.FacebookDialogBase<CONTENT, RESULT>.ModeHandler>");
        }
        return list;
    }

    @NotNull
    protected abstract List<ModeHandler> getOrderedModeHandlers();

    @NotNull
    protected abstract AppCall createBaseAppCall();

    protected FacebookDialogBase(@NotNull Activity activity, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.activity = activity;
        this.fragmentWrapper = null;
        this.requestCodeField = requestCode;
        this.callbackManager = null;
    }

    protected FacebookDialogBase(@NotNull FragmentWrapper fragmentWrapper, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)fragmentWrapper, (String)"fragmentWrapper");
        this.fragmentWrapper = fragmentWrapper;
        this.activity = null;
        this.requestCodeField = requestCode;
        Activity activity = fragmentWrapper.getActivity();
        boolean bl = false;
        boolean bl2 = false;
        if (activity == null) {
            boolean bl3 = false;
            String string2 = "Cannot use a fragment that is not attached to an activity";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
    }

    static {
        Companion = new Companion(null);
        BASE_AUTOMATIC_MODE = new Object();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00a4\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\tH&\u00a2\u0006\u0002\u0010\fJ\u0017\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u000fR\u001a\u0010\u0003\u001a\u00020\u0001X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/facebook/internal/FacebookDialogBase$ModeHandler;", "", "(Lcom/facebook/internal/FacebookDialogBase;)V", "mode", "getMode", "()Ljava/lang/Object;", "setMode", "(Ljava/lang/Object;)V", "canShow", "", "content", "isBestEffort", "(Ljava/lang/Object;Z)Z", "createAppCall", "Lcom/facebook/internal/AppCall;", "(Ljava/lang/Object;)Lcom/facebook/internal/AppCall;", "facebook-common_release"})
    protected abstract class ModeHandler {
        @NotNull
        private Object mode = BASE_AUTOMATIC_MODE;

        @NotNull
        public Object getMode() {
            return this.mode;
        }

        public void setMode(@NotNull Object object) {
            Intrinsics.checkNotNullParameter((Object)object, (String)"<set-?>");
            this.mode = object;
        }

        public abstract boolean canShow(CONTENT var1, boolean var2);

        @Nullable
        public abstract AppCall createAppCall(CONTENT var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/internal/FacebookDialogBase$Companion;", "", "()V", "BASE_AUTOMATIC_MODE", "TAG", "", "facebook-common_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

