/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.model;

import android.os.Parcel;
import com.facebook.share.model.ShareModel;
import com.facebook.share.model.ShareModelBuilder;

public final class AppGroupCreationContent
implements ShareModel {
    private final String name;
    private final String description;
    private AppGroupPrivacy privacy;

    private AppGroupCreationContent(Builder builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.privacy = builder.privacy;
    }

    AppGroupCreationContent(Parcel in) {
        this.name = in.readString();
        this.description = in.readString();
        this.privacy = AppGroupPrivacy.valueOf(in.readString());
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public AppGroupPrivacy getAppGroupPrivacy() {
        return this.privacy;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.name);
        out.writeString(this.description);
        out.writeString(this.privacy.toString());
    }

    public static class Builder
    implements ShareModelBuilder<AppGroupCreationContent, Builder> {
        private String name;
        private String description;
        private AppGroupPrivacy privacy;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setAppGroupPrivacy(AppGroupPrivacy privacy) {
            this.privacy = privacy;
            return this;
        }

        @Override
        public AppGroupCreationContent build() {
            return new AppGroupCreationContent(this);
        }

        @Override
        public Builder readFrom(AppGroupCreationContent content) {
            if (content == null) {
                return this;
            }
            return this.setName(content.getName()).setDescription(content.getDescription()).setAppGroupPrivacy(content.getAppGroupPrivacy());
        }

        @Override
        public Builder readFrom(Parcel parcel) {
            return this.readFrom((AppGroupCreationContent)parcel.readParcelable(AppGroupCreationContent.class.getClassLoader()));
        }
    }

    public static enum AppGroupPrivacy {
        Open,
        Closed;

    }
}

