/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.places.model;

import java.util.HashSet;
import java.util.Set;

public final class PlaceInfoRequestParams {
    private final String placeId;
    private final Set<String> fields = new HashSet<String>();

    private PlaceInfoRequestParams(Builder b) {
        this.placeId = b.placeId;
        this.fields.addAll(b.fields);
    }

    public String getPlaceId() {
        return this.placeId;
    }

    public Set<String> getFields() {
        return this.fields;
    }

    public static class Builder {
        private String placeId;
        private final Set<String> fields = new HashSet<String>();

        public Builder setPlaceId(String placeId) {
            this.placeId = placeId;
            return this;
        }

        public Builder addField(String field) {
            this.fields.add(field);
            return this;
        }

        public Builder addFields(String[] fields) {
            for (String field : fields) {
                this.fields.add(field);
            }
            return this;
        }

        public PlaceInfoRequestParams build() {
            return new PlaceInfoRequestParams(this);
        }
    }
}

