/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.AsyncTask;
import android.util.Base64;
import android.util.Log;
import com.facebook.AccessToken;
import com.facebook.AccessTokenManager;
import com.facebook.FacebookException;
import com.facebook.FacebookRequestError;
import com.facebook.GraphRequest;
import com.facebook.GraphRequestBatch;
import com.facebook.GraphResponse;
import com.facebook.LoggingBehavior;
import com.facebook.Profile;
import com.facebook.ProfileManager;
import com.facebook.R;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.internal.AppEventsLoggerUtility;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.BoltsMeasurementEventListener;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.LockOnGetVariable;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.ServerProtocol;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONException;
import org.json.JSONObject;

public final class FacebookSdk {
    private static final String TAG = FacebookSdk.class.getCanonicalName();
    private static final HashSet<LoggingBehavior> loggingBehaviors = new HashSet<LoggingBehavior>(Arrays.asList(LoggingBehavior.DEVELOPER_ERRORS));
    private static final int DEFAULT_CALLBACK_REQUEST_CODE_OFFSET = 64206;
    private static volatile Executor executor;
    private static volatile String applicationId;
    private static volatile String applicationName;
    private static volatile String appClientToken;
    private static volatile int webDialogTheme;
    private static volatile Boolean autoLogAppEventsEnabled;
    private static final String FACEBOOK_COM = "facebook.com";
    private static volatile String facebookDomain;
    private static AtomicLong onProgressThreshold;
    private static volatile boolean isDebugEnabled;
    private static boolean isLegacyTokenUpgradeSupported;
    private static LockOnGetVariable<File> cacheDir;
    private static Context applicationContext;
    private static final int DEFAULT_CORE_POOL_SIZE = 5;
    private static final int DEFAULT_MAXIMUM_POOL_SIZE = 128;
    private static final int DEFAULT_KEEP_ALIVE = 1;
    private static int callbackRequestCodeOffset;
    private static final Object LOCK;
    private static final int DEFAULT_THEME;
    private static String graphApiVersion;
    private static final int MAX_REQUEST_CODE_RANGE = 100;
    private static final String ATTRIBUTION_PREFERENCES = "com.facebook.sdk.attributionTracking";
    private static final String PUBLISH_ACTIVITY_PATH = "%s/activities";
    private static final BlockingQueue<Runnable> DEFAULT_WORK_QUEUE;
    private static final ThreadFactory DEFAULT_THREAD_FACTORY;
    static final String CALLBACK_OFFSET_CHANGED_AFTER_INIT = "The callback request code offset can't be updated once the SDK is initialized. Call FacebookSdk.setCallbackRequestCodeOffset inside your Application.onCreate method";
    static final String CALLBACK_OFFSET_NEGATIVE = "The callback request code offset can't be negative.";
    public static final String APPLICATION_ID_PROPERTY = "com.facebook.sdk.ApplicationId";
    public static final String APPLICATION_NAME_PROPERTY = "com.facebook.sdk.ApplicationName";
    public static final String CLIENT_TOKEN_PROPERTY = "com.facebook.sdk.ClientToken";
    public static final String WEB_DIALOG_THEME = "com.facebook.sdk.WebDialogTheme";
    public static final String AUTO_LOG_APP_EVENTS_ENABLED_PROPERTY = "com.facebook.sdk.AutoLogAppEventsEnabled";
    public static final String CALLBACK_OFFSET_PROPERTY = "com.facebook.sdk.CallbackOffset";
    private static Boolean sdkInitialized;

    @Deprecated
    public static synchronized void sdkInitialize(Context applicationContext, int callbackRequestCodeOffset) {
        FacebookSdk.sdkInitialize(applicationContext, callbackRequestCodeOffset, null);
    }

    @Deprecated
    public static synchronized void sdkInitialize(Context applicationContext, int callbackRequestCodeOffset, InitializeCallback callback) {
        if (sdkInitialized.booleanValue() && callbackRequestCodeOffset != FacebookSdk.callbackRequestCodeOffset) {
            throw new FacebookException(CALLBACK_OFFSET_CHANGED_AFTER_INIT);
        }
        if (callbackRequestCodeOffset < 0) {
            throw new FacebookException(CALLBACK_OFFSET_NEGATIVE);
        }
        FacebookSdk.callbackRequestCodeOffset = callbackRequestCodeOffset;
        FacebookSdk.sdkInitialize(applicationContext, callback);
    }

    @Deprecated
    public static synchronized void sdkInitialize(Context applicationContext) {
        FacebookSdk.sdkInitialize(applicationContext, null);
    }

    @Deprecated
    public static synchronized void sdkInitialize(final Context applicationContext, final InitializeCallback callback) {
        if (sdkInitialized.booleanValue()) {
            if (callback != null) {
                callback.onInitialized();
            }
            return;
        }
        Validate.notNull(applicationContext, "applicationContext");
        Validate.hasFacebookActivity(applicationContext, false);
        Validate.hasInternetPermissions(applicationContext, false);
        FacebookSdk.applicationContext = applicationContext.getApplicationContext();
        FacebookSdk.loadDefaultsFromMetadata(FacebookSdk.applicationContext);
        if (Utility.isNullOrEmpty(applicationId)) {
            throw new FacebookException("A valid Facebook app id must be set in the AndroidManifest.xml or set by calling FacebookSdk.setApplicationId before initializing the sdk.");
        }
        sdkInitialized = true;
        FetchedAppSettingsManager.loadAppSettingsAsync();
        NativeProtocol.updateAllAvailableProtocolVersionsAsync();
        BoltsMeasurementEventListener.getInstance(FacebookSdk.applicationContext);
        cacheDir = new LockOnGetVariable<File>(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return applicationContext.getCacheDir();
            }
        });
        FutureTask<Void> futureTask = new FutureTask<Void>(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AccessTokenManager.getInstance().loadCurrentAccessToken();
                ProfileManager.getInstance().loadCurrentProfile();
                if (AccessToken.getCurrentAccessToken() != null && Profile.getCurrentProfile() == null) {
                    Profile.fetchProfileForCurrentAccessToken();
                }
                if (callback != null) {
                    callback.onInitialized();
                }
                AppEventsLogger.newLogger(applicationContext.getApplicationContext()).flush();
                return null;
            }
        });
        FacebookSdk.getExecutor().execute(futureTask);
    }

    public static synchronized boolean isInitialized() {
        return sdkInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<LoggingBehavior> getLoggingBehaviors() {
        HashSet<LoggingBehavior> hashSet = loggingBehaviors;
        synchronized (hashSet) {
            return Collections.unmodifiableSet(new HashSet<LoggingBehavior>(loggingBehaviors));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLoggingBehavior(LoggingBehavior behavior) {
        HashSet<LoggingBehavior> hashSet = loggingBehaviors;
        synchronized (hashSet) {
            loggingBehaviors.add(behavior);
            FacebookSdk.updateGraphDebugBehavior();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLoggingBehavior(LoggingBehavior behavior) {
        HashSet<LoggingBehavior> hashSet = loggingBehaviors;
        synchronized (hashSet) {
            loggingBehaviors.remove((Object)behavior);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearLoggingBehaviors() {
        HashSet<LoggingBehavior> hashSet = loggingBehaviors;
        synchronized (hashSet) {
            loggingBehaviors.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLoggingBehaviorEnabled(LoggingBehavior behavior) {
        HashSet<LoggingBehavior> hashSet = loggingBehaviors;
        synchronized (hashSet) {
            return FacebookSdk.isDebugEnabled() && loggingBehaviors.contains((Object)behavior);
        }
    }

    public static boolean isDebugEnabled() {
        return isDebugEnabled;
    }

    public static void setIsDebugEnabled(boolean enabled) {
        isDebugEnabled = enabled;
    }

    public static boolean isLegacyTokenUpgradeSupported() {
        return isLegacyTokenUpgradeSupported;
    }

    private static void updateGraphDebugBehavior() {
        if (loggingBehaviors.contains((Object)LoggingBehavior.GRAPH_API_DEBUG_INFO) && !loggingBehaviors.contains((Object)LoggingBehavior.GRAPH_API_DEBUG_WARNING)) {
            loggingBehaviors.add(LoggingBehavior.GRAPH_API_DEBUG_WARNING);
        }
    }

    public static void setLegacyTokenUpgradeSupported(boolean supported) {
        isLegacyTokenUpgradeSupported = supported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Executor getExecutor() {
        Object object = LOCK;
        synchronized (object) {
            if (executor == null) {
                executor = AsyncTask.THREAD_POOL_EXECUTOR;
            }
        }
        return executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setExecutor(Executor executor) {
        Validate.notNull(executor, "executor");
        Object object = LOCK;
        synchronized (object) {
            FacebookSdk.executor = executor;
        }
    }

    public static String getFacebookDomain() {
        return facebookDomain;
    }

    public static void setFacebookDomain(String facebookDomain) {
        Log.w((String)TAG, (String)"WARNING: Calling setFacebookDomain from non-DEBUG code.");
        FacebookSdk.facebookDomain = facebookDomain;
    }

    public static Context getApplicationContext() {
        Validate.sdkInitialized();
        return applicationContext;
    }

    public static void setGraphApiVersion(String graphApiVersion) {
        if (!Utility.isNullOrEmpty(graphApiVersion) && !FacebookSdk.graphApiVersion.equals(graphApiVersion)) {
            FacebookSdk.graphApiVersion = graphApiVersion;
        }
    }

    public static String getGraphApiVersion() {
        return graphApiVersion;
    }

    public static void publishInstallAsync(Context context, final String applicationId) {
        final Context applicationContext = context.getApplicationContext();
        FacebookSdk.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                FacebookSdk.publishInstallAndWaitForResponse(applicationContext, applicationId);
            }
        });
    }

    static GraphResponse publishInstallAndWaitForResponse(Context context, String applicationId) {
        try {
            JSONObject publishParams;
            if (context == null || applicationId == null) {
                throw new IllegalArgumentException("Both context and applicationId must be non-null");
            }
            AttributionIdentifiers identifiers = AttributionIdentifiers.getAttributionIdentifiers(context);
            SharedPreferences preferences = context.getSharedPreferences(ATTRIBUTION_PREFERENCES, 0);
            String pingKey = applicationId + "ping";
            String jsonKey = applicationId + "json";
            long lastPing = preferences.getLong(pingKey, 0L);
            String lastResponseJSON = preferences.getString(jsonKey, null);
            try {
                publishParams = AppEventsLoggerUtility.getJSONObjectForGraphAPICall(AppEventsLoggerUtility.GraphAPIActivityType.MOBILE_INSTALL_EVENT, identifiers, AppEventsLogger.getAnonymousAppDeviceGUID(context), FacebookSdk.getLimitEventAndDataUsage(context), context);
            }
            catch (JSONException e) {
                throw new FacebookException("An error occurred while publishing install.", e);
            }
            String publishUrl = String.format(PUBLISH_ACTIVITY_PATH, applicationId);
            GraphRequest publishRequest = GraphRequest.newPostRequest(null, publishUrl, publishParams, null);
            if (lastPing != 0L) {
                JSONObject graphObject = null;
                try {
                    if (lastResponseJSON != null) {
                        graphObject = new JSONObject(lastResponseJSON);
                    }
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                if (graphObject == null) {
                    return GraphResponse.createResponsesFromString("true", null, new GraphRequestBatch(publishRequest)).get(0);
                }
                return new GraphResponse(null, null, null, graphObject);
            }
            GraphResponse publishResponse = publishRequest.executeAndWait();
            SharedPreferences.Editor editor = preferences.edit();
            lastPing = System.currentTimeMillis();
            editor.putLong(pingKey, lastPing);
            if (publishResponse.getJSONObject() != null) {
                editor.putString(jsonKey, publishResponse.getJSONObject().toString());
            }
            editor.apply();
            return publishResponse;
        }
        catch (Exception e) {
            Utility.logd("Facebook-publish", e);
            return new GraphResponse(null, null, new FacebookRequestError(null, e));
        }
    }

    public static String getSdkVersion() {
        return "4.22.0";
    }

    public static boolean getLimitEventAndDataUsage(Context context) {
        Validate.sdkInitialized();
        SharedPreferences preferences = context.getSharedPreferences("com.facebook.sdk.appEventPreferences", 0);
        return preferences.getBoolean("limitEventUsage", false);
    }

    public static void setLimitEventAndDataUsage(Context context, boolean limitEventUsage) {
        context.getSharedPreferences("com.facebook.sdk.appEventPreferences", 0).edit().putBoolean("limitEventUsage", limitEventUsage).apply();
    }

    public static long getOnProgressThreshold() {
        Validate.sdkInitialized();
        return onProgressThreshold.get();
    }

    public static void setOnProgressThreshold(long threshold) {
        onProgressThreshold.set(threshold);
    }

    static void loadDefaultsFromMetadata(Context context) {
        if (context == null) {
            return;
        }
        ApplicationInfo ai = null;
        try {
            ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            return;
        }
        if (ai == null || ai.metaData == null) {
            return;
        }
        if (applicationId == null) {
            Object appId = ai.metaData.get(APPLICATION_ID_PROPERTY);
            if (appId instanceof String) {
                String appIdString = (String)appId;
                applicationId = appIdString.toLowerCase(Locale.ROOT).startsWith("fb") ? appIdString.substring(2) : appIdString;
            } else if (appId instanceof Integer) {
                throw new FacebookException("App Ids cannot be directly placed in the manifest.They must be prefixed by 'fb' or be placed in the string resource file.");
            }
        }
        if (applicationName == null) {
            applicationName = ai.metaData.getString(APPLICATION_NAME_PROPERTY);
        }
        if (appClientToken == null) {
            appClientToken = ai.metaData.getString(CLIENT_TOKEN_PROPERTY);
        }
        if (webDialogTheme == 0) {
            FacebookSdk.setWebDialogTheme(ai.metaData.getInt(WEB_DIALOG_THEME));
        }
        if (callbackRequestCodeOffset == 64206) {
            callbackRequestCodeOffset = ai.metaData.getInt(CALLBACK_OFFSET_PROPERTY, 64206);
        }
        if (autoLogAppEventsEnabled == null) {
            autoLogAppEventsEnabled = ai.metaData.getBoolean(AUTO_LOG_APP_EVENTS_ENABLED_PROPERTY, true);
        }
    }

    public static String getApplicationSignature(Context context) {
        MessageDigest md;
        PackageInfo pInfo;
        Validate.sdkInitialized();
        if (context == null) {
            return null;
        }
        PackageManager packageManager = context.getPackageManager();
        if (packageManager == null) {
            return null;
        }
        String packageName = context.getPackageName();
        try {
            pInfo = packageManager.getPackageInfo(packageName, 64);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
        Signature[] signatures = pInfo.signatures;
        if (signatures == null || signatures.length == 0) {
            return null;
        }
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        md.update(pInfo.signatures[0].toByteArray());
        return Base64.encodeToString((byte[])md.digest(), (int)9);
    }

    public static String getApplicationId() {
        Validate.sdkInitialized();
        return applicationId;
    }

    public static void setApplicationId(String applicationId) {
        FacebookSdk.applicationId = applicationId;
    }

    public static String getApplicationName() {
        Validate.sdkInitialized();
        return applicationName;
    }

    public static void setApplicationName(String applicationName) {
        FacebookSdk.applicationName = applicationName;
    }

    public static String getClientToken() {
        Validate.sdkInitialized();
        return appClientToken;
    }

    public static void setClientToken(String clientToken) {
        appClientToken = clientToken;
    }

    public static int getWebDialogTheme() {
        Validate.sdkInitialized();
        return webDialogTheme;
    }

    public static void setWebDialogTheme(int theme) {
        webDialogTheme = theme != 0 ? theme : DEFAULT_THEME;
    }

    public static boolean getAutoLogAppEventsEnabled() {
        Validate.sdkInitialized();
        return autoLogAppEventsEnabled;
    }

    public static void setAutoLogAppEventsEnabled(boolean flag) {
        autoLogAppEventsEnabled = flag;
    }

    public static File getCacheDir() {
        Validate.sdkInitialized();
        return cacheDir.getValue();
    }

    public static void setCacheDir(File cacheDir) {
        FacebookSdk.cacheDir = new LockOnGetVariable<File>(cacheDir);
    }

    public static int getCallbackRequestCodeOffset() {
        Validate.sdkInitialized();
        return callbackRequestCodeOffset;
    }

    public static boolean isFacebookRequestCode(int requestCode) {
        return requestCode >= callbackRequestCodeOffset && requestCode < callbackRequestCodeOffset + 100;
    }

    static {
        facebookDomain = FACEBOOK_COM;
        onProgressThreshold = new AtomicLong(65536L);
        isDebugEnabled = false;
        isLegacyTokenUpgradeSupported = false;
        callbackRequestCodeOffset = 64206;
        LOCK = new Object();
        DEFAULT_THEME = R.style.com_facebook_activity_theme;
        graphApiVersion = ServerProtocol.getDefaultAPIVersion();
        DEFAULT_WORK_QUEUE = new LinkedBlockingQueue<Runnable>(10);
        DEFAULT_THREAD_FACTORY = new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, "FacebookSdk #" + this.counter.incrementAndGet());
            }
        };
        sdkInitialized = false;
    }

    public static interface InitializeCallback {
        public void onInitialized();
    }
}

