/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import com.facebook.FacebookRequestError;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public final class FacebookRequestErrorClassification {
    public static final int EC_SERVICE_UNAVAILABLE = 2;
    public static final int EC_APP_TOO_MANY_CALLS = 4;
    public static final int EC_RATE = 9;
    public static final int EC_USER_TOO_MANY_CALLS = 17;
    public static final int EC_INVALID_SESSION = 102;
    public static final int EC_INVALID_TOKEN = 190;
    public static final int EC_TOO_MANY_USER_ACTION_CALLS = 341;
    public static final String KEY_RECOVERY_MESSAGE = "recovery_message";
    public static final String KEY_NAME = "name";
    public static final String KEY_OTHER = "other";
    public static final String KEY_TRANSIENT = "transient";
    public static final String KEY_LOGIN_RECOVERABLE = "login_recoverable";
    private final Map<Integer, Set<Integer>> otherErrors;
    private final Map<Integer, Set<Integer>> transientErrors;
    private final Map<Integer, Set<Integer>> loginRecoverableErrors;
    private final String otherRecoveryMessage;
    private final String transientRecoveryMessage;
    private final String loginRecoverableRecoveryMessage;
    private static FacebookRequestErrorClassification defaultInstance;

    FacebookRequestErrorClassification(Map<Integer, Set<Integer>> otherErrors, Map<Integer, Set<Integer>> transientErrors, Map<Integer, Set<Integer>> loginRecoverableErrors, String otherRecoveryMessage, String transientRecoveryMessage, String loginRecoverableRecoveryMessage) {
        this.otherErrors = otherErrors;
        this.transientErrors = transientErrors;
        this.loginRecoverableErrors = loginRecoverableErrors;
        this.otherRecoveryMessage = otherRecoveryMessage;
        this.transientRecoveryMessage = transientRecoveryMessage;
        this.loginRecoverableRecoveryMessage = loginRecoverableRecoveryMessage;
    }

    public Map<Integer, Set<Integer>> getOtherErrors() {
        return this.otherErrors;
    }

    public Map<Integer, Set<Integer>> getTransientErrors() {
        return this.transientErrors;
    }

    public Map<Integer, Set<Integer>> getLoginRecoverableErrors() {
        return this.loginRecoverableErrors;
    }

    public String getRecoveryMessage(FacebookRequestError.Category category) {
        switch (category) {
            case OTHER: {
                return this.otherRecoveryMessage;
            }
            case LOGIN_RECOVERABLE: {
                return this.loginRecoverableRecoveryMessage;
            }
            case TRANSIENT: {
                return this.transientRecoveryMessage;
            }
        }
        return null;
    }

    public FacebookRequestError.Category classify(int errorCode, int errorSubCode, boolean isTransient) {
        Set<Integer> subCodes;
        if (isTransient) {
            return FacebookRequestError.Category.TRANSIENT;
        }
        if (this.otherErrors != null && this.otherErrors.containsKey(errorCode) && ((subCodes = this.otherErrors.get(errorCode)) == null || subCodes.contains(errorSubCode))) {
            return FacebookRequestError.Category.OTHER;
        }
        if (this.loginRecoverableErrors != null && this.loginRecoverableErrors.containsKey(errorCode) && ((subCodes = this.loginRecoverableErrors.get(errorCode)) == null || subCodes.contains(errorSubCode))) {
            return FacebookRequestError.Category.LOGIN_RECOVERABLE;
        }
        if (this.transientErrors != null && this.transientErrors.containsKey(errorCode) && ((subCodes = this.transientErrors.get(errorCode)) == null || subCodes.contains(errorSubCode))) {
            return FacebookRequestError.Category.TRANSIENT;
        }
        return FacebookRequestError.Category.OTHER;
    }

    public static synchronized FacebookRequestErrorClassification getDefaultErrorClassification() {
        if (defaultInstance == null) {
            defaultInstance = FacebookRequestErrorClassification.getDefaultErrorClassificationImpl();
        }
        return defaultInstance;
    }

    private static FacebookRequestErrorClassification getDefaultErrorClassificationImpl() {
        HashMap<Integer, Set<Integer>> transientErrors = new HashMap<Integer, Set<Integer>>(){
            {
                this.put(2, null);
                this.put(4, null);
                this.put(9, null);
                this.put(17, null);
                this.put(341, null);
            }
        };
        HashMap<Integer, Set<Integer>> loginRecoverableErrors = new HashMap<Integer, Set<Integer>>(){
            {
                this.put(102, null);
                this.put(190, null);
            }
        };
        return new FacebookRequestErrorClassification(null, (Map<Integer, Set<Integer>>)transientErrors, (Map<Integer, Set<Integer>>)loginRecoverableErrors, null, null, null);
    }

    private static Map<Integer, Set<Integer>> parseJSONDefinition(JSONObject definition) {
        JSONArray itemsArray = definition.optJSONArray("items");
        if (itemsArray.length() == 0) {
            return null;
        }
        HashMap<Integer, Set<Integer>> items = new HashMap<Integer, Set<Integer>>();
        for (int i = 0; i < itemsArray.length(); ++i) {
            int code;
            JSONObject item = itemsArray.optJSONObject(i);
            if (item == null || (code = item.optInt("code")) == 0) continue;
            HashSet<Integer> subcodes = null;
            JSONArray subcodesArray = item.optJSONArray("subcodes");
            if (subcodesArray != null && subcodesArray.length() > 0) {
                subcodes = new HashSet<Integer>();
                for (int j = 0; j < subcodesArray.length(); ++j) {
                    int subCode = subcodesArray.optInt(j);
                    if (subCode == 0) continue;
                    subcodes.add(subCode);
                }
            }
            items.put(code, subcodes);
        }
        return items;
    }

    public static FacebookRequestErrorClassification createFromJSON(JSONArray jsonArray) {
        if (jsonArray == null) {
            return null;
        }
        Map<Integer, Set<Integer>> otherErrors = null;
        Map<Integer, Set<Integer>> transientErrors = null;
        Map<Integer, Set<Integer>> loginRecoverableErrors = null;
        String otherRecoveryMessage = null;
        String transientRecoveryMessage = null;
        String loginRecoverableRecoveryMessage = null;
        for (int i = 0; i < jsonArray.length(); ++i) {
            String name;
            JSONObject definition = jsonArray.optJSONObject(i);
            if (definition == null || (name = definition.optString(KEY_NAME)) == null) continue;
            if (name.equalsIgnoreCase(KEY_OTHER)) {
                otherRecoveryMessage = definition.optString(KEY_RECOVERY_MESSAGE, null);
                otherErrors = FacebookRequestErrorClassification.parseJSONDefinition(definition);
                continue;
            }
            if (name.equalsIgnoreCase(KEY_TRANSIENT)) {
                transientRecoveryMessage = definition.optString(KEY_RECOVERY_MESSAGE, null);
                transientErrors = FacebookRequestErrorClassification.parseJSONDefinition(definition);
                continue;
            }
            if (!name.equalsIgnoreCase(KEY_LOGIN_RECOVERABLE)) continue;
            loginRecoverableRecoveryMessage = definition.optString(KEY_RECOVERY_MESSAGE, null);
            loginRecoverableErrors = FacebookRequestErrorClassification.parseJSONDefinition(definition);
        }
        return new FacebookRequestErrorClassification(otherErrors, transientErrors, loginRecoverableErrors, otherRecoveryMessage, transientRecoveryMessage, loginRecoverableRecoveryMessage);
    }
}

