/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.facebook.AccessToken;
import com.facebook.AccessTokenSource;
import com.facebook.FacebookException;
import com.facebook.FacebookRequestError;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.HttpMethod;
import com.facebook.internal.Utility;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TestUserManager {
    private static final String LOG_TAG = "TestUserManager";
    private String testApplicationSecret;
    private String testApplicationId;
    private Map<String, JSONObject> appTestAccounts;

    public TestUserManager(String testApplicationSecret, String testApplicationId) {
        if (Utility.isNullOrEmpty(testApplicationId) || Utility.isNullOrEmpty(testApplicationSecret)) {
            throw new FacebookException("Must provide app ID and secret");
        }
        this.testApplicationSecret = testApplicationSecret;
        this.testApplicationId = testApplicationId;
    }

    public AccessToken getAccessTokenForPrivateUser(List<String> permissions) {
        return this.getAccessTokenForUser(permissions, Mode.PRIVATE, null);
    }

    public AccessToken getAccessTokenForSharedUser(List<String> permissions) {
        return this.getAccessTokenForSharedUser(permissions, null);
    }

    public AccessToken getAccessTokenForSharedUser(List<String> permissions, String uniqueUserTag) {
        return this.getAccessTokenForUser(permissions, Mode.SHARED, uniqueUserTag);
    }

    public synchronized String getTestApplicationId() {
        return this.testApplicationId;
    }

    public synchronized String getTestApplicationSecret() {
        return this.testApplicationSecret;
    }

    private AccessToken getAccessTokenForUser(List<String> permissions, Mode mode, String uniqueUserTag) {
        this.retrieveTestAccountsForAppIfNeeded();
        if (Utility.isNullOrEmpty(permissions)) {
            permissions = Arrays.asList("email", "publish_actions");
        }
        JSONObject testAccount = null;
        testAccount = mode == Mode.PRIVATE ? this.createTestAccount(permissions, mode, uniqueUserTag) : this.findOrCreateSharedTestAccount(permissions, mode, uniqueUserTag);
        return new AccessToken(testAccount.optString("access_token"), this.testApplicationId, testAccount.optString("id"), permissions, null, AccessTokenSource.TEST_USER, null, null);
    }

    private synchronized void retrieveTestAccountsForAppIfNeeded() {
        if (this.appTestAccounts != null) {
            return;
        }
        this.appTestAccounts = new HashMap<String, JSONObject>();
        GraphRequest.setDefaultBatchApplicationId(this.testApplicationId);
        Bundle parameters = new Bundle();
        parameters.putString("access_token", this.getAppAccessToken());
        GraphRequest requestTestUsers = new GraphRequest(null, "app/accounts/test-users", parameters, null);
        requestTestUsers.setBatchEntryName("testUsers");
        requestTestUsers.setBatchEntryOmitResultOnSuccess(false);
        Bundle testUserNamesParam = new Bundle();
        testUserNamesParam.putString("access_token", this.getAppAccessToken());
        testUserNamesParam.putString("ids", "{result=testUsers:$.data.*.id}");
        testUserNamesParam.putString("fields", "name");
        GraphRequest requestTestUserNames = new GraphRequest(null, "", testUserNamesParam, null);
        requestTestUserNames.setBatchEntryDependsOn("testUsers");
        List<GraphResponse> responses = GraphRequest.executeBatchAndWait(requestTestUsers, requestTestUserNames);
        if (responses == null || responses.size() != 2) {
            throw new FacebookException("Unexpected number of results from TestUsers batch query");
        }
        JSONObject testAccountsResponse = responses.get(0).getJSONObject();
        JSONArray testAccounts = testAccountsResponse.optJSONArray("data");
        JSONObject userAccountsMap = responses.get(1).getJSONObject();
        this.populateTestAccounts(testAccounts, userAccountsMap);
    }

    private synchronized void populateTestAccounts(JSONArray testAccounts, JSONObject userAccountsMap) {
        for (int i = 0; i < testAccounts.length(); ++i) {
            JSONObject testAccount = testAccounts.optJSONObject(i);
            JSONObject testUser = userAccountsMap.optJSONObject(testAccount.optString("id"));
            try {
                testAccount.put("name", (Object)testUser.optString("name"));
            }
            catch (JSONException e) {
                Log.e((String)LOG_TAG, (String)"Could not set name", (Throwable)e);
            }
            this.storeTestAccount(testAccount);
        }
    }

    private synchronized void storeTestAccount(JSONObject testAccount) {
        this.appTestAccounts.put(testAccount.optString("id"), testAccount);
    }

    private synchronized JSONObject findTestAccountMatchingIdentifier(String identifier) {
        for (JSONObject testAccount : this.appTestAccounts.values()) {
            if (!testAccount.optString("name").contains(identifier)) continue;
            return testAccount;
        }
        return null;
    }

    final String getAppAccessToken() {
        return this.testApplicationId + "|" + this.testApplicationSecret;
    }

    private JSONObject findOrCreateSharedTestAccount(List<String> permissions, Mode mode, String uniqueUserTag) {
        JSONObject testAccount = this.findTestAccountMatchingIdentifier(this.getSharedTestAccountIdentifier(permissions, uniqueUserTag));
        if (testAccount != null) {
            return testAccount;
        }
        return this.createTestAccount(permissions, mode, uniqueUserTag);
    }

    private String getSharedTestAccountIdentifier(List<String> permissions, String uniqueUserTag) {
        long permissionsHash = (long)this.getPermissionsString(permissions).hashCode() & 0xFFFFFFFFL;
        long userTagHash = uniqueUserTag != null ? (long)uniqueUserTag.hashCode() & 0xFFFFFFFFL : 0L;
        long combinedHash = permissionsHash ^ userTagHash;
        return this.validNameStringFromInteger(combinedHash);
    }

    private String validNameStringFromInteger(long i) {
        String s = Long.toString(i);
        StringBuilder result = new StringBuilder("Perm");
        char lastChar = '\u0000';
        for (char c : s.toCharArray()) {
            if (c == lastChar) {
                c = (char)(c + 10);
            }
            result.append((char)(c + 97 - 48));
            lastChar = c;
        }
        return result.toString();
    }

    private JSONObject createTestAccount(List<String> permissions, Mode mode, String uniqueUserTag) {
        Bundle parameters = new Bundle();
        parameters.putString("installed", "true");
        parameters.putString("permissions", this.getPermissionsString(permissions));
        parameters.putString("access_token", this.getAppAccessToken());
        if (mode == Mode.SHARED) {
            parameters.putString("name", String.format("Shared %s Testuser", this.getSharedTestAccountIdentifier(permissions, uniqueUserTag)));
        }
        String graphPath = String.format("%s/accounts/test-users", this.testApplicationId);
        GraphRequest createUserRequest = new GraphRequest(null, graphPath, parameters, HttpMethod.POST);
        GraphResponse response = createUserRequest.executeAndWait();
        FacebookRequestError error = response.getError();
        JSONObject testAccount = response.getJSONObject();
        if (error != null) {
            return null;
        }
        assert (testAccount != null);
        if (mode == Mode.SHARED) {
            try {
                testAccount.put("name", (Object)parameters.getString("name"));
            }
            catch (JSONException e) {
                Log.e((String)LOG_TAG, (String)"Could not set name", (Throwable)e);
            }
            this.storeTestAccount(testAccount);
        }
        return testAccount;
    }

    private String getPermissionsString(List<String> permissions) {
        return TextUtils.join((CharSequence)",", permissions);
    }

    private static enum Mode {
        PRIVATE,
        SHARED;

    }
}

