/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.model;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.facebook.share.model.ShareModel;
import com.facebook.share.model.ShareModelBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class ShareContent<P extends ShareContent, E extends Builder>
implements ShareModel {
    private final Uri contentUrl;
    private final List<String> peopleIds;
    private final String placeId;
    private final String ref;

    protected ShareContent(Builder builder) {
        this.contentUrl = builder.contentUrl;
        this.peopleIds = builder.peopleIds;
        this.placeId = builder.placeId;
        this.ref = builder.ref;
    }

    ShareContent(Parcel in) {
        this.contentUrl = (Uri)in.readParcelable(Uri.class.getClassLoader());
        this.peopleIds = this.readUnmodifiableStringList(in);
        this.placeId = in.readString();
        this.ref = in.readString();
    }

    @Nullable
    public Uri getContentUrl() {
        return this.contentUrl;
    }

    @Nullable
    public List<String> getPeopleIds() {
        return this.peopleIds;
    }

    @Nullable
    public String getPlaceId() {
        return this.placeId;
    }

    @Nullable
    public String getRef() {
        return this.ref;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable((Parcelable)this.contentUrl, 0);
        out.writeStringList(this.peopleIds);
        out.writeString(this.placeId);
        out.writeString(this.ref);
    }

    private List<String> readUnmodifiableStringList(Parcel in) {
        ArrayList list = new ArrayList();
        in.readStringList(list);
        return list.size() == 0 ? null : Collections.unmodifiableList(list);
    }

    public static abstract class Builder<P extends ShareContent, E extends Builder>
    implements ShareModelBuilder<P, E> {
        private Uri contentUrl;
        private List<String> peopleIds;
        private String placeId;
        private String ref;

        public E setContentUrl(@Nullable Uri contentUrl) {
            this.contentUrl = contentUrl;
            return (E)this;
        }

        public E setPeopleIds(@Nullable List<String> peopleIds) {
            this.peopleIds = peopleIds == null ? null : Collections.unmodifiableList(peopleIds);
            return (E)this;
        }

        public E setPlaceId(@Nullable String placeId) {
            this.placeId = placeId;
            return (E)this;
        }

        public E setRef(@Nullable String ref) {
            this.ref = ref;
            return (E)this;
        }

        @Override
        public E readFrom(P content) {
            if (content == null) {
                return (E)this;
            }
            return ((Builder)((Builder)((Builder)this.setContentUrl(((ShareContent)content).getContentUrl())).setPeopleIds(((ShareContent)content).getPeopleIds())).setPlaceId(((ShareContent)content).getPlaceId())).setRef(((ShareContent)content).getRef());
        }
    }
}

