/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import com.facebook.internal.NativeProtocol;

public abstract class PlatformServiceClient
implements ServiceConnection {
    private final Context context;
    private final Handler handler;
    private CompletedListener listener;
    private boolean running;
    private Messenger sender;
    private int requestMessage;
    private int replyMessage;
    private final String applicationId;
    private final int protocolVersion;

    public PlatformServiceClient(Context context, int requestMessage, int replyMessage, int protocolVersion, String applicationId) {
        Context applicationContext = context.getApplicationContext();
        this.context = applicationContext != null ? applicationContext : context;
        this.requestMessage = requestMessage;
        this.replyMessage = replyMessage;
        this.applicationId = applicationId;
        this.protocolVersion = protocolVersion;
        this.handler = new Handler(){

            public void handleMessage(Message message) {
                PlatformServiceClient.this.handleMessage(message);
            }
        };
    }

    public void setCompletedListener(CompletedListener listener) {
        this.listener = listener;
    }

    protected Context getContext() {
        return this.context;
    }

    public boolean start() {
        if (this.running) {
            return false;
        }
        int availableVersion = NativeProtocol.getLatestAvailableProtocolVersionForService(this.protocolVersion);
        if (availableVersion == -1) {
            return false;
        }
        Intent intent = NativeProtocol.createPlatformServiceIntent(this.context);
        if (intent == null) {
            return false;
        }
        this.running = true;
        this.context.bindService(intent, (ServiceConnection)this, 1);
        return true;
    }

    public void cancel() {
        this.running = false;
    }

    public void onServiceConnected(ComponentName name, IBinder service) {
        this.sender = new Messenger(service);
        this.sendMessage();
    }

    public void onServiceDisconnected(ComponentName name) {
        this.sender = null;
        try {
            this.context.unbindService((ServiceConnection)this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.callback(null);
    }

    private void sendMessage() {
        Bundle data = new Bundle();
        data.putString("com.facebook.platform.extra.APPLICATION_ID", this.applicationId);
        this.populateRequestBundle(data);
        Message request = Message.obtain(null, (int)this.requestMessage);
        request.arg1 = this.protocolVersion;
        request.setData(data);
        request.replyTo = new Messenger(this.handler);
        try {
            this.sender.send(request);
        }
        catch (RemoteException e) {
            this.callback(null);
        }
    }

    protected abstract void populateRequestBundle(Bundle var1);

    protected void handleMessage(Message message) {
        if (message.what == this.replyMessage) {
            Bundle extras = message.getData();
            String errorType = extras.getString("com.facebook.platform.status.ERROR_TYPE");
            if (errorType != null) {
                this.callback(null);
            } else {
                this.callback(extras);
            }
            try {
                this.context.unbindService((ServiceConnection)this);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private void callback(Bundle result) {
        if (!this.running) {
            return;
        }
        this.running = false;
        CompletedListener callback = this.listener;
        if (callback != null) {
            callback.completed(result);
        }
    }

    public static interface CompletedListener {
        public void completed(Bundle var1);
    }
}

