/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.internal;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.appevents.AppEventsLogger;
import com.facebook.appevents.internal.AppEventUtility;
import com.facebook.appevents.internal.AutomaticAnalyticsLogger;
import com.facebook.appevents.internal.Constants;
import com.facebook.appevents.internal.SessionInfo;
import com.facebook.appevents.internal.SessionLogger;
import com.facebook.appevents.internal.SourceApplicationInfo;
import com.facebook.internal.Utility;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ActivityLifecycleTracker {
    private static final String TAG = ActivityLifecycleTracker.class.getCanonicalName();
    private static final String INCORRECT_IMPL_WARNING = "Unexpected activity pause without a matching activity resume. Logging data may be incorrect. Make sure you call activateApp from your Application's onCreate method";
    private static final long INTERRUPTION_THRESHOLD_MILLISECONDS = 1000L;
    private static final ScheduledExecutorService singleThreadExecutor = Executors.newSingleThreadScheduledExecutor();
    private static volatile ScheduledFuture currentFuture;
    private static AtomicInteger foregroundActivityCount;
    private static volatile SessionInfo currentSession;
    private static AtomicBoolean tracking;
    private static String appId;
    private static long currentActivityAppearTime;

    public static void startTracking(Application application, String appId) {
        if (!tracking.compareAndSet(false, true)) {
            return;
        }
        ActivityLifecycleTracker.appId = appId;
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                AppEventUtility.assertIsMainThread();
                ActivityLifecycleTracker.onActivityCreated(activity);
            }

            public void onActivityStarted(Activity activity) {
            }

            public void onActivityResumed(Activity activity) {
                AppEventUtility.assertIsMainThread();
                ActivityLifecycleTracker.onActivityResumed(activity);
            }

            public void onActivityPaused(Activity activity) {
                AppEventUtility.assertIsMainThread();
                ActivityLifecycleTracker.onActivityPaused(activity);
            }

            public void onActivityStopped(Activity activity) {
                AppEventsLogger.onContextStop();
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            }

            public void onActivityDestroyed(Activity activity) {
            }
        });
    }

    public static boolean isTracking() {
        return tracking.get();
    }

    public static UUID getCurrentSessionGuid() {
        return currentSession != null ? currentSession.getSessionId() : null;
    }

    public static void onActivityCreated(final Activity activity) {
        final long currentTime = System.currentTimeMillis();
        Runnable handleActivityCreate = new Runnable(){

            @Override
            public void run() {
                if (currentSession == null) {
                    Context applicationContext = activity.getApplicationContext();
                    String activityName = Utility.getActivityName((Context)activity);
                    SessionInfo lastSession = SessionInfo.getStoredSessionInfo();
                    if (lastSession != null) {
                        SessionLogger.logDeactivateApp(applicationContext, activityName, lastSession, appId);
                    }
                    currentSession = new SessionInfo(currentTime, null);
                    SourceApplicationInfo sourceApplicationInfo = SourceApplicationInfo.Factory.create(activity);
                    currentSession.setSourceApplicationInfo(sourceApplicationInfo);
                    SessionLogger.logActivateApp(applicationContext, activityName, sourceApplicationInfo, appId);
                }
            }
        };
        singleThreadExecutor.execute(handleActivityCreate);
    }

    public static void onActivityResumed(final Activity activity) {
        long currentTime;
        foregroundActivityCount.incrementAndGet();
        ActivityLifecycleTracker.cancelCurrentTask();
        currentActivityAppearTime = currentTime = System.currentTimeMillis();
        Runnable handleActivityResume = new Runnable(){

            @Override
            public void run() {
                Context applicationContext = activity.getApplicationContext();
                String activityName = Utility.getActivityName((Context)activity);
                if (currentSession == null) {
                    currentSession = new SessionInfo(currentTime, null);
                    SessionLogger.logActivateApp(applicationContext, activityName, null, appId);
                } else if (currentSession.getSessionLastEventTime() != null) {
                    long suspendTime = currentTime - currentSession.getSessionLastEventTime();
                    if (suspendTime > (long)(ActivityLifecycleTracker.getSessionTimeoutInSeconds() * 1000)) {
                        SessionLogger.logDeactivateApp(applicationContext, activityName, currentSession, appId);
                        SessionLogger.logActivateApp(applicationContext, activityName, null, appId);
                        currentSession = new SessionInfo(currentTime, null);
                    } else if (suspendTime > 1000L) {
                        currentSession.incrementInterruptionCount();
                    }
                }
                currentSession.setSessionLastEventTime(currentTime);
                currentSession.writeSessionToDisk();
            }
        };
        singleThreadExecutor.execute(handleActivityResume);
    }

    private static void onActivityPaused(Activity activity) {
        int count = foregroundActivityCount.decrementAndGet();
        if (count < 0) {
            foregroundActivityCount.set(0);
            Log.w((String)TAG, (String)INCORRECT_IMPL_WARNING);
        }
        ActivityLifecycleTracker.cancelCurrentTask();
        final long currentTime = System.currentTimeMillis();
        final Context applicationContext = activity.getApplicationContext();
        final String activityName = Utility.getActivityName((Context)activity);
        Runnable handleActivityPaused = new Runnable(){

            @Override
            public void run() {
                long appearTime;
                if (currentSession == null) {
                    currentSession = new SessionInfo(currentTime, null);
                }
                currentSession.setSessionLastEventTime(currentTime);
                if (foregroundActivityCount.get() <= 0) {
                    Runnable task = new Runnable(){

                        @Override
                        public void run() {
                            if (foregroundActivityCount.get() <= 0) {
                                SessionLogger.logDeactivateApp(applicationContext, activityName, currentSession, appId);
                                SessionInfo.clearSavedSessionFromDisk();
                                currentSession = null;
                            }
                            currentFuture = null;
                        }
                    };
                    currentFuture = singleThreadExecutor.schedule(task, (long)ActivityLifecycleTracker.getSessionTimeoutInSeconds(), TimeUnit.SECONDS);
                }
                long timeSpentOnActivityInSeconds = (appearTime = currentActivityAppearTime) > 0L ? (currentTime - appearTime) / 1000L : 0L;
                AutomaticAnalyticsLogger.logActivityTimeSpentEvent(applicationContext, appId, activityName, timeSpentOnActivityInSeconds);
                currentSession.writeSessionToDisk();
            }
        };
        singleThreadExecutor.execute(handleActivityPaused);
    }

    private static int getSessionTimeoutInSeconds() {
        Utility.FetchedAppSettings settings = Utility.getAppSettingsWithoutQuery(FacebookSdk.getApplicationId());
        if (settings == null) {
            return Constants.getDefaultAppEventsSessionTimeoutInSeconds();
        }
        return settings.getSessionTimeoutInSeconds();
    }

    private static void cancelCurrentTask() {
        if (currentFuture != null) {
            currentFuture.cancel(false);
        }
        currentFuture = null;
    }

    static {
        foregroundActivityCount = new AtomicInteger(0);
        tracking = new AtomicBoolean(false);
    }
}

