/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.appevents.internal;

import android.content.Context;
import android.os.Bundle;
import com.facebook.LoggingBehavior;
import com.facebook.appevents.internal.InternalAppEventsLogger;
import com.facebook.appevents.internal.SessionInfo;
import com.facebook.appevents.internal.SourceApplicationInfo;
import com.facebook.internal.Logger;
import java.util.Locale;

class SessionLogger {
    private static final String TAG = SessionLogger.class.getCanonicalName();
    private static final long[] INACTIVE_SECONDS_QUANTA = new long[]{300000L, 900000L, 1800000L, 3600000L, 21600000L, 43200000L, 86400000L, 172800000L, 259200000L, 604800000L, 1209600000L, 1814400000L, 2419200000L, 5184000000L, 7776000000L, 10368000000L, 12960000000L, 15552000000L, 31536000000L};

    SessionLogger() {
    }

    public static void logActivateApp(Context applicationContext, String activityName, SourceApplicationInfo sourceApplicationInfo, String appId) {
        String sourAppInfoStr = sourceApplicationInfo != null ? sourceApplicationInfo.toString() : "Unclassified";
        Bundle eventParams = new Bundle();
        eventParams.putString("fb_mobile_launch_source", sourAppInfoStr);
        new InternalAppEventsLogger(activityName, appId, null).logEvent("fb_mobile_activate_app", eventParams);
    }

    public static void logDeactivateApp(Context applicationContext, String activityName, SessionInfo sessionInfo, String appId) {
        Long sessionLength;
        Long interruptionDurationMillis = sessionInfo.getDiskRestoreTime() - sessionInfo.getSessionLastEventTime();
        if (interruptionDurationMillis < 0L) {
            interruptionDurationMillis = 0L;
            SessionLogger.logClockSkewEvent();
        }
        if ((sessionLength = Long.valueOf(sessionInfo.getSessionLength())) < 0L) {
            SessionLogger.logClockSkewEvent();
            sessionLength = 0L;
        }
        Bundle eventParams = new Bundle();
        eventParams.putInt("fb_mobile_app_interruptions", sessionInfo.getInterruptionCount());
        eventParams.putString("fb_mobile_time_between_sessions", String.format(Locale.ROOT, "session_quanta_%d", SessionLogger.getQuantaIndex(interruptionDurationMillis)));
        SourceApplicationInfo sourceApplicationInfo = sessionInfo.getSourceApplicationInfo();
        String sourAppInfoStr = sourceApplicationInfo != null ? sourceApplicationInfo.toString() : "Unclassified";
        eventParams.putString("fb_mobile_launch_source", sourAppInfoStr);
        eventParams.putLong("_logTime", sessionInfo.getSessionLastEventTime() / 1000L);
        new InternalAppEventsLogger(activityName, appId, null).logEvent("fb_mobile_deactivate_app", sessionLength / 1000L, eventParams);
    }

    private static void logClockSkewEvent() {
        Logger.log(LoggingBehavior.APP_EVENTS, TAG, "Clock skew detected");
    }

    private static int getQuantaIndex(long timeBetweenSessions) {
        int quantaIndex;
        for (quantaIndex = 0; quantaIndex < INACTIVE_SECONDS_QUANTA.length && INACTIVE_SECONDS_QUANTA[quantaIndex] < timeBetweenSessions; ++quantaIndex) {
        }
        return quantaIndex;
    }
}

