/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.net.Uri;
import com.facebook.LoggingBehavior;
import com.facebook.internal.FileLruCache;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

class UrlRedirectCache {
    static final String TAG = UrlRedirectCache.class.getSimpleName();
    private static final String REDIRECT_CONTENT_TAG = TAG + "_Redirect";
    private static volatile FileLruCache urlRedirectCache;

    UrlRedirectCache() {
    }

    static synchronized FileLruCache getCache() throws IOException {
        if (urlRedirectCache == null) {
            urlRedirectCache = new FileLruCache(TAG, new FileLruCache.Limits());
        }
        return urlRedirectCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Uri getRedirectedUri(Uri uri) {
        InputStreamReader reader;
        block6: {
            Uri uri2;
            if (uri == null) {
                return null;
            }
            String uriString = uri.toString();
            reader = null;
            try {
                InputStream stream;
                FileLruCache cache = UrlRedirectCache.getCache();
                boolean redirectExists = false;
                while ((stream = cache.get(uriString, REDIRECT_CONTENT_TAG)) != null) {
                    int bufferLength;
                    redirectExists = true;
                    reader = new InputStreamReader(stream);
                    char[] buffer = new char[128];
                    StringBuilder urlBuilder = new StringBuilder();
                    while ((bufferLength = reader.read(buffer, 0, buffer.length)) > 0) {
                        urlBuilder.append(buffer, 0, bufferLength);
                    }
                    Utility.closeQuietly(reader);
                    uriString = urlBuilder.toString();
                }
                if (!redirectExists) break block6;
                uri2 = Uri.parse((String)uriString);
            }
            catch (IOException iOException) {
                Utility.closeQuietly(reader);
            }
            catch (Throwable throwable) {
                Utility.closeQuietly(reader);
                throw throwable;
            }
            Utility.closeQuietly(reader);
            return uri2;
        }
        Utility.closeQuietly(reader);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cacheUriRedirect(Uri fromUri, Uri toUri) {
        if (fromUri == null || toUri == null) {
            return;
        }
        OutputStream redirectStream = null;
        try {
            FileLruCache cache = UrlRedirectCache.getCache();
            redirectStream = cache.openPutStream(fromUri.toString(), REDIRECT_CONTENT_TAG);
            redirectStream.write(toUri.toString().getBytes());
        }
        catch (IOException iOException) {
            Utility.closeQuietly(redirectStream);
        }
        catch (Throwable throwable) {
            Utility.closeQuietly(redirectStream);
            throw throwable;
        }
        Utility.closeQuietly(redirectStream);
    }

    static void clearCache() {
        try {
            UrlRedirectCache.getCache().clearCache();
        }
        catch (IOException e) {
            Logger.log(LoggingBehavior.CACHE, 5, TAG, "clearCache failed " + e.getMessage());
        }
    }
}

