/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.login;

import android.app.Activity;
import android.app.Fragment;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.Parcelable;
import com.facebook.AccessToken;
import com.facebook.AccessTokenSource;
import com.facebook.CallbackManager;
import com.facebook.FacebookActivity;
import com.facebook.FacebookAuthorizationException;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.GraphResponse;
import com.facebook.Profile;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.FragmentWrapper;
import com.facebook.internal.Validate;
import com.facebook.login.DefaultAudience;
import com.facebook.login.LoginBehavior;
import com.facebook.login.LoginClient;
import com.facebook.login.LoginLogger;
import com.facebook.login.LoginMethodHandler;
import com.facebook.login.LoginResult;
import com.facebook.login.StartActivityDelegate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class LoginManager {
    private static final String PUBLISH_PERMISSION_PREFIX = "publish";
    private static final String MANAGE_PERMISSION_PREFIX = "manage";
    private static final Set<String> OTHER_PUBLISH_PERMISSIONS = LoginManager.getOtherPublishPermissions();
    private static volatile LoginManager instance;
    private LoginBehavior loginBehavior = LoginBehavior.NATIVE_WITH_FALLBACK;
    private DefaultAudience defaultAudience = DefaultAudience.FRIENDS;

    LoginManager() {
        Validate.sdkInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LoginManager getInstance() {
        if (instance != null) return instance;
        Class<LoginManager> clazz = LoginManager.class;
        synchronized (LoginManager.class) {
            if (instance != null) return instance;
            instance = new LoginManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void resolveError(Activity activity, GraphResponse response) {
        this.startLogin(new ActivityStartActivityDelegate(activity), this.createLoginRequestFromResponse(response));
    }

    public void resolveError(android.support.v4.app.Fragment fragment, GraphResponse response) {
        this.resolveError(new FragmentWrapper(fragment), response);
    }

    public void resolveError(Fragment fragment, GraphResponse response) {
        this.resolveError(new FragmentWrapper(fragment), response);
    }

    private void resolveError(FragmentWrapper fragment, GraphResponse response) {
        this.startLogin(new FragmentStartActivityDelegate(fragment), this.createLoginRequestFromResponse(response));
    }

    private LoginClient.Request createLoginRequestFromResponse(GraphResponse response) {
        Validate.notNull(response, "response");
        AccessToken failedToken = response.getRequest().getAccessToken();
        return this.createLoginRequest(failedToken != null ? failedToken.getPermissions() : null);
    }

    public void registerCallback(CallbackManager callbackManager, final FacebookCallback<LoginResult> callback) {
        if (!(callbackManager instanceof CallbackManagerImpl)) {
            throw new FacebookException("Unexpected CallbackManager, please use the provided Factory.");
        }
        ((CallbackManagerImpl)callbackManager).registerCallback(CallbackManagerImpl.RequestCodeOffset.Login.toRequestCode(), new CallbackManagerImpl.Callback(){

            @Override
            public boolean onActivityResult(int resultCode, Intent data) {
                return LoginManager.this.onActivityResult(resultCode, data, callback);
            }
        });
    }

    boolean onActivityResult(int resultCode, Intent data) {
        return this.onActivityResult(resultCode, data, null);
    }

    boolean onActivityResult(int resultCode, Intent data, FacebookCallback<LoginResult> callback) {
        FacebookException exception = null;
        AccessToken newToken = null;
        LoginClient.Result.Code code = LoginClient.Result.Code.ERROR;
        Map<String, String> loggingExtras = null;
        LoginClient.Request originalRequest = null;
        boolean isCanceled = false;
        if (data != null) {
            LoginClient.Result result = (LoginClient.Result)data.getParcelableExtra("com.facebook.LoginFragment:Result");
            if (result != null) {
                originalRequest = result.request;
                code = result.code;
                if (resultCode == -1) {
                    if (result.code == LoginClient.Result.Code.SUCCESS) {
                        newToken = result.token;
                    } else {
                        exception = new FacebookAuthorizationException(result.errorMessage);
                    }
                } else if (resultCode == 0) {
                    isCanceled = true;
                }
                loggingExtras = result.loggingExtras;
            }
        } else if (resultCode == 0) {
            isCanceled = true;
            code = LoginClient.Result.Code.CANCEL;
        }
        if (exception == null && newToken == null && !isCanceled) {
            exception = new FacebookException("Unexpected call to LoginManager.onActivityResult");
        }
        boolean wasLoginActivityTried = true;
        Context context = null;
        this.logCompleteLogin(context, code, loggingExtras, exception, wasLoginActivityTried, originalRequest);
        this.finishLogin(newToken, originalRequest, exception, isCanceled, callback);
        return true;
    }

    public LoginBehavior getLoginBehavior() {
        return this.loginBehavior;
    }

    public LoginManager setLoginBehavior(LoginBehavior loginBehavior) {
        this.loginBehavior = loginBehavior;
        return this;
    }

    public DefaultAudience getDefaultAudience() {
        return this.defaultAudience;
    }

    public LoginManager setDefaultAudience(DefaultAudience defaultAudience) {
        this.defaultAudience = defaultAudience;
        return this;
    }

    public void logOut() {
        AccessToken.setCurrentAccessToken(null);
        Profile.setCurrentProfile(null);
    }

    public void logInWithReadPermissions(android.support.v4.app.Fragment fragment, Collection<String> permissions) {
        this.logInWithReadPermissions(new FragmentWrapper(fragment), permissions);
    }

    public void logInWithReadPermissions(Fragment fragment, Collection<String> permissions) {
        this.logInWithReadPermissions(new FragmentWrapper(fragment), permissions);
    }

    private void logInWithReadPermissions(FragmentWrapper fragment, Collection<String> permissions) {
        this.validateReadPermissions(permissions);
        LoginClient.Request loginRequest = this.createLoginRequest(permissions);
        this.startLogin(new FragmentStartActivityDelegate(fragment), loginRequest);
    }

    public void logInWithReadPermissions(Activity activity, Collection<String> permissions) {
        this.validateReadPermissions(permissions);
        LoginClient.Request loginRequest = this.createLoginRequest(permissions);
        this.startLogin(new ActivityStartActivityDelegate(activity), loginRequest);
    }

    public void logInWithPublishPermissions(android.support.v4.app.Fragment fragment, Collection<String> permissions) {
        this.logInWithPublishPermissions(new FragmentWrapper(fragment), permissions);
    }

    public void logInWithPublishPermissions(Fragment fragment, Collection<String> permissions) {
        this.logInWithPublishPermissions(new FragmentWrapper(fragment), permissions);
    }

    private void logInWithPublishPermissions(FragmentWrapper fragment, Collection<String> permissions) {
        this.validatePublishPermissions(permissions);
        LoginClient.Request loginRequest = this.createLoginRequest(permissions);
        this.startLogin(new FragmentStartActivityDelegate(fragment), loginRequest);
    }

    public void logInWithPublishPermissions(Activity activity, Collection<String> permissions) {
        this.validatePublishPermissions(permissions);
        LoginClient.Request loginRequest = this.createLoginRequest(permissions);
        this.startLogin(new ActivityStartActivityDelegate(activity), loginRequest);
    }

    private void validateReadPermissions(Collection<String> permissions) {
        if (permissions == null) {
            return;
        }
        for (String permission : permissions) {
            if (!LoginManager.isPublishPermission(permission)) continue;
            throw new FacebookException(String.format("Cannot pass a publish or manage permission (%s) to a request for read authorization", permission));
        }
    }

    private void validatePublishPermissions(Collection<String> permissions) {
        if (permissions == null) {
            return;
        }
        for (String permission : permissions) {
            if (LoginManager.isPublishPermission(permission)) continue;
            throw new FacebookException(String.format("Cannot pass a read permission (%s) to a request for publish authorization", permission));
        }
    }

    static boolean isPublishPermission(String permission) {
        return permission != null && (permission.startsWith(PUBLISH_PERMISSION_PREFIX) || permission.startsWith(MANAGE_PERMISSION_PREFIX) || OTHER_PUBLISH_PERMISSIONS.contains(permission));
    }

    private static Set<String> getOtherPublishPermissions() {
        HashSet<String> set = new HashSet<String>(){
            {
                this.add("ads_management");
                this.add("create_event");
                this.add("rsvp_event");
            }
        };
        return Collections.unmodifiableSet(set);
    }

    protected LoginClient.Request createLoginRequest(Collection<String> permissions) {
        LoginClient.Request request = new LoginClient.Request(this.loginBehavior, Collections.unmodifiableSet(permissions != null ? new HashSet<String>(permissions) : new HashSet()), this.defaultAudience, FacebookSdk.getApplicationId(), UUID.randomUUID().toString());
        request.setRerequest(AccessToken.getCurrentAccessToken() != null);
        return request;
    }

    private void startLogin(StartActivityDelegate startActivityDelegate, LoginClient.Request request) throws FacebookException {
        this.logStartLogin((Context)startActivityDelegate.getActivityContext(), request);
        CallbackManagerImpl.registerStaticCallback(CallbackManagerImpl.RequestCodeOffset.Login.toRequestCode(), new CallbackManagerImpl.Callback(){

            @Override
            public boolean onActivityResult(int resultCode, Intent data) {
                return LoginManager.this.onActivityResult(resultCode, data);
            }
        });
        boolean started = this.tryFacebookActivity(startActivityDelegate, request);
        if (!started) {
            FacebookException exception = new FacebookException("Log in attempt failed: FacebookActivity could not be started. Please make sure you added FacebookActivity to the AndroidManifest.");
            boolean wasLoginActivityTried = false;
            this.logCompleteLogin((Context)startActivityDelegate.getActivityContext(), LoginClient.Result.Code.ERROR, null, exception, wasLoginActivityTried, request);
            throw exception;
        }
    }

    private void logStartLogin(Context context, LoginClient.Request loginRequest) {
        LoginLogger loginLogger = LoginLoggerHolder.getLogger(context);
        if (loginLogger != null && loginRequest != null) {
            loginLogger.logStartLogin(loginRequest);
        }
    }

    private void logCompleteLogin(Context context, LoginClient.Result.Code result, Map<String, String> resultExtras, Exception exception, boolean wasLoginActivityTried, LoginClient.Request request) {
        LoginLogger loginLogger = LoginLoggerHolder.getLogger(context);
        if (loginLogger == null) {
            return;
        }
        if (request == null) {
            loginLogger.logUnexpectedError("fb_mobile_login_complete", "Unexpected call to logCompleteLogin with null pendingAuthorizationRequest.");
        } else {
            HashMap<String, String> pendingLoggingExtras = new HashMap<String, String>();
            pendingLoggingExtras.put("try_login_activity", wasLoginActivityTried ? "1" : "0");
            loginLogger.logCompleteLogin(request.getAuthId(), pendingLoggingExtras, result, resultExtras, exception);
        }
    }

    private boolean tryFacebookActivity(StartActivityDelegate startActivityDelegate, LoginClient.Request request) {
        Intent intent = this.getFacebookActivityIntent(request);
        if (!this.resolveIntent(intent)) {
            return false;
        }
        try {
            startActivityDelegate.startActivityForResult(intent, LoginClient.getLoginRequestCode());
        }
        catch (ActivityNotFoundException e) {
            return false;
        }
        return true;
    }

    private boolean resolveIntent(Intent intent) {
        ResolveInfo resolveInfo = FacebookSdk.getApplicationContext().getPackageManager().resolveActivity(intent, 0);
        return resolveInfo != null;
    }

    private Intent getFacebookActivityIntent(LoginClient.Request request) {
        Intent intent = new Intent();
        intent.setClass(FacebookSdk.getApplicationContext(), FacebookActivity.class);
        intent.setAction(request.getLoginBehavior().toString());
        LoginClient.Request authClientRequest = request;
        Bundle extras = new Bundle();
        extras.putParcelable("request", (Parcelable)request);
        intent.putExtras(extras);
        return intent;
    }

    static LoginResult computeLoginResult(LoginClient.Request request, AccessToken newToken) {
        Set<String> requestedPermissions = request.getPermissions();
        HashSet<String> grantedPermissions = new HashSet<String>(newToken.getPermissions());
        if (request.isRerequest()) {
            grantedPermissions.retainAll(requestedPermissions);
        }
        HashSet<String> deniedPermissions = new HashSet<String>(requestedPermissions);
        deniedPermissions.removeAll(grantedPermissions);
        return new LoginResult(newToken, grantedPermissions, deniedPermissions);
    }

    private void finishLogin(AccessToken newToken, LoginClient.Request origRequest, FacebookException exception, boolean isCanceled, FacebookCallback<LoginResult> callback) {
        if (newToken != null) {
            AccessToken.setCurrentAccessToken(newToken);
            Profile.fetchProfileForCurrentAccessToken();
        }
        if (callback != null) {
            LoginResult loginResult;
            LoginResult loginResult2 = loginResult = newToken != null ? LoginManager.computeLoginResult(origRequest, newToken) : null;
            if (isCanceled || loginResult != null && loginResult.getRecentlyGrantedPermissions().size() == 0) {
                callback.onCancel();
            } else if (exception != null) {
                callback.onError(exception);
            } else if (newToken != null) {
                callback.onSuccess(loginResult);
            }
        }
    }

    public static void setSuccessResult(Intent intent, Bundle values) {
        LoginClient.Request request = (LoginClient.Request)intent.getExtras().getParcelable("request");
        AccessToken token = LoginMethodHandler.createAccessTokenFromWebBundle(request.getPermissions(), values, AccessTokenSource.CHROME_CUSTOM_TAB, request.getApplicationId());
        LoginClient.Result result = LoginClient.Result.createTokenResult(request, token);
        intent.putExtra("com.facebook.LoginFragment:Result", (Parcelable)result);
    }

    private static class LoginLoggerHolder {
        private static volatile LoginLogger logger;

        private LoginLoggerHolder() {
        }

        private static synchronized LoginLogger getLogger(Context context) {
            Context context2 = context = context != null ? context : FacebookSdk.getApplicationContext();
            if (context == null) {
                return null;
            }
            if (logger == null) {
                logger = new LoginLogger(context, FacebookSdk.getApplicationId());
            }
            return logger;
        }
    }

    private static class FragmentStartActivityDelegate
    implements StartActivityDelegate {
        private final FragmentWrapper fragment;

        FragmentStartActivityDelegate(FragmentWrapper fragment) {
            Validate.notNull(fragment, "fragment");
            this.fragment = fragment;
        }

        @Override
        public void startActivityForResult(Intent intent, int requestCode) {
            this.fragment.startActivityForResult(intent, requestCode);
        }

        @Override
        public Activity getActivityContext() {
            return this.fragment.getActivity();
        }
    }

    private static class ActivityStartActivityDelegate
    implements StartActivityDelegate {
        private final Activity activity;

        ActivityStartActivityDelegate(Activity activity) {
            Validate.notNull(activity, "activity");
            this.activity = activity;
        }

        @Override
        public void startActivityForResult(Intent intent, int requestCode) {
            this.activity.startActivityForResult(intent, requestCode);
        }

        @Override
        public Activity getActivityContext() {
            return this.activity;
        }
    }
}

