/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.model;

import android.os.Bundle;
import android.os.Parcel;
import android.os.ParcelFormatException;
import android.os.Parcelable;
import com.facebook.share.model.ShareModel;
import com.facebook.share.model.ShareModelBuilder;
import com.facebook.share.model.SharePhoto;
import com.facebook.share.model.ShareVideo;
import java.util.ArrayList;
import java.util.List;

public abstract class ShareMedia
implements ShareModel {
    private final Bundle params;
    public static final Parcelable.Creator<ShareMedia> CREATOR = new Parcelable.Creator<ShareMedia>(){

        public ShareMedia createFromParcel(Parcel in) {
            switch (Type.valueOf(in.readString())) {
                case PHOTO: {
                    return new SharePhoto(in);
                }
                case VIDEO: {
                    return new ShareVideo(in);
                }
            }
            throw new ParcelFormatException("ShareMedia has invalid type");
        }

        public ShareMedia[] newArray(int size) {
            return new ShareMedia[size];
        }
    };

    protected ShareMedia(Builder builder) {
        this.params = new Bundle(builder.params);
    }

    ShareMedia(Parcel in) {
        this.params = in.readBundle();
    }

    @Deprecated
    public Bundle getParameters() {
        return new Bundle(this.params);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.getMediaType().name());
        dest.writeBundle(this.params);
    }

    public abstract Type getMediaType();

    public static abstract class Builder<M extends ShareMedia, B extends Builder>
    implements ShareModelBuilder<M, B> {
        private Bundle params = new Bundle();

        @Deprecated
        public B setParameter(String key, String value) {
            this.params.putString(key, value);
            return (B)this;
        }

        @Deprecated
        public B setParameters(Bundle parameters) {
            this.params.putAll(parameters);
            return (B)this;
        }

        @Override
        public B readFrom(M model) {
            if (model == null) {
                return (B)this;
            }
            return this.setParameters(((ShareMedia)model).getParameters());
        }

        public static void writeListTo(Parcel out, List<ShareMedia> media) {
            out.writeTypedList(media);
        }

        public static List<ShareMedia> readListFrom(Parcel in) {
            ArrayList<ShareMedia> list = new ArrayList<ShareMedia>();
            in.readTypedList(list, CREATOR);
            return list;
        }
    }

    public static enum Type {
        PHOTO,
        VIDEO;

    }
}

