/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.Intent;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import com.facebook.FacebookException;
import com.facebook.FacebookOperationCanceledException;
import com.facebook.FacebookRequestError;
import com.facebook.FacebookSdk;
import com.facebook.FacebookServiceException;
import com.facebook.R;
import com.facebook.internal.FacebookDialogFragment;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.Utility;
import com.facebook.login.LoginFragment;
import com.facebook.login.LoginManager;
import com.facebook.share.internal.DeviceShareDialogFragment;
import com.facebook.share.model.ShareContent;

public class FacebookActivity
extends FragmentActivity {
    public static String PASS_THROUGH_CANCEL_ACTION = "PassThrough";
    private static String FRAGMENT_TAG = "SingleFragment";
    private static final int API_EC_DIALOG_CANCEL = 4201;
    private Fragment singleFragment;

    private static final String getRedirectUrl() {
        return "fb" + FacebookSdk.getApplicationId() + "://authorize";
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.com_facebook_activity_layout);
        Intent intent = this.getIntent();
        if (PASS_THROUGH_CANCEL_ACTION.equals(intent.getAction())) {
            this.handlePassThroughError();
            return;
        }
        FragmentManager manager = this.getSupportFragmentManager();
        Object fragment = manager.findFragmentByTag(FRAGMENT_TAG);
        if (fragment == null) {
            if ("FacebookDialogFragment".equals(intent.getAction())) {
                FacebookDialogFragment dialogFragment = new FacebookDialogFragment();
                dialogFragment.setRetainInstance(true);
                dialogFragment.show(manager, FRAGMENT_TAG);
                fragment = dialogFragment;
            } else if ("DeviceShareDialogFragment".equals(intent.getAction())) {
                DeviceShareDialogFragment dialogFragment = new DeviceShareDialogFragment();
                dialogFragment.setRetainInstance(true);
                dialogFragment.setShareContent((ShareContent)intent.getParcelableExtra("content"));
                dialogFragment.show(manager, FRAGMENT_TAG);
                fragment = dialogFragment;
            } else {
                fragment = new LoginFragment();
                fragment.setRetainInstance(true);
                manager.beginTransaction().add(R.id.com_facebook_fragment_container, fragment, FRAGMENT_TAG).commit();
            }
        }
        this.singleFragment = fragment;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.singleFragment != null) {
            this.singleFragment.onConfigurationChanged(newConfig);
        }
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        String url = intent.getStringExtra("url");
        this.handlePassThroughUrl(url);
    }

    public Fragment getCurrentFragment() {
        return this.singleFragment;
    }

    private void handlePassThroughError() {
        Intent requestIntent = this.getIntent();
        Bundle errorResults = NativeProtocol.getMethodArgumentsFromIntent(requestIntent);
        FacebookException exception = NativeProtocol.getExceptionFromErrorData(errorResults);
        this.sendResult(null, exception);
    }

    private void handlePassThroughUrl(String url) {
        if (url != null && url.startsWith(FacebookActivity.getRedirectUrl())) {
            String errorMessage;
            String error;
            Uri uri = Uri.parse((String)url);
            Bundle values = Utility.parseUrlQueryString(uri.getQuery());
            values.putAll(Utility.parseUrlQueryString(uri.getFragment()));
            if (!(this.singleFragment instanceof LoginFragment) || !((LoginFragment)this.singleFragment).validateChallengeParam(values)) {
                this.sendResult(null, new FacebookException("Invalid state parameter"));
            }
            if ((error = values.getString("error")) == null) {
                error = values.getString("error_type");
            }
            if ((errorMessage = values.getString("error_msg")) == null) {
                errorMessage = values.getString("error_message");
            }
            if (errorMessage == null) {
                errorMessage = values.getString("error_description");
            }
            String errorCodeString = values.getString("error_code");
            int errorCode = -1;
            if (!Utility.isNullOrEmpty(errorCodeString)) {
                try {
                    errorCode = Integer.parseInt(errorCodeString);
                }
                catch (NumberFormatException ex) {
                    errorCode = -1;
                }
            }
            if (Utility.isNullOrEmpty(error) && Utility.isNullOrEmpty(errorMessage) && errorCode == -1) {
                this.sendResult(values, null);
            } else if (error != null && (error.equals("access_denied") || error.equals("OAuthAccessDeniedException"))) {
                this.sendResult(null, new FacebookOperationCanceledException());
            } else if (errorCode == 4201) {
                this.sendResult(null, new FacebookOperationCanceledException());
            } else {
                FacebookRequestError requestError = new FacebookRequestError(errorCode, error, errorMessage);
                this.sendResult(null, new FacebookServiceException(requestError, errorMessage));
            }
        }
    }

    public void sendResult(Bundle results, FacebookException error) {
        int resultCode;
        Intent resultIntent = this.getIntent();
        if (error == null) {
            resultCode = -1;
            LoginManager.setSuccessResult(resultIntent, results);
        } else {
            resultCode = 0;
            resultIntent = NativeProtocol.createProtocolResultIntent(resultIntent, results, error);
        }
        this.setResult(resultCode, resultIntent);
        this.finish();
    }
}

