/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import com.facebook.FacebookException;
import com.facebook.R;
import com.facebook.internal.FacebookDialogFragment;
import com.facebook.internal.NativeProtocol;
import com.facebook.login.LoginFragment;

public class FacebookActivity
extends FragmentActivity {
    public static String PASS_THROUGH_CANCEL_ACTION = "PassThrough";
    private static String FRAGMENT_TAG = "SingleFragment";
    private Fragment singleFragment;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.com_facebook_activity_layout);
        Intent intent = this.getIntent();
        if (PASS_THROUGH_CANCEL_ACTION.equals(intent.getAction())) {
            this.handlePassThroughError();
            return;
        }
        FragmentManager manager = this.getSupportFragmentManager();
        Object fragment = manager.findFragmentByTag(FRAGMENT_TAG);
        if (fragment == null) {
            if ("FacebookDialogFragment".equals(intent.getAction())) {
                FacebookDialogFragment dialogFragment = new FacebookDialogFragment();
                dialogFragment.setRetainInstance(true);
                dialogFragment.show(manager, FRAGMENT_TAG);
                fragment = dialogFragment;
            } else {
                fragment = new LoginFragment();
                fragment.setRetainInstance(true);
                manager.beginTransaction().add(R.id.com_facebook_fragment_container, fragment, FRAGMENT_TAG).commit();
            }
        }
        this.singleFragment = fragment;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.singleFragment != null) {
            this.singleFragment.onConfigurationChanged(newConfig);
        }
    }

    private void handlePassThroughError() {
        Intent requestIntent = this.getIntent();
        Bundle errorResults = NativeProtocol.getMethodArgumentsFromIntent(requestIntent);
        FacebookException exception = NativeProtocol.getExceptionFromErrorData(errorResults);
        Intent resultIntent = NativeProtocol.createProtocolResultIntent(requestIntent, null, exception);
        this.setResult(0, resultIntent);
        this.finish();
    }

    public Fragment getCurrentFragment() {
        return this.singleFragment;
    }
}

