/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.share.internal;

import android.os.Parcel;
import com.facebook.share.model.ShareModel;
import com.facebook.share.model.ShareModelBuilder;
import com.facebook.share.widget.LikeView;

public class LikeContent
implements ShareModel {
    private final String objectId;
    private final LikeView.ObjectType objectType;

    private LikeContent(Builder builder) {
        this.objectId = builder.objectId;
        this.objectType = builder.objectType;
    }

    LikeContent(Parcel in) {
        this.objectId = in.readString();
        this.objectType = LikeView.ObjectType.fromInt(in.readInt());
    }

    public String getObjectId() {
        return this.objectId;
    }

    public LikeView.ObjectType getObjectType() {
        return this.objectType;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.objectId);
        out.writeInt(this.objectType.getValue());
    }

    public static class Builder
    implements ShareModelBuilder<LikeContent, Builder> {
        private String objectId;
        private LikeView.ObjectType objectType = LikeView.ObjectType.UNKNOWN;

        public Builder setObjectId(String objectId) {
            this.objectId = objectId;
            return this;
        }

        public Builder setObjectType(LikeView.ObjectType objectType) {
            this.objectType = objectType == null ? LikeView.ObjectType.UNKNOWN : objectType;
            return this;
        }

        @Override
        public LikeContent build() {
            return new LikeContent(this);
        }

        @Override
        public Builder readFrom(LikeContent content) {
            if (content == null) {
                return this;
            }
            return this.setObjectId(content.getObjectId()).setObjectType(content.getObjectType());
        }

        @Override
        public Builder readFrom(Parcel parcel) {
            return this.readFrom((LikeContent)parcel.readParcelable(LikeContent.class.getClassLoader()));
        }
    }
}

