/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.content.LocalBroadcastManager;
import com.facebook.AccessToken;
import com.facebook.AccessTokenCache;
import com.facebook.FacebookSdk;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import java.util.Date;

final class AccessTokenManager {
    static final String ACTION_CURRENT_ACCESS_TOKEN_CHANGED = "com.facebook.sdk.ACTION_CURRENT_ACCESS_TOKEN_CHANGED";
    static final String EXTRA_OLD_ACCESS_TOKEN = "com.facebook.sdk.EXTRA_OLD_ACCESS_TOKEN";
    static final String EXTRA_NEW_ACCESS_TOKEN = "com.facebook.sdk.EXTRA_NEW_ACCESS_TOKEN";
    static final String SHARED_PREFERENCES_NAME = "com.facebook.AccessTokenManager.SharedPreferences";
    private static final int TOKEN_EXTEND_THRESHOLD_SECONDS = 86400;
    private static final int TOKEN_EXTEND_RETRY_SECONDS = 3600;
    private static volatile AccessTokenManager instance;
    private final LocalBroadcastManager localBroadcastManager;
    private final AccessTokenCache accessTokenCache;
    private AccessToken currentAccessToken;
    private TokenRefreshRequest currentTokenRefreshRequest;
    private Date lastAttemptedTokenExtendDate = new Date(0L);

    AccessTokenManager(LocalBroadcastManager localBroadcastManager, AccessTokenCache accessTokenCache) {
        Validate.notNull(localBroadcastManager, "localBroadcastManager");
        Validate.notNull(accessTokenCache, "accessTokenCache");
        this.localBroadcastManager = localBroadcastManager;
        this.accessTokenCache = accessTokenCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static AccessTokenManager getInstance() {
        if (instance != null) return instance;
        Class<AccessTokenManager> clazz = AccessTokenManager.class;
        synchronized (AccessTokenManager.class) {
            if (instance != null) return instance;
            Context applicationContext = FacebookSdk.getApplicationContext();
            LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)applicationContext);
            AccessTokenCache accessTokenCache = new AccessTokenCache();
            instance = new AccessTokenManager(localBroadcastManager, accessTokenCache);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    AccessToken getCurrentAccessToken() {
        return this.currentAccessToken;
    }

    boolean loadCurrentAccessToken() {
        AccessToken accessToken = this.accessTokenCache.load();
        if (accessToken != null) {
            this.setCurrentAccessToken(accessToken, false);
            return true;
        }
        return false;
    }

    void setCurrentAccessToken(AccessToken currentAccessToken) {
        this.setCurrentAccessToken(currentAccessToken, true);
    }

    private void setCurrentAccessToken(AccessToken currentAccessToken, boolean saveToCache) {
        AccessToken oldAccessToken = this.currentAccessToken;
        this.currentAccessToken = currentAccessToken;
        this.currentTokenRefreshRequest = null;
        this.lastAttemptedTokenExtendDate = new Date(0L);
        if (saveToCache) {
            if (currentAccessToken != null) {
                this.accessTokenCache.save(currentAccessToken);
            } else {
                this.accessTokenCache.clear();
            }
        }
        if (!Utility.areObjectsEqual(oldAccessToken, currentAccessToken)) {
            this.sendCurrentAccessTokenChangedBroadcast(oldAccessToken, currentAccessToken);
        }
    }

    private void sendCurrentAccessTokenChangedBroadcast(AccessToken oldAccessToken, AccessToken currentAccessToken) {
        Intent intent = new Intent(ACTION_CURRENT_ACCESS_TOKEN_CHANGED);
        intent.putExtra(EXTRA_OLD_ACCESS_TOKEN, (Parcelable)oldAccessToken);
        intent.putExtra(EXTRA_NEW_ACCESS_TOKEN, (Parcelable)currentAccessToken);
        this.localBroadcastManager.sendBroadcast(intent);
    }

    void extendAccessTokenIfNeeded() {
        if (!this.shouldExtendAccessToken()) {
            return;
        }
        this.currentTokenRefreshRequest = new TokenRefreshRequest(this.currentAccessToken);
        this.currentTokenRefreshRequest.bind();
    }

    private boolean shouldExtendAccessToken() {
        if (this.currentAccessToken == null || this.currentTokenRefreshRequest != null) {
            return false;
        }
        Long now = new Date().getTime();
        return this.currentAccessToken.getSource().canExtendToken() && now - this.lastAttemptedTokenExtendDate.getTime() > 3600000L && now - this.currentAccessToken.getLastRefresh().getTime() > 86400000L;
    }

    static class TokenRefreshRequestHandler
    extends Handler {
        private AccessToken accessToken;
        private TokenRefreshRequest tokenRefreshRequest;

        TokenRefreshRequestHandler(AccessToken accessToken, TokenRefreshRequest tokenRefreshRequest) {
            super(Looper.getMainLooper());
            this.accessToken = accessToken;
            this.tokenRefreshRequest = tokenRefreshRequest;
        }

        public void handleMessage(Message msg) {
            AccessToken currentAccessToken = AccessToken.getCurrentAccessToken();
            if (currentAccessToken != null && currentAccessToken.equals(this.accessToken) && msg.getData().getString("access_token") != null) {
                AccessToken newToken = AccessToken.createFromRefresh(this.accessToken, msg.getData());
                AccessToken.setCurrentAccessToken(newToken);
            }
            FacebookSdk.getApplicationContext().unbindService((ServiceConnection)this.tokenRefreshRequest);
            this.tokenRefreshRequest.cleanup();
        }
    }

    class TokenRefreshRequest
    implements ServiceConnection {
        final Messenger messageReceiver;
        Messenger messageSender = null;

        TokenRefreshRequest(AccessToken accessToken) {
            this.messageReceiver = new Messenger((Handler)new TokenRefreshRequestHandler(accessToken, this));
        }

        public void bind() {
            Context context = FacebookSdk.getApplicationContext();
            Intent intent = NativeProtocol.createTokenRefreshIntent(context);
            if (intent != null && context.bindService(intent, (ServiceConnection)this, 1)) {
                AccessTokenManager.this.lastAttemptedTokenExtendDate = new Date();
            } else {
                this.cleanup();
            }
        }

        public void onServiceConnected(ComponentName className, IBinder service) {
            this.messageSender = new Messenger(service);
            this.refreshToken();
        }

        public void onServiceDisconnected(ComponentName arg) {
            this.cleanup();
            try {
                FacebookSdk.getApplicationContext().unbindService((ServiceConnection)this);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        private void cleanup() {
            if (AccessTokenManager.this.currentTokenRefreshRequest == this) {
                AccessTokenManager.this.currentTokenRefreshRequest = null;
            }
        }

        private void refreshToken() {
            Bundle requestData = new Bundle();
            requestData.putString("access_token", AccessTokenManager.this.getCurrentAccessToken().getToken());
            Message request = Message.obtain();
            request.setData(requestData);
            request.replyTo = this.messageReceiver;
            try {
                this.messageSender.send(request);
            }
            catch (RemoteException e) {
                this.cleanup();
            }
        }
    }
}

