/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.os.Bundle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BundleJSONConverter {
    private static final Map<Class<?>, Setter> SETTERS = new HashMap();

    public static JSONObject convertToJSON(Bundle bundle) throws JSONException {
        JSONObject json = new JSONObject();
        for (String key : bundle.keySet()) {
            Object value = bundle.get(key);
            if (value == null) continue;
            if (value instanceof List) {
                JSONArray jsonArray = new JSONArray();
                List listValue = (List)value;
                for (String stringValue : listValue) {
                    jsonArray.put((Object)stringValue);
                }
                json.put(key, (Object)jsonArray);
                continue;
            }
            if (value instanceof Bundle) {
                json.put(key, (Object)BundleJSONConverter.convertToJSON((Bundle)value));
                continue;
            }
            Setter setter = SETTERS.get(value.getClass());
            if (setter == null) {
                throw new IllegalArgumentException("Unsupported type: " + value.getClass());
            }
            setter.setOnJSON(json, key, value);
        }
        return json;
    }

    public static Bundle convertToBundle(JSONObject jsonObject) throws JSONException {
        Bundle bundle = new Bundle();
        Iterator jsonIterator = jsonObject.keys();
        while (jsonIterator.hasNext()) {
            String key = (String)jsonIterator.next();
            Object value = jsonObject.get(key);
            if (value == null || value == JSONObject.NULL) continue;
            if (value instanceof JSONObject) {
                bundle.putBundle(key, BundleJSONConverter.convertToBundle((JSONObject)value));
                continue;
            }
            Setter setter = SETTERS.get(value.getClass());
            if (setter == null) {
                throw new IllegalArgumentException("Unsupported type: " + value.getClass());
            }
            setter.setOnBundle(bundle, key, value);
        }
        return bundle;
    }

    static {
        SETTERS.put(Boolean.class, new Setter(){

            @Override
            public void setOnBundle(Bundle bundle, String key, Object value) throws JSONException {
                bundle.putBoolean(key, ((Boolean)value).booleanValue());
            }

            @Override
            public void setOnJSON(JSONObject json, String key, Object value) throws JSONException {
                json.put(key, value);
            }
        });
        SETTERS.put(Integer.class, new Setter(){

            @Override
            public void setOnBundle(Bundle bundle, String key, Object value) throws JSONException {
                bundle.putInt(key, ((Integer)value).intValue());
            }

            @Override
            public void setOnJSON(JSONObject json, String key, Object value) throws JSONException {
                json.put(key, value);
            }
        });
        SETTERS.put(Long.class, new Setter(){

            @Override
            public void setOnBundle(Bundle bundle, String key, Object value) throws JSONException {
                bundle.putLong(key, ((Long)value).longValue());
            }

            @Override
            public void setOnJSON(JSONObject json, String key, Object value) throws JSONException {
                json.put(key, value);
            }
        });
        SETTERS.put(Double.class, new Setter(){

            @Override
            public void setOnBundle(Bundle bundle, String key, Object value) throws JSONException {
                bundle.putDouble(key, ((Double)value).doubleValue());
            }

            @Override
            public void setOnJSON(JSONObject json, String key, Object value) throws JSONException {
                json.put(key, value);
            }
        });
        SETTERS.put(String.class, new Setter(){

            @Override
            public void setOnBundle(Bundle bundle, String key, Object value) throws JSONException {
                bundle.putString(key, (String)value);
            }

            @Override
            public void setOnJSON(JSONObject json, String key, Object value) throws JSONException {
                json.put(key, value);
            }
        });
        SETTERS.put(String[].class, new Setter(){

            @Override
            public void setOnBundle(Bundle bundle, String key, Object value) throws JSONException {
                throw new IllegalArgumentException("Unexpected type from JSON");
            }

            @Override
            public void setOnJSON(JSONObject json, String key, Object value) throws JSONException {
                JSONArray jsonArray = new JSONArray();
                for (String stringValue : (String[])value) {
                    jsonArray.put((Object)stringValue);
                }
                json.put(key, (Object)jsonArray);
            }
        });
        SETTERS.put(JSONArray.class, new Setter(){

            @Override
            public void setOnBundle(Bundle bundle, String key, Object value) throws JSONException {
                JSONArray jsonArray = (JSONArray)value;
                ArrayList<String> stringArrayList = new ArrayList<String>();
                if (jsonArray.length() == 0) {
                    bundle.putStringArrayList(key, stringArrayList);
                    return;
                }
                for (int i = 0; i < jsonArray.length(); ++i) {
                    Object current = jsonArray.get(i);
                    if (!(current instanceof String)) {
                        throw new IllegalArgumentException("Unexpected type in an array: " + current.getClass());
                    }
                    stringArrayList.add((String)current);
                }
                bundle.putStringArrayList(key, stringArrayList);
            }

            @Override
            public void setOnJSON(JSONObject json, String key, Object value) throws JSONException {
                throw new IllegalArgumentException("JSONArray's are not supported in bundles.");
            }
        });
    }

    public static interface Setter {
        public void setOnBundle(Bundle var1, String var2, Object var3) throws JSONException;

        public void setOnJSON(JSONObject var1, String var2, Object var3) throws JSONException;
    }
}

