/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.Context;
import android.graphics.Bitmap;
import android.location.Location;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.facebook.FacebookException;
import com.facebook.HttpMethod;
import com.facebook.LoggingBehavior;
import com.facebook.ProgressNoopOutputStream;
import com.facebook.ProgressOutputStream;
import com.facebook.RequestAsyncTask;
import com.facebook.RequestBatch;
import com.facebook.RequestOutputStream;
import com.facebook.RequestProgress;
import com.facebook.Response;
import com.facebook.Session;
import com.facebook.Settings;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.Logger;
import com.facebook.internal.ServerProtocol;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.model.GraphMultiResult;
import com.facebook.model.GraphObject;
import com.facebook.model.GraphObjectList;
import com.facebook.model.GraphPlace;
import com.facebook.model.GraphUser;
import com.facebook.model.OpenGraphAction;
import com.facebook.model.OpenGraphObject;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Request {
    public static final int MAXIMUM_BATCH_SIZE = 50;
    public static final String TAG = Request.class.getSimpleName();
    private static final String ME = "me";
    private static final String MY_FRIENDS = "me/friends";
    private static final String MY_PHOTOS = "me/photos";
    private static final String MY_VIDEOS = "me/videos";
    private static final String VIDEOS_SUFFIX = "/videos";
    private static final String SEARCH = "search";
    private static final String MY_FEED = "me/feed";
    private static final String MY_STAGING_RESOURCES = "me/staging_resources";
    private static final String MY_OBJECTS_FORMAT = "me/objects/%s";
    private static final String MY_ACTION_FORMAT = "me/%s";
    private static final String USER_AGENT_BASE = "FBAndroidSDK";
    private static final String USER_AGENT_HEADER = "User-Agent";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String ACCEPT_LANGUAGE_HEADER = "Accept-Language";
    private static final String CONTENT_ENCODING_HEADER = "Content-Encoding";
    private static final String PICTURE_PARAM = "picture";
    private static final String FORMAT_PARAM = "format";
    private static final String FORMAT_JSON = "json";
    private static final String SDK_PARAM = "sdk";
    private static final String SDK_ANDROID = "android";
    private static final String ACCESS_TOKEN_PARAM = "access_token";
    private static final String BATCH_ENTRY_NAME_PARAM = "name";
    private static final String BATCH_ENTRY_OMIT_RESPONSE_ON_SUCCESS_PARAM = "omit_response_on_success";
    private static final String BATCH_ENTRY_DEPENDS_ON_PARAM = "depends_on";
    private static final String BATCH_APP_ID_PARAM = "batch_app_id";
    private static final String BATCH_RELATIVE_URL_PARAM = "relative_url";
    private static final String BATCH_BODY_PARAM = "body";
    private static final String BATCH_METHOD_PARAM = "method";
    private static final String BATCH_PARAM = "batch";
    private static final String ATTACHMENT_FILENAME_PREFIX = "file";
    private static final String ATTACHED_FILES_PARAM = "attached_files";
    private static final String ISO_8601_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final String STAGING_PARAM = "file";
    private static final String OBJECT_PARAM = "object";
    private static final String MIME_BOUNDARY = "3i2ndDfv2rTHiSisAbouNdArYfORhtTPEefj3q2f";
    private static String defaultBatchApplicationId;
    private static Pattern versionPattern;
    private Session session;
    private HttpMethod httpMethod;
    private String graphPath;
    private GraphObject graphObject;
    private String batchEntryName;
    private String batchEntryDependsOn;
    private boolean batchEntryOmitResultOnSuccess = true;
    private Bundle parameters;
    private Callback callback;
    private String overriddenURL;
    private Object tag;
    private String version;
    private boolean skipClientToken = false;
    private static volatile String userAgent;

    public Request() {
        this(null, null, null, null, null);
    }

    public Request(Session session, String graphPath) {
        this(session, graphPath, null, null, null);
    }

    public Request(Session session, String graphPath, Bundle parameters, HttpMethod httpMethod) {
        this(session, graphPath, parameters, httpMethod, null);
    }

    public Request(Session session, String graphPath, Bundle parameters, HttpMethod httpMethod, Callback callback) {
        this(session, graphPath, parameters, httpMethod, callback, null);
    }

    public Request(Session session, String graphPath, Bundle parameters, HttpMethod httpMethod, Callback callback, String version) {
        this.session = session;
        this.graphPath = graphPath;
        this.callback = callback;
        this.version = version;
        this.setHttpMethod(httpMethod);
        this.parameters = parameters != null ? new Bundle(parameters) : new Bundle();
        if (this.version == null) {
            this.version = ServerProtocol.getAPIVersion();
        }
    }

    Request(Session session, URL overriddenURL) {
        this.session = session;
        this.overriddenURL = overriddenURL.toString();
        this.setHttpMethod(HttpMethod.GET);
        this.parameters = new Bundle();
    }

    public static Request newPostRequest(Session session, String graphPath, GraphObject graphObject, Callback callback) {
        Request request = new Request(session, graphPath, null, HttpMethod.POST, callback);
        request.setGraphObject(graphObject);
        return request;
    }

    public static Request newMeRequest(Session session, final GraphUserCallback callback) {
        Callback wrapper = new Callback(){

            @Override
            public void onCompleted(Response response) {
                if (callback != null) {
                    callback.onCompleted(response.getGraphObjectAs(GraphUser.class), response);
                }
            }
        };
        return new Request(session, ME, null, null, wrapper);
    }

    public static Request newMyFriendsRequest(Session session, final GraphUserListCallback callback) {
        Callback wrapper = new Callback(){

            @Override
            public void onCompleted(Response response) {
                if (callback != null) {
                    callback.onCompleted(Request.typedListFromResponse(response, GraphUser.class), response);
                }
            }
        };
        return new Request(session, MY_FRIENDS, null, null, wrapper);
    }

    public static Request newUploadPhotoRequest(Session session, Bitmap image, Callback callback) {
        Bundle parameters = new Bundle(1);
        parameters.putParcelable(PICTURE_PARAM, (Parcelable)image);
        return new Request(session, MY_PHOTOS, parameters, HttpMethod.POST, callback);
    }

    public static Request newUploadPhotoRequest(Session session, File file, Callback callback) throws FileNotFoundException {
        ParcelFileDescriptor descriptor = ParcelFileDescriptor.open((File)file, (int)0x10000000);
        Bundle parameters = new Bundle(1);
        parameters.putParcelable(PICTURE_PARAM, (Parcelable)descriptor);
        return new Request(session, MY_PHOTOS, parameters, HttpMethod.POST, callback);
    }

    public static Request newUploadVideoRequest(Session session, File file, Callback callback) throws FileNotFoundException {
        ParcelFileDescriptor descriptor = ParcelFileDescriptor.open((File)file, (int)0x10000000);
        Bundle parameters = new Bundle(1);
        parameters.putParcelable(file.getName(), (Parcelable)descriptor);
        return new Request(session, MY_VIDEOS, parameters, HttpMethod.POST, callback);
    }

    public static Request newGraphPathRequest(Session session, String graphPath, Callback callback) {
        return new Request(session, graphPath, null, null, callback);
    }

    public static Request newPlacesSearchRequest(Session session, Location location, int radiusInMeters, int resultsLimit, String searchText, final GraphPlaceListCallback callback) {
        if (location == null && Utility.isNullOrEmpty(searchText)) {
            throw new FacebookException("Either location or searchText must be specified.");
        }
        Bundle parameters = new Bundle(5);
        parameters.putString("type", "place");
        parameters.putInt("limit", resultsLimit);
        if (location != null) {
            parameters.putString("center", String.format(Locale.US, "%f,%f", location.getLatitude(), location.getLongitude()));
            parameters.putInt("distance", radiusInMeters);
        }
        if (!Utility.isNullOrEmpty(searchText)) {
            parameters.putString("q", searchText);
        }
        Callback wrapper = new Callback(){

            @Override
            public void onCompleted(Response response) {
                if (callback != null) {
                    callback.onCompleted(Request.typedListFromResponse(response, GraphPlace.class), response);
                }
            }
        };
        return new Request(session, SEARCH, parameters, HttpMethod.GET, wrapper);
    }

    public static Request newStatusUpdateRequest(Session session, String message, Callback callback) {
        return Request.newStatusUpdateRequest(session, message, (String)null, null, callback);
    }

    private static Request newStatusUpdateRequest(Session session, String message, String placeId, List<String> tagIds, Callback callback) {
        Bundle parameters = new Bundle();
        parameters.putString("message", message);
        if (placeId != null) {
            parameters.putString("place", placeId);
        }
        if (tagIds != null && tagIds.size() > 0) {
            String tags = TextUtils.join((CharSequence)",", tagIds);
            parameters.putString("tags", tags);
        }
        return new Request(session, MY_FEED, parameters, HttpMethod.POST, callback);
    }

    public static Request newStatusUpdateRequest(Session session, String message, GraphPlace place, List<GraphUser> tags, Callback callback) {
        ArrayList<String> tagIds = null;
        if (tags != null) {
            tagIds = new ArrayList<String>(tags.size());
            for (GraphUser tag : tags) {
                tagIds.add(tag.getId());
            }
        }
        String placeId = place == null ? null : place.getId();
        return Request.newStatusUpdateRequest(session, message, placeId, tagIds, callback);
    }

    public static Request newCustomAudienceThirdPartyIdRequest(Session session, Context context, Callback callback) {
        return Request.newCustomAudienceThirdPartyIdRequest(session, context, null, callback);
    }

    public static Request newCustomAudienceThirdPartyIdRequest(Session session, Context context, String applicationId, Callback callback) {
        if (session == null) {
            session = Session.getActiveSession();
        }
        if (session != null && !session.isOpened()) {
            session = null;
        }
        if (applicationId == null) {
            applicationId = session != null ? session.getApplicationId() : Utility.getMetadataApplicationId(context);
        }
        if (applicationId == null) {
            throw new FacebookException("Facebook App ID cannot be determined");
        }
        String endpoint = applicationId + "/custom_audience_third_party_id";
        AttributionIdentifiers attributionIdentifiers = AttributionIdentifiers.getAttributionIdentifiers(context);
        Bundle parameters = new Bundle();
        if (session == null) {
            String udid;
            String string2 = udid = attributionIdentifiers.getAttributionId() != null ? attributionIdentifiers.getAttributionId() : attributionIdentifiers.getAndroidAdvertiserId();
            if (attributionIdentifiers.getAttributionId() != null) {
                parameters.putString("udid", udid);
            }
        }
        if (Settings.getLimitEventAndDataUsage(context) || attributionIdentifiers.isTrackingLimited()) {
            parameters.putString("limit_event_usage", "1");
        }
        return new Request(session, endpoint, parameters, HttpMethod.GET, callback);
    }

    public static Request newUploadStagingResourceWithImageRequest(Session session, Bitmap image, Callback callback) {
        Bundle parameters = new Bundle(1);
        parameters.putParcelable("file", (Parcelable)image);
        return new Request(session, MY_STAGING_RESOURCES, parameters, HttpMethod.POST, callback);
    }

    public static Request newUploadStagingResourceWithImageRequest(Session session, File file, Callback callback) throws FileNotFoundException {
        ParcelFileDescriptor descriptor = ParcelFileDescriptor.open((File)file, (int)0x10000000);
        ParcelFileDescriptorWithMimeType descriptorWithMimeType = new ParcelFileDescriptorWithMimeType(descriptor, "image/png");
        Bundle parameters = new Bundle(1);
        parameters.putParcelable("file", (Parcelable)descriptorWithMimeType);
        return new Request(session, MY_STAGING_RESOURCES, parameters, HttpMethod.POST, callback);
    }

    public static Request newPostOpenGraphObjectRequest(Session session, OpenGraphObject openGraphObject, Callback callback) {
        if (openGraphObject == null) {
            throw new FacebookException("openGraphObject cannot be null");
        }
        if (Utility.isNullOrEmpty(openGraphObject.getType())) {
            throw new FacebookException("openGraphObject must have non-null 'type' property");
        }
        if (Utility.isNullOrEmpty(openGraphObject.getTitle())) {
            throw new FacebookException("openGraphObject must have non-null 'title' property");
        }
        String path = String.format(MY_OBJECTS_FORMAT, openGraphObject.getType());
        Bundle bundle = new Bundle();
        bundle.putString(OBJECT_PARAM, openGraphObject.getInnerJSONObject().toString());
        return new Request(session, path, bundle, HttpMethod.POST, callback);
    }

    public static Request newPostOpenGraphObjectRequest(Session session, String type, String title, String imageUrl, String url, String description, GraphObject objectProperties, Callback callback) {
        OpenGraphObject openGraphObject = OpenGraphObject.Factory.createForPost(OpenGraphObject.class, type, title, imageUrl, url, description);
        if (objectProperties != null) {
            openGraphObject.setData(objectProperties);
        }
        return Request.newPostOpenGraphObjectRequest(session, openGraphObject, callback);
    }

    public static Request newPostOpenGraphActionRequest(Session session, OpenGraphAction openGraphAction, Callback callback) {
        if (openGraphAction == null) {
            throw new FacebookException("openGraphAction cannot be null");
        }
        if (Utility.isNullOrEmpty(openGraphAction.getType())) {
            throw new FacebookException("openGraphAction must have non-null 'type' property");
        }
        String path = String.format(MY_ACTION_FORMAT, openGraphAction.getType());
        return Request.newPostRequest(session, path, openGraphAction, callback);
    }

    public static Request newDeleteObjectRequest(Session session, String id2, Callback callback) {
        return new Request(session, id2, null, HttpMethod.DELETE, callback);
    }

    public static Request newUpdateOpenGraphObjectRequest(Session session, OpenGraphObject openGraphObject, Callback callback) {
        if (openGraphObject == null) {
            throw new FacebookException("openGraphObject cannot be null");
        }
        String path = openGraphObject.getId();
        if (path == null) {
            throw new FacebookException("openGraphObject must have an id");
        }
        Bundle bundle = new Bundle();
        bundle.putString(OBJECT_PARAM, openGraphObject.getInnerJSONObject().toString());
        return new Request(session, path, bundle, HttpMethod.POST, callback);
    }

    public static Request newUpdateOpenGraphObjectRequest(Session session, String id2, String title, String imageUrl, String url, String description, GraphObject objectProperties, Callback callback) {
        OpenGraphObject openGraphObject = OpenGraphObject.Factory.createForPost(OpenGraphObject.class, null, title, imageUrl, url, description);
        openGraphObject.setId(id2);
        openGraphObject.setData(objectProperties);
        return Request.newUpdateOpenGraphObjectRequest(session, openGraphObject, callback);
    }

    public final GraphObject getGraphObject() {
        return this.graphObject;
    }

    public final void setGraphObject(GraphObject graphObject) {
        this.graphObject = graphObject;
    }

    public final String getGraphPath() {
        return this.graphPath;
    }

    public final void setGraphPath(String graphPath) {
        this.graphPath = graphPath;
    }

    public final HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public final void setHttpMethod(HttpMethod httpMethod) {
        if (this.overriddenURL != null && httpMethod != HttpMethod.GET) {
            throw new FacebookException("Can't change HTTP method on request with overridden URL.");
        }
        this.httpMethod = httpMethod != null ? httpMethod : HttpMethod.GET;
    }

    public final String getVersion() {
        return this.version;
    }

    public final void setVersion(String version) {
        this.version = version;
    }

    public final void setSkipClientToken(boolean skipClientToken) {
        this.skipClientToken = skipClientToken;
    }

    public final Bundle getParameters() {
        return this.parameters;
    }

    public final void setParameters(Bundle parameters) {
        this.parameters = parameters;
    }

    public final Session getSession() {
        return this.session;
    }

    public final void setSession(Session session) {
        this.session = session;
    }

    public final String getBatchEntryName() {
        return this.batchEntryName;
    }

    public final void setBatchEntryName(String batchEntryName) {
        this.batchEntryName = batchEntryName;
    }

    public final String getBatchEntryDependsOn() {
        return this.batchEntryDependsOn;
    }

    public final void setBatchEntryDependsOn(String batchEntryDependsOn) {
        this.batchEntryDependsOn = batchEntryDependsOn;
    }

    public final boolean getBatchEntryOmitResultOnSuccess() {
        return this.batchEntryOmitResultOnSuccess;
    }

    public final void setBatchEntryOmitResultOnSuccess(boolean batchEntryOmitResultOnSuccess) {
        this.batchEntryOmitResultOnSuccess = batchEntryOmitResultOnSuccess;
    }

    public static final String getDefaultBatchApplicationId() {
        return defaultBatchApplicationId;
    }

    public static final void setDefaultBatchApplicationId(String applicationId) {
        defaultBatchApplicationId = applicationId;
    }

    public final Callback getCallback() {
        return this.callback;
    }

    public final void setCallback(Callback callback) {
        this.callback = callback;
    }

    public final void setTag(Object tag) {
        this.tag = tag;
    }

    public final Object getTag() {
        return this.tag;
    }

    @Deprecated
    public static RequestAsyncTask executePostRequestAsync(Session session, String graphPath, GraphObject graphObject, Callback callback) {
        return Request.newPostRequest(session, graphPath, graphObject, callback).executeAsync();
    }

    @Deprecated
    public static RequestAsyncTask executeMeRequestAsync(Session session, GraphUserCallback callback) {
        return Request.newMeRequest(session, callback).executeAsync();
    }

    @Deprecated
    public static RequestAsyncTask executeMyFriendsRequestAsync(Session session, GraphUserListCallback callback) {
        return Request.newMyFriendsRequest(session, callback).executeAsync();
    }

    @Deprecated
    public static RequestAsyncTask executeUploadPhotoRequestAsync(Session session, Bitmap image, Callback callback) {
        return Request.newUploadPhotoRequest(session, image, callback).executeAsync();
    }

    @Deprecated
    public static RequestAsyncTask executeUploadPhotoRequestAsync(Session session, File file, Callback callback) throws FileNotFoundException {
        return Request.newUploadPhotoRequest(session, file, callback).executeAsync();
    }

    @Deprecated
    public static RequestAsyncTask executeGraphPathRequestAsync(Session session, String graphPath, Callback callback) {
        return Request.newGraphPathRequest(session, graphPath, callback).executeAsync();
    }

    @Deprecated
    public static RequestAsyncTask executePlacesSearchRequestAsync(Session session, Location location, int radiusInMeters, int resultsLimit, String searchText, GraphPlaceListCallback callback) {
        return Request.newPlacesSearchRequest(session, location, radiusInMeters, resultsLimit, searchText, callback).executeAsync();
    }

    @Deprecated
    public static RequestAsyncTask executeStatusUpdateRequestAsync(Session session, String message, Callback callback) {
        return Request.newStatusUpdateRequest(session, message, callback).executeAsync();
    }

    public final Response executeAndWait() {
        return Request.executeAndWait(this);
    }

    public final RequestAsyncTask executeAsync() {
        return Request.executeBatchAsync(this);
    }

    public static HttpURLConnection toHttpConnection(Request ... requests) {
        return Request.toHttpConnection(Arrays.asList(requests));
    }

    public static HttpURLConnection toHttpConnection(Collection<Request> requests) {
        Validate.notEmptyAndContainsNoNulls(requests, "requests");
        return Request.toHttpConnection(new RequestBatch(requests));
    }

    public static HttpURLConnection toHttpConnection(RequestBatch requests) {
        HttpURLConnection connection;
        URL url = null;
        try {
            if (requests.size() == 1) {
                Request request = requests.get(0);
                url = new URL(request.getUrlForSingleRequest());
            } else {
                url = new URL(ServerProtocol.getGraphUrlBase());
            }
        }
        catch (MalformedURLException e) {
            throw new FacebookException("could not construct URL for request", e);
        }
        try {
            connection = Request.createConnection(url);
            Request.serializeToUrlConnection(requests, connection);
        }
        catch (IOException e) {
            throw new FacebookException("could not construct request body", e);
        }
        catch (JSONException e) {
            throw new FacebookException("could not construct request body", e);
        }
        return connection;
    }

    public static Response executeAndWait(Request request) {
        List<Response> responses = Request.executeBatchAndWait(request);
        if (responses == null || responses.size() != 1) {
            throw new FacebookException("invalid state: expected a single response");
        }
        return responses.get(0);
    }

    public static List<Response> executeBatchAndWait(Request ... requests) {
        Validate.notNull(requests, "requests");
        return Request.executeBatchAndWait(Arrays.asList(requests));
    }

    public static List<Response> executeBatchAndWait(Collection<Request> requests) {
        return Request.executeBatchAndWait(new RequestBatch(requests));
    }

    public static List<Response> executeBatchAndWait(RequestBatch requests) {
        Validate.notEmptyAndContainsNoNulls(requests, "requests");
        HttpURLConnection connection = null;
        try {
            connection = Request.toHttpConnection(requests);
        }
        catch (Exception ex) {
            List<Response> responses = Response.constructErrorResponses(requests.getRequests(), null, new FacebookException(ex));
            Request.runCallbacks(requests, responses);
            return responses;
        }
        List<Response> responses = Request.executeConnectionAndWait(connection, requests);
        return responses;
    }

    public static RequestAsyncTask executeBatchAsync(Request ... requests) {
        Validate.notNull(requests, "requests");
        return Request.executeBatchAsync(Arrays.asList(requests));
    }

    public static RequestAsyncTask executeBatchAsync(Collection<Request> requests) {
        return Request.executeBatchAsync(new RequestBatch(requests));
    }

    public static RequestAsyncTask executeBatchAsync(RequestBatch requests) {
        Validate.notEmptyAndContainsNoNulls(requests, "requests");
        RequestAsyncTask asyncTask = new RequestAsyncTask(requests);
        asyncTask.executeOnSettingsExecutor();
        return asyncTask;
    }

    public static List<Response> executeConnectionAndWait(HttpURLConnection connection, Collection<Request> requests) {
        return Request.executeConnectionAndWait(connection, new RequestBatch(requests));
    }

    public static List<Response> executeConnectionAndWait(HttpURLConnection connection, RequestBatch requests) {
        List<Response> responses = Response.fromHttpConnection(connection, requests);
        Utility.disconnectQuietly(connection);
        int numRequests = requests.size();
        if (numRequests != responses.size()) {
            throw new FacebookException(String.format("Received %d responses while expecting %d", responses.size(), numRequests));
        }
        Request.runCallbacks(requests, responses);
        HashSet<Session> sessions = new HashSet<Session>();
        for (Request request : requests) {
            if (request.session == null) continue;
            sessions.add(request.session);
        }
        for (Session session : sessions) {
            session.extendAccessTokenIfNeeded();
        }
        return responses;
    }

    public static RequestAsyncTask executeConnectionAsync(HttpURLConnection connection, RequestBatch requests) {
        return Request.executeConnectionAsync(null, connection, requests);
    }

    public static RequestAsyncTask executeConnectionAsync(Handler callbackHandler, HttpURLConnection connection, RequestBatch requests) {
        Validate.notNull(connection, "connection");
        RequestAsyncTask asyncTask = new RequestAsyncTask(connection, requests);
        requests.setCallbackHandler(callbackHandler);
        asyncTask.executeOnSettingsExecutor();
        return asyncTask;
    }

    public String toString() {
        return "{Request: " + " session: " + this.session + ", graphPath: " + this.graphPath + ", graphObject: " + this.graphObject + ", httpMethod: " + (Object)((Object)this.httpMethod) + ", parameters: " + this.parameters + "}";
    }

    static void runCallbacks(final RequestBatch requests, List<Response> responses) {
        int numRequests = requests.size();
        final ArrayList<Pair> callbacks = new ArrayList<Pair>();
        for (int i = 0; i < numRequests; ++i) {
            Request request = requests.get(i);
            if (request.callback == null) continue;
            callbacks.add(new Pair((Object)request.callback, (Object)responses.get(i)));
        }
        if (callbacks.size() > 0) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    for (Pair pair : callbacks) {
                        ((Callback)pair.first).onCompleted((Response)pair.second);
                    }
                    List<RequestBatch.Callback> batchCallbacks = requests.getCallbacks();
                    for (RequestBatch.Callback batchCallback : batchCallbacks) {
                        batchCallback.onBatchCompleted(requests);
                    }
                }
            };
            Handler callbackHandler = requests.getCallbackHandler();
            if (callbackHandler == null) {
                runnable.run();
            } else {
                callbackHandler.post(runnable);
            }
        }
    }

    private static HttpURLConnection createConnection(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty(USER_AGENT_HEADER, Request.getUserAgent());
        connection.setRequestProperty(ACCEPT_LANGUAGE_HEADER, Locale.getDefault().toString());
        connection.setChunkedStreamingMode(0);
        return connection;
    }

    private void addCommonParameters() {
        if (this.session != null) {
            if (!this.session.isOpened()) {
                throw new FacebookException("Session provided to a Request in un-opened state.");
            }
            if (!this.parameters.containsKey(ACCESS_TOKEN_PARAM)) {
                String accessToken = this.session.getAccessToken();
                Logger.registerAccessToken(accessToken);
                this.parameters.putString(ACCESS_TOKEN_PARAM, accessToken);
            }
        } else if (!this.skipClientToken && !this.parameters.containsKey(ACCESS_TOKEN_PARAM)) {
            String appID = Settings.getApplicationId();
            String clientToken = Settings.getClientToken();
            if (!Utility.isNullOrEmpty(appID) && !Utility.isNullOrEmpty(clientToken)) {
                String accessToken = appID + "|" + clientToken;
                this.parameters.putString(ACCESS_TOKEN_PARAM, accessToken);
            } else {
                Log.d((String)TAG, (String)"Warning: Sessionless Request needs token but missing either application ID or client token.");
            }
        }
        this.parameters.putString(SDK_PARAM, SDK_ANDROID);
        this.parameters.putString(FORMAT_PARAM, FORMAT_JSON);
    }

    private String appendParametersToBaseUrl(String baseUrl) {
        Uri.Builder uriBuilder = new Uri.Builder().encodedPath(baseUrl);
        Set keys = this.parameters.keySet();
        for (String key : keys) {
            Object value = this.parameters.get(key);
            if (value == null) {
                value = "";
            }
            if (!Request.isSupportedParameterType(value)) {
                if (this.httpMethod != HttpMethod.GET) continue;
                throw new IllegalArgumentException(String.format("Unsupported parameter type for GET request: %s", value.getClass().getSimpleName()));
            }
            value = Request.parameterToString(value);
            uriBuilder.appendQueryParameter(key, value.toString());
        }
        return uriBuilder.toString();
    }

    final String getUrlForBatchedRequest() {
        if (this.overriddenURL != null) {
            throw new FacebookException("Can't override URL for a batch request");
        }
        String baseUrl = this.getGraphPathWithVersion();
        this.addCommonParameters();
        return this.appendParametersToBaseUrl(baseUrl);
    }

    final String getUrlForSingleRequest() {
        if (this.overriddenURL != null) {
            return this.overriddenURL.toString();
        }
        String graphBaseUrlBase = this.getHttpMethod() == HttpMethod.POST && this.graphPath != null && this.graphPath.endsWith(VIDEOS_SUFFIX) ? ServerProtocol.getGraphVideoUrlBase() : ServerProtocol.getGraphUrlBase();
        String baseUrl = String.format("%s/%s", graphBaseUrlBase, this.getGraphPathWithVersion());
        this.addCommonParameters();
        return this.appendParametersToBaseUrl(baseUrl);
    }

    private String getGraphPathWithVersion() {
        Matcher matcher = versionPattern.matcher(this.graphPath);
        if (matcher.matches()) {
            return this.graphPath;
        }
        return String.format("%s/%s", this.version, this.graphPath);
    }

    private void serializeToBatch(JSONArray batch, Map<String, Attachment> attachments) throws JSONException, IOException {
        JSONObject batchEntry = new JSONObject();
        if (this.batchEntryName != null) {
            batchEntry.put(BATCH_ENTRY_NAME_PARAM, (Object)this.batchEntryName);
            batchEntry.put(BATCH_ENTRY_OMIT_RESPONSE_ON_SUCCESS_PARAM, this.batchEntryOmitResultOnSuccess);
        }
        if (this.batchEntryDependsOn != null) {
            batchEntry.put(BATCH_ENTRY_DEPENDS_ON_PARAM, (Object)this.batchEntryDependsOn);
        }
        String relativeURL = this.getUrlForBatchedRequest();
        batchEntry.put(BATCH_RELATIVE_URL_PARAM, (Object)relativeURL);
        batchEntry.put(BATCH_METHOD_PARAM, (Object)this.httpMethod);
        if (this.session != null) {
            String accessToken = this.session.getAccessToken();
            Logger.registerAccessToken(accessToken);
        }
        ArrayList<String> attachmentNames = new ArrayList<String>();
        Set keys = this.parameters.keySet();
        for (String key : keys) {
            Object value = this.parameters.get(key);
            if (!Request.isSupportedAttachmentType(value)) continue;
            String name = String.format("%s%d", "file", attachments.size());
            attachmentNames.add(name);
            attachments.put(name, new Attachment(this, value));
        }
        if (!attachmentNames.isEmpty()) {
            String attachmentNamesString = TextUtils.join((CharSequence)",", attachmentNames);
            batchEntry.put(ATTACHED_FILES_PARAM, (Object)attachmentNamesString);
        }
        if (this.graphObject != null) {
            final ArrayList keysAndValues = new ArrayList();
            Request.processGraphObject(this.graphObject, relativeURL, new KeyValueSerializer(){

                @Override
                public void writeString(String key, String value) throws IOException {
                    keysAndValues.add(String.format("%s=%s", key, URLEncoder.encode(value, "UTF-8")));
                }
            });
            String bodyValue = TextUtils.join((CharSequence)"&", keysAndValues);
            batchEntry.put(BATCH_BODY_PARAM, (Object)bodyValue);
        }
        batch.put((Object)batchEntry);
    }

    private static boolean hasOnProgressCallbacks(RequestBatch requests) {
        for (RequestBatch.Callback callback : requests.getCallbacks()) {
            if (!(callback instanceof RequestBatch.OnProgressCallback)) continue;
            return true;
        }
        for (Request request : requests) {
            if (!(request.getCallback() instanceof OnProgressCallback)) continue;
            return true;
        }
        return false;
    }

    private static void setConnectionContentType(HttpURLConnection connection, boolean shouldUseGzip) {
        if (shouldUseGzip) {
            connection.setRequestProperty(CONTENT_TYPE_HEADER, "application/x-www-form-urlencoded");
            connection.setRequestProperty(CONTENT_ENCODING_HEADER, "gzip");
        } else {
            connection.setRequestProperty(CONTENT_TYPE_HEADER, Request.getMimeContentType());
        }
    }

    private static boolean isGzipCompressible(RequestBatch requests) {
        for (Request request : requests) {
            for (String key : request.parameters.keySet()) {
                Object value = request.parameters.get(key);
                if (!Request.isSupportedAttachmentType(value)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void serializeToUrlConnection(RequestBatch requests, HttpURLConnection connection) throws IOException, JSONException {
        boolean isPost;
        Logger logger = new Logger(LoggingBehavior.REQUESTS, "Request");
        int numRequests = requests.size();
        boolean shouldUseGzip = Request.isGzipCompressible(requests);
        HttpMethod connectionHttpMethod = numRequests == 1 ? requests.get((int)0).httpMethod : HttpMethod.POST;
        connection.setRequestMethod(connectionHttpMethod.name());
        Request.setConnectionContentType(connection, shouldUseGzip);
        URL url = connection.getURL();
        logger.append("Request:\n");
        logger.appendKeyValue("Id", requests.getId());
        logger.appendKeyValue("URL", url);
        logger.appendKeyValue("Method", connection.getRequestMethod());
        logger.appendKeyValue(USER_AGENT_HEADER, connection.getRequestProperty(USER_AGENT_HEADER));
        logger.appendKeyValue(CONTENT_TYPE_HEADER, connection.getRequestProperty(CONTENT_TYPE_HEADER));
        connection.setConnectTimeout(requests.getTimeout());
        connection.setReadTimeout(requests.getTimeout());
        boolean bl = isPost = connectionHttpMethod == HttpMethod.POST;
        if (!isPost) {
            logger.log();
            return;
        }
        connection.setDoOutput(true);
        try (FilterOutputStream outputStream = null;){
            outputStream = new BufferedOutputStream(connection.getOutputStream());
            if (shouldUseGzip) {
                outputStream = new GZIPOutputStream(outputStream);
            }
            if (Request.hasOnProgressCallbacks(requests)) {
                ProgressNoopOutputStream countingStream = null;
                countingStream = new ProgressNoopOutputStream(requests.getCallbackHandler());
                Request.processRequest(requests, null, numRequests, url, countingStream, shouldUseGzip);
                int max = countingStream.getMaxProgress();
                Map<Request, RequestProgress> progressMap = countingStream.getProgressMap();
                outputStream = new ProgressOutputStream(outputStream, requests, progressMap, max);
            }
            Request.processRequest(requests, logger, numRequests, url, outputStream, shouldUseGzip);
        }
        logger.log();
    }

    private static void processRequest(RequestBatch requests, Logger logger, int numRequests, URL url, OutputStream outputStream, boolean shouldUseGzip) throws IOException, JSONException {
        Serializer serializer = new Serializer(outputStream, logger, shouldUseGzip);
        if (numRequests == 1) {
            Request request = requests.get(0);
            HashMap<String, Attachment> attachments = new HashMap<String, Attachment>();
            for (String key : request.parameters.keySet()) {
                Object value = request.parameters.get(key);
                if (!Request.isSupportedAttachmentType(value)) continue;
                attachments.put(key, new Attachment(request, value));
            }
            if (logger != null) {
                logger.append("  Parameters:\n");
            }
            Request.serializeParameters(request.parameters, serializer, request);
            if (logger != null) {
                logger.append("  Attachments:\n");
            }
            Request.serializeAttachments(attachments, serializer);
            if (request.graphObject != null) {
                Request.processGraphObject(request.graphObject, url.getPath(), serializer);
            }
        } else {
            String batchAppID = Request.getBatchAppId(requests);
            if (Utility.isNullOrEmpty(batchAppID)) {
                throw new FacebookException("At least one request in a batch must have an open Session, or a default app ID must be specified.");
            }
            serializer.writeString(BATCH_APP_ID_PARAM, batchAppID);
            HashMap<String, Attachment> attachments = new HashMap<String, Attachment>();
            Request.serializeRequestsAsJSON(serializer, requests, attachments);
            if (logger != null) {
                logger.append("  Attachments:\n");
            }
            Request.serializeAttachments(attachments, serializer);
        }
    }

    private static boolean isMeRequest(String path) {
        Matcher matcher = versionPattern.matcher(path);
        if (matcher.matches()) {
            path = matcher.group(1);
        }
        return path.startsWith("me/") || path.startsWith("/me/");
    }

    private static void processGraphObject(GraphObject graphObject, String path, KeyValueSerializer serializer) throws IOException {
        boolean isOGAction = false;
        if (Request.isMeRequest(path)) {
            int colonLocation = path.indexOf(":");
            int questionMarkLocation = path.indexOf("?");
            isOGAction = colonLocation > 3 && (questionMarkLocation == -1 || colonLocation < questionMarkLocation);
        }
        Set<Map.Entry<String, Object>> entries = graphObject.asMap().entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            boolean passByValue = isOGAction && entry.getKey().equalsIgnoreCase("image");
            Request.processGraphObjectProperty(entry.getKey(), entry.getValue(), serializer, passByValue);
        }
    }

    private static void processGraphObjectProperty(String key, Object value, KeyValueSerializer serializer, boolean passByValue) throws IOException {
        Class<?> valueClass = value.getClass();
        if (GraphObject.class.isAssignableFrom(valueClass)) {
            value = ((GraphObject)value).getInnerJSONObject();
            valueClass = value.getClass();
        } else if (GraphObjectList.class.isAssignableFrom(valueClass)) {
            value = ((GraphObjectList)value).getInnerJSONArray();
            valueClass = value.getClass();
        }
        if (JSONObject.class.isAssignableFrom(valueClass)) {
            JSONObject jsonObject = (JSONObject)value;
            if (passByValue) {
                Iterator keys = jsonObject.keys();
                while (keys.hasNext()) {
                    String propertyName = (String)keys.next();
                    String subKey = String.format("%s[%s]", key, propertyName);
                    Request.processGraphObjectProperty(subKey, jsonObject.opt(propertyName), serializer, passByValue);
                }
            } else if (jsonObject.has("id")) {
                Request.processGraphObjectProperty(key, jsonObject.optString("id"), serializer, passByValue);
            } else if (jsonObject.has("url")) {
                Request.processGraphObjectProperty(key, jsonObject.optString("url"), serializer, passByValue);
            } else if (jsonObject.has("fbsdk:create_object")) {
                Request.processGraphObjectProperty(key, jsonObject.toString(), serializer, passByValue);
            }
        } else if (JSONArray.class.isAssignableFrom(valueClass)) {
            JSONArray jsonArray = (JSONArray)value;
            int length = jsonArray.length();
            for (int i = 0; i < length; ++i) {
                String subKey = String.format("%s[%d]", key, i);
                Request.processGraphObjectProperty(subKey, jsonArray.opt(i), serializer, passByValue);
            }
        } else if (String.class.isAssignableFrom(valueClass) || Number.class.isAssignableFrom(valueClass) || Boolean.class.isAssignableFrom(valueClass)) {
            serializer.writeString(key, value.toString());
        } else if (Date.class.isAssignableFrom(valueClass)) {
            Date date = (Date)value;
            SimpleDateFormat iso8601DateFormat = new SimpleDateFormat(ISO_8601_FORMAT_STRING, Locale.US);
            serializer.writeString(key, iso8601DateFormat.format(date));
        }
    }

    private static void serializeParameters(Bundle bundle, Serializer serializer, Request request) throws IOException {
        Set keys = bundle.keySet();
        for (String key : keys) {
            Object value = bundle.get(key);
            if (!Request.isSupportedParameterType(value)) continue;
            serializer.writeObject(key, value, request);
        }
    }

    private static void serializeAttachments(Map<String, Attachment> attachments, Serializer serializer) throws IOException {
        Set<String> keys = attachments.keySet();
        for (String key : keys) {
            Attachment attachment = attachments.get(key);
            if (!Request.isSupportedAttachmentType(attachment.getValue())) continue;
            serializer.writeObject(key, attachment.getValue(), attachment.getRequest());
        }
    }

    private static void serializeRequestsAsJSON(Serializer serializer, Collection<Request> requests, Map<String, Attachment> attachments) throws JSONException, IOException {
        JSONArray batch = new JSONArray();
        for (Request request : requests) {
            request.serializeToBatch(batch, attachments);
        }
        serializer.writeRequestsAsJson(BATCH_PARAM, batch, requests);
    }

    private static String getMimeContentType() {
        return String.format("multipart/form-data; boundary=%s", MIME_BOUNDARY);
    }

    private static String getUserAgent() {
        if (userAgent == null) {
            userAgent = String.format("%s.%s", USER_AGENT_BASE, "3.23.1");
        }
        return userAgent;
    }

    private static String getBatchAppId(RequestBatch batch) {
        if (!Utility.isNullOrEmpty(batch.getBatchApplicationId())) {
            return batch.getBatchApplicationId();
        }
        for (Request request : batch) {
            Session session = request.session;
            if (session == null) continue;
            return session.getApplicationId();
        }
        return defaultBatchApplicationId;
    }

    private static <T extends GraphObject> List<T> typedListFromResponse(Response response, Class<T> clazz) {
        GraphMultiResult multiResult = response.getGraphObjectAs(GraphMultiResult.class);
        if (multiResult == null) {
            return null;
        }
        GraphObjectList<GraphObject> data = multiResult.getData();
        if (data == null) {
            return null;
        }
        return data.castToListOf(clazz);
    }

    private static boolean isSupportedAttachmentType(Object value) {
        return value instanceof Bitmap || value instanceof byte[] || value instanceof ParcelFileDescriptor || value instanceof ParcelFileDescriptorWithMimeType;
    }

    private static boolean isSupportedParameterType(Object value) {
        return value instanceof String || value instanceof Boolean || value instanceof Number || value instanceof Date;
    }

    private static String parameterToString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Boolean || value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Date) {
            SimpleDateFormat iso8601DateFormat = new SimpleDateFormat(ISO_8601_FORMAT_STRING, Locale.US);
            return iso8601DateFormat.format(value);
        }
        throw new IllegalArgumentException("Unsupported parameter type.");
    }

    static {
        versionPattern = Pattern.compile("^/?v\\d+\\.\\d+/(.*)");
    }

    private static class ParcelFileDescriptorWithMimeType
    implements Parcelable {
        private final String mimeType;
        private final ParcelFileDescriptor fileDescriptor;
        public static final Parcelable.Creator<ParcelFileDescriptorWithMimeType> CREATOR = new Parcelable.Creator<ParcelFileDescriptorWithMimeType>(){

            public ParcelFileDescriptorWithMimeType createFromParcel(Parcel in) {
                return new ParcelFileDescriptorWithMimeType(in);
            }

            public ParcelFileDescriptorWithMimeType[] newArray(int size) {
                return new ParcelFileDescriptorWithMimeType[size];
            }
        };

        public String getMimeType() {
            return this.mimeType;
        }

        public ParcelFileDescriptor getFileDescriptor() {
            return this.fileDescriptor;
        }

        public int describeContents() {
            return 1;
        }

        public void writeToParcel(Parcel out, int flags) {
            out.writeString(this.mimeType);
            out.writeFileDescriptor(this.fileDescriptor.getFileDescriptor());
        }

        public ParcelFileDescriptorWithMimeType(ParcelFileDescriptor fileDescriptor, String mimeType) {
            this.mimeType = mimeType;
            this.fileDescriptor = fileDescriptor;
        }

        private ParcelFileDescriptorWithMimeType(Parcel in) {
            this.mimeType = in.readString();
            this.fileDescriptor = in.readFileDescriptor();
        }
    }

    public static interface GraphPlaceListCallback {
        public void onCompleted(List<GraphPlace> var1, Response var2);
    }

    public static interface GraphUserListCallback {
        public void onCompleted(List<GraphUser> var1, Response var2);
    }

    public static interface GraphUserCallback {
        public void onCompleted(GraphUser var1, Response var2);
    }

    public static interface OnProgressCallback
    extends Callback {
        public void onProgress(long var1, long var3);
    }

    public static interface Callback {
        public void onCompleted(Response var1);
    }

    private static class Serializer
    implements KeyValueSerializer {
        private final OutputStream outputStream;
        private final Logger logger;
        private boolean firstWrite = true;
        private boolean useUrlEncode = false;

        public Serializer(OutputStream outputStream, Logger logger, boolean useUrlEncode) {
            this.outputStream = outputStream;
            this.logger = logger;
            this.useUrlEncode = useUrlEncode;
        }

        public void writeObject(String key, Object value, Request request) throws IOException {
            if (this.outputStream instanceof RequestOutputStream) {
                ((RequestOutputStream)((Object)this.outputStream)).setCurrentRequest(request);
            }
            if (Request.isSupportedParameterType(value)) {
                this.writeString(key, Request.parameterToString(value));
            } else if (value instanceof Bitmap) {
                this.writeBitmap(key, (Bitmap)value);
            } else if (value instanceof byte[]) {
                this.writeBytes(key, (byte[])value);
            } else if (value instanceof ParcelFileDescriptor) {
                this.writeFile(key, (ParcelFileDescriptor)value, null);
            } else if (value instanceof ParcelFileDescriptorWithMimeType) {
                this.writeFile(key, (ParcelFileDescriptorWithMimeType)value);
            } else {
                throw new IllegalArgumentException("value is not a supported type: String, Bitmap, byte[]");
            }
        }

        public void writeRequestsAsJson(String key, JSONArray requestJsonArray, Collection<Request> requests) throws IOException, JSONException {
            if (!(this.outputStream instanceof RequestOutputStream)) {
                this.writeString(key, requestJsonArray.toString());
                return;
            }
            RequestOutputStream requestOutputStream = (RequestOutputStream)((Object)this.outputStream);
            this.writeContentDisposition(key, null, null);
            this.write("[", new Object[0]);
            int i = 0;
            for (Request request : requests) {
                JSONObject requestJson = requestJsonArray.getJSONObject(i);
                requestOutputStream.setCurrentRequest(request);
                if (i > 0) {
                    this.write(",%s", requestJson.toString());
                } else {
                    this.write("%s", requestJson.toString());
                }
                ++i;
            }
            this.write("]", new Object[0]);
            if (this.logger != null) {
                this.logger.appendKeyValue("    " + key, requestJsonArray.toString());
            }
        }

        @Override
        public void writeString(String key, String value) throws IOException {
            this.writeContentDisposition(key, null, null);
            this.writeLine("%s", value);
            this.writeRecordBoundary();
            if (this.logger != null) {
                this.logger.appendKeyValue("    " + key, value);
            }
        }

        public void writeBitmap(String key, Bitmap bitmap) throws IOException {
            this.writeContentDisposition(key, key, "image/png");
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, this.outputStream);
            this.writeLine("", new Object[0]);
            this.writeRecordBoundary();
            if (this.logger != null) {
                this.logger.appendKeyValue("    " + key, "<Image>");
            }
        }

        public void writeBytes(String key, byte[] bytes) throws IOException {
            this.writeContentDisposition(key, key, "content/unknown");
            this.outputStream.write(bytes);
            this.writeLine("", new Object[0]);
            this.writeRecordBoundary();
            if (this.logger != null) {
                this.logger.appendKeyValue("    " + key, String.format("<Data: %d>", bytes.length));
            }
        }

        public void writeFile(String key, ParcelFileDescriptorWithMimeType descriptorWithMimeType) throws IOException {
            this.writeFile(key, descriptorWithMimeType.getFileDescriptor(), descriptorWithMimeType.getMimeType());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeFile(String key, ParcelFileDescriptor descriptor, String mimeType) throws IOException {
            if (mimeType == null) {
                mimeType = "content/unknown";
            }
            this.writeContentDisposition(key, key, mimeType);
            int totalBytes = 0;
            if (this.outputStream instanceof ProgressNoopOutputStream) {
                ((ProgressNoopOutputStream)this.outputStream).addProgress(descriptor.getStatSize());
            } else {
                ParcelFileDescriptor.AutoCloseInputStream inputStream = null;
                BufferedInputStream bufferedInputStream = null;
                try {
                    int bytesRead;
                    inputStream = new ParcelFileDescriptor.AutoCloseInputStream(descriptor);
                    bufferedInputStream = new BufferedInputStream((InputStream)inputStream);
                    byte[] buffer = new byte[8192];
                    while ((bytesRead = bufferedInputStream.read(buffer)) != -1) {
                        this.outputStream.write(buffer, 0, bytesRead);
                        totalBytes += bytesRead;
                    }
                }
                finally {
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            this.writeLine("", new Object[0]);
            this.writeRecordBoundary();
            if (this.logger != null) {
                this.logger.appendKeyValue("    " + key, String.format("<Data: %d>", totalBytes));
            }
        }

        public void writeRecordBoundary() throws IOException {
            if (!this.useUrlEncode) {
                this.writeLine("--%s", Request.MIME_BOUNDARY);
            } else {
                this.outputStream.write("&".getBytes());
            }
        }

        public void writeContentDisposition(String name, String filename, String contentType) throws IOException {
            if (!this.useUrlEncode) {
                this.write("Content-Disposition: form-data; name=\"%s\"", name);
                if (filename != null) {
                    this.write("; filename=\"%s\"", filename);
                }
                this.writeLine("", new Object[0]);
                if (contentType != null) {
                    this.writeLine("%s: %s", Request.CONTENT_TYPE_HEADER, contentType);
                }
                this.writeLine("", new Object[0]);
            } else {
                this.outputStream.write(String.format("%s=", name).getBytes());
            }
        }

        public void write(String format, Object ... args) throws IOException {
            if (!this.useUrlEncode) {
                if (this.firstWrite) {
                    this.outputStream.write("--".getBytes());
                    this.outputStream.write(Request.MIME_BOUNDARY.getBytes());
                    this.outputStream.write("\r\n".getBytes());
                    this.firstWrite = false;
                }
                this.outputStream.write(String.format(format, args).getBytes());
            } else {
                this.outputStream.write(URLEncoder.encode(String.format(format, args), "UTF-8").getBytes());
            }
        }

        public void writeLine(String format, Object ... args) throws IOException {
            this.write(format, args);
            if (!this.useUrlEncode) {
                this.write("\r\n", new Object[0]);
            }
        }
    }

    private static interface KeyValueSerializer {
        public void writeString(String var1, String var2) throws IOException;
    }

    private static class Attachment {
        private final Request request;
        private final Object value;

        public Attachment(Request request, Object value) {
            this.request = request;
            this.value = value;
        }

        public Request getRequest() {
            return this.request;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

