/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import android.content.Context;
import android.graphics.Typeface;
import android.widget.Button;
import com.facebook.android.R;

public class LikeButton
extends Button {
    private boolean isLiked;

    public LikeButton(Context context, boolean isLiked) {
        super(context);
        this.isLiked = isLiked;
        this.initialize();
    }

    public void setLikeState(boolean isLiked) {
        if (isLiked != this.isLiked) {
            this.isLiked = isLiked;
            this.updateForLikeStatus();
        }
    }

    private void initialize() {
        this.setGravity(16);
        this.setTextColor(this.getResources().getColor(R.color.com_facebook_likebutton_text_color));
        this.setTextSize(0, this.getResources().getDimension(R.dimen.com_facebook_likebutton_text_size));
        this.setTypeface(Typeface.DEFAULT_BOLD);
        this.setCompoundDrawablePadding(this.getResources().getDimensionPixelSize(R.dimen.com_facebook_likebutton_compound_drawable_padding));
        this.setPadding(this.getResources().getDimensionPixelSize(R.dimen.com_facebook_likebutton_padding_left), this.getResources().getDimensionPixelSize(R.dimen.com_facebook_likebutton_padding_top), this.getResources().getDimensionPixelSize(R.dimen.com_facebook_likebutton_padding_right), this.getResources().getDimensionPixelSize(R.dimen.com_facebook_likebutton_padding_bottom));
        this.updateForLikeStatus();
    }

    private void updateForLikeStatus() {
        if (this.isLiked) {
            this.setBackgroundResource(R.drawable.com_facebook_button_like_selected);
            this.setCompoundDrawablesWithIntrinsicBounds(R.drawable.com_facebook_button_like_icon_selected, 0, 0, 0);
            this.setText(this.getResources().getString(R.string.com_facebook_like_button_liked));
        } else {
            this.setBackgroundResource(R.drawable.com_facebook_button_like);
            this.setCompoundDrawablesWithIntrinsicBounds(R.drawable.com_facebook_button_like_icon, 0, 0, 0);
            this.setText(this.getResources().getString(R.string.com_facebook_like_button_not_liked));
        }
    }
}

