/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.database.Cursor;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.util.Base64;
import android.util.Log;
import com.facebook.BoltsMeasurementEventListener;
import com.facebook.FacebookException;
import com.facebook.FacebookRequestError;
import com.facebook.LoggingBehavior;
import com.facebook.Request;
import com.facebook.RequestBatch;
import com.facebook.Response;
import com.facebook.internal.AttributionIdentifiers;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import com.facebook.model.GraphObject;
import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONException;
import org.json.JSONObject;

public final class Settings {
    private static final String TAG = Settings.class.getCanonicalName();
    private static final HashSet<LoggingBehavior> loggingBehaviors = new HashSet<LoggingBehavior>(Arrays.asList(LoggingBehavior.DEVELOPER_ERRORS));
    private static volatile Executor executor;
    private static volatile boolean shouldAutoPublishInstall;
    private static volatile String appVersion;
    private static volatile String applicationId;
    private static volatile String appClientToken;
    private static volatile boolean defaultsLoaded;
    private static final String FACEBOOK_COM = "facebook.com";
    private static volatile String facebookDomain;
    private static AtomicLong onProgressThreshold;
    private static volatile boolean platformCompatibilityEnabled;
    private static volatile boolean isDebugEnabled;
    private static final int DEFAULT_CORE_POOL_SIZE = 5;
    private static final int DEFAULT_MAXIMUM_POOL_SIZE = 128;
    private static final int DEFAULT_KEEP_ALIVE = 1;
    private static final Object LOCK;
    private static final Uri ATTRIBUTION_ID_CONTENT_URI;
    private static final String ATTRIBUTION_ID_COLUMN_NAME = "aid";
    private static final String ATTRIBUTION_PREFERENCES = "com.facebook.sdk.attributionTracking";
    private static final String PUBLISH_ACTIVITY_PATH = "%s/activities";
    private static final String MOBILE_INSTALL_EVENT = "MOBILE_APP_INSTALL";
    private static final String ANALYTICS_EVENT = "event";
    private static final String AUTO_PUBLISH = "auto_publish";
    private static final String APP_EVENT_PREFERENCES = "com.facebook.sdk.appEventPreferences";
    private static final BlockingQueue<Runnable> DEFAULT_WORK_QUEUE;
    private static final ThreadFactory DEFAULT_THREAD_FACTORY;
    public static final String APPLICATION_ID_PROPERTY = "com.facebook.sdk.ApplicationId";
    public static final String CLIENT_TOKEN_PROPERTY = "com.facebook.sdk.ClientToken";
    private static Boolean sdkInitialized;

    public static synchronized void sdkInitialize(Context context) {
        if (sdkInitialized.booleanValue()) {
            return;
        }
        Settings.loadDefaultsFromMetadataIfNeeded(context);
        Utility.loadAppSettingsAsync(context, Settings.getApplicationId());
        BoltsMeasurementEventListener.getInstance(context.getApplicationContext());
        sdkInitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Set<LoggingBehavior> getLoggingBehaviors() {
        HashSet<LoggingBehavior> hashSet = loggingBehaviors;
        synchronized (hashSet) {
            return Collections.unmodifiableSet(new HashSet<LoggingBehavior>(loggingBehaviors));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addLoggingBehavior(LoggingBehavior behavior) {
        HashSet<LoggingBehavior> hashSet = loggingBehaviors;
        synchronized (hashSet) {
            loggingBehaviors.add(behavior);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void removeLoggingBehavior(LoggingBehavior behavior) {
        HashSet<LoggingBehavior> hashSet = loggingBehaviors;
        synchronized (hashSet) {
            loggingBehaviors.remove((Object)behavior);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void clearLoggingBehaviors() {
        HashSet<LoggingBehavior> hashSet = loggingBehaviors;
        synchronized (hashSet) {
            loggingBehaviors.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isLoggingBehaviorEnabled(LoggingBehavior behavior) {
        HashSet<LoggingBehavior> hashSet = loggingBehaviors;
        synchronized (hashSet) {
            return Settings.isDebugEnabled() && loggingBehaviors.contains((Object)behavior);
        }
    }

    @Deprecated
    public static final boolean isLoggingEnabled() {
        return Settings.isDebugEnabled();
    }

    @Deprecated
    public static final void setIsLoggingEnabled(boolean enabled) {
        Settings.setIsDebugEnabled(enabled);
    }

    public static final boolean isDebugEnabled() {
        return isDebugEnabled;
    }

    public static final void setIsDebugEnabled(boolean enabled) {
        isDebugEnabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Executor getExecutor() {
        Object object = LOCK;
        synchronized (object) {
            if (executor == null) {
                Executor executor = Settings.getAsyncTaskExecutor();
                if (executor == null) {
                    executor = new ThreadPoolExecutor(5, 128, 1L, TimeUnit.SECONDS, DEFAULT_WORK_QUEUE, DEFAULT_THREAD_FACTORY);
                }
                Settings.executor = executor;
            }
        }
        return executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setExecutor(Executor executor) {
        Validate.notNull(executor, "executor");
        Object object = LOCK;
        synchronized (object) {
            Settings.executor = executor;
        }
    }

    public static String getFacebookDomain() {
        return facebookDomain;
    }

    public static void setFacebookDomain(String facebookDomain) {
        Log.w((String)TAG, (String)"WARNING: Calling setFacebookDomain from non-DEBUG code.");
        Settings.facebookDomain = facebookDomain;
    }

    private static Executor getAsyncTaskExecutor() {
        Field executorField = null;
        try {
            executorField = AsyncTask.class.getField("THREAD_POOL_EXECUTOR");
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        Object executorObject = null;
        try {
            executorObject = executorField.get(null);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        if (executorObject == null) {
            return null;
        }
        if (!(executorObject instanceof Executor)) {
            return null;
        }
        return (Executor)executorObject;
    }

    static void publishInstallAsync(Context context, final String applicationId, final Request.Callback callback) {
        final Context applicationContext = context.getApplicationContext();
        Settings.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                final Response response = Settings.publishInstallAndWaitForResponse(applicationContext, applicationId, false);
                if (callback != null) {
                    Handler handler = new Handler(Looper.getMainLooper());
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onCompleted(response);
                        }
                    });
                }
            }
        });
    }

    @Deprecated
    public static void setShouldAutoPublishInstall(boolean shouldAutoPublishInstall) {
        Settings.shouldAutoPublishInstall = shouldAutoPublishInstall;
    }

    @Deprecated
    public static boolean getShouldAutoPublishInstall() {
        return shouldAutoPublishInstall;
    }

    static Response publishInstallAndWaitForResponse(Context context, String applicationId, boolean isAutoPublish) {
        try {
            if (context == null || applicationId == null) {
                throw new IllegalArgumentException("Both context and applicationId must be non-null");
            }
            AttributionIdentifiers identifiers = AttributionIdentifiers.getAttributionIdentifiers(context);
            SharedPreferences preferences = context.getSharedPreferences(ATTRIBUTION_PREFERENCES, 0);
            String pingKey = applicationId + "ping";
            String jsonKey = applicationId + "json";
            long lastPing = preferences.getLong(pingKey, 0L);
            String lastResponseJSON = preferences.getString(jsonKey, null);
            if (!isAutoPublish) {
                Settings.setShouldAutoPublishInstall(false);
            }
            GraphObject publishParams = GraphObject.Factory.create();
            publishParams.setProperty(ANALYTICS_EVENT, MOBILE_INSTALL_EVENT);
            Utility.setAppEventAttributionParameters(publishParams, identifiers, Utility.getHashedDeviceAndAppID(context, applicationId), Settings.getLimitEventAndDataUsage(context));
            publishParams.setProperty(AUTO_PUBLISH, isAutoPublish);
            publishParams.setProperty("application_package_name", context.getPackageName());
            String publishUrl = String.format(PUBLISH_ACTIVITY_PATH, applicationId);
            Request publishRequest = Request.newPostRequest(null, publishUrl, publishParams, null);
            if (lastPing != 0L) {
                GraphObject graphObject = null;
                try {
                    if (lastResponseJSON != null) {
                        graphObject = GraphObject.Factory.create(new JSONObject(lastResponseJSON));
                    }
                }
                catch (JSONException je) {
                    // empty catch block
                }
                if (graphObject == null) {
                    return Response.createResponsesFromString("true", null, new RequestBatch(publishRequest), true).get(0);
                }
                return new Response(null, null, null, graphObject, true);
            }
            if (identifiers == null || identifiers.getAndroidAdvertiserId() == null && identifiers.getAttributionId() == null) {
                throw new FacebookException("No attribution id available to send to server.");
            }
            if (!Utility.queryAppSettings(applicationId, false).supportsAttribution()) {
                throw new FacebookException("Install attribution has been disabled on the server.");
            }
            Response publishResponse = publishRequest.executeAndWait();
            SharedPreferences.Editor editor = preferences.edit();
            lastPing = System.currentTimeMillis();
            editor.putLong(pingKey, lastPing);
            if (publishResponse.getGraphObject() != null && publishResponse.getGraphObject().getInnerJSONObject() != null) {
                editor.putString(jsonKey, publishResponse.getGraphObject().getInnerJSONObject().toString());
            }
            editor.commit();
            return publishResponse;
        }
        catch (Exception e) {
            Utility.logd("Facebook-publish", e);
            return new Response(null, null, new FacebookRequestError(null, e));
        }
    }

    public static String getAttributionId(ContentResolver contentResolver) {
        try {
            String[] projection = new String[]{ATTRIBUTION_ID_COLUMN_NAME};
            Cursor c = contentResolver.query(ATTRIBUTION_ID_CONTENT_URI, projection, null, null, null);
            if (c == null || !c.moveToFirst()) {
                return null;
            }
            String attributionId = c.getString(c.getColumnIndex(ATTRIBUTION_ID_COLUMN_NAME));
            c.close();
            return attributionId;
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("Caught unexpected exception in getAttributionId(): " + e.toString()));
            return null;
        }
    }

    public static String getAppVersion() {
        return appVersion;
    }

    public static void setAppVersion(String appVersion) {
        Settings.appVersion = appVersion;
    }

    public static String getSdkVersion() {
        return "3.19.1";
    }

    public static boolean getLimitEventAndDataUsage(Context context) {
        SharedPreferences preferences = context.getSharedPreferences(APP_EVENT_PREFERENCES, 0);
        return preferences.getBoolean("limitEventUsage", false);
    }

    public static void setLimitEventAndDataUsage(Context context, boolean limitEventUsage) {
        SharedPreferences preferences = context.getSharedPreferences(APP_EVENT_PREFERENCES, 0);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putBoolean("limitEventUsage", limitEventUsage);
        editor.commit();
    }

    public static long getOnProgressThreshold() {
        return onProgressThreshold.get();
    }

    public static void setOnProgressThreshold(long threshold) {
        onProgressThreshold.set(threshold);
    }

    public static boolean getPlatformCompatibilityEnabled() {
        return platformCompatibilityEnabled;
    }

    public static void setPlatformCompatibilityEnabled(boolean platformCompatibilityEnabled) {
        Settings.platformCompatibilityEnabled = platformCompatibilityEnabled;
    }

    public static void loadDefaultsFromMetadata(Context context) {
        defaultsLoaded = true;
        if (context == null) {
            return;
        }
        ApplicationInfo ai = null;
        try {
            ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            return;
        }
        if (ai == null || ai.metaData == null) {
            return;
        }
        if (applicationId == null) {
            applicationId = ai.metaData.getString(APPLICATION_ID_PROPERTY);
        }
        if (appClientToken == null) {
            appClientToken = ai.metaData.getString(CLIENT_TOKEN_PROPERTY);
        }
    }

    static void loadDefaultsFromMetadataIfNeeded(Context context) {
        if (!defaultsLoaded) {
            Settings.loadDefaultsFromMetadata(context);
        }
    }

    public static String getApplicationSignature(Context context) {
        MessageDigest md;
        PackageInfo pInfo;
        if (context == null) {
            return null;
        }
        PackageManager packageManager = context.getPackageManager();
        if (packageManager == null) {
            return null;
        }
        String packageName = context.getPackageName();
        try {
            pInfo = packageManager.getPackageInfo(packageName, 64);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
        Signature[] signatures = pInfo.signatures;
        if (signatures == null || signatures.length == 0) {
            return null;
        }
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        md.update(pInfo.signatures[0].toByteArray());
        return Base64.encodeToString((byte[])md.digest(), (int)9);
    }

    public static String getApplicationId() {
        return applicationId;
    }

    public static void setApplicationId(String applicationId) {
        Settings.applicationId = applicationId;
    }

    public static String getClientToken() {
        return appClientToken;
    }

    public static void setClientToken(String clientToken) {
        appClientToken = clientToken;
    }

    static {
        defaultsLoaded = false;
        facebookDomain = FACEBOOK_COM;
        onProgressThreshold = new AtomicLong(65536L);
        isDebugEnabled = false;
        LOCK = new Object();
        ATTRIBUTION_ID_CONTENT_URI = Uri.parse((String)"content://com.facebook.katana.provider.AttributionIdProvider");
        DEFAULT_WORK_QUEUE = new LinkedBlockingQueue<Runnable>(10);
        DEFAULT_THREAD_FACTORY = new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, "FacebookSdk #" + this.counter.incrementAndGet());
            }
        };
        sdkInitialized = false;
    }
}

