/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.os.Handler;
import com.facebook.Request;
import com.facebook.RequestAsyncTask;
import com.facebook.Response;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class RequestBatch
extends AbstractList<Request> {
    private static AtomicInteger idGenerator = new AtomicInteger();
    private Handler callbackHandler;
    private List<Request> requests = new ArrayList<Request>();
    private int timeoutInMilliseconds = 0;
    private final String id = Integer.valueOf(idGenerator.incrementAndGet()).toString();
    private List<Callback> callbacks = new ArrayList<Callback>();
    private String batchApplicationId;

    public RequestBatch() {
        this.requests = new ArrayList<Request>();
    }

    public RequestBatch(Collection<Request> requests) {
        this.requests = new ArrayList<Request>(requests);
    }

    public RequestBatch(Request ... requests) {
        this.requests = Arrays.asList(requests);
    }

    public RequestBatch(RequestBatch requests) {
        this.requests = new ArrayList<Request>(requests);
        this.callbackHandler = requests.callbackHandler;
        this.timeoutInMilliseconds = requests.timeoutInMilliseconds;
        this.callbacks = new ArrayList<Callback>(requests.callbacks);
    }

    public int getTimeout() {
        return this.timeoutInMilliseconds;
    }

    public void setTimeout(int timeoutInMilliseconds) {
        if (timeoutInMilliseconds < 0) {
            throw new IllegalArgumentException("Argument timeoutInMilliseconds must be >= 0.");
        }
        this.timeoutInMilliseconds = timeoutInMilliseconds;
    }

    public void addCallback(Callback callback) {
        if (!this.callbacks.contains(callback)) {
            this.callbacks.add(callback);
        }
    }

    public void removeCallback(Callback callback) {
        this.callbacks.remove(callback);
    }

    @Override
    public final boolean add(Request request) {
        return this.requests.add(request);
    }

    @Override
    public final void add(int location, Request request) {
        this.requests.add(location, request);
    }

    @Override
    public final void clear() {
        this.requests.clear();
    }

    @Override
    public final Request get(int i) {
        return this.requests.get(i);
    }

    @Override
    public final Request remove(int location) {
        return this.requests.remove(location);
    }

    @Override
    public final Request set(int location, Request request) {
        return this.requests.set(location, request);
    }

    @Override
    public final int size() {
        return this.requests.size();
    }

    final String getId() {
        return this.id;
    }

    final Handler getCallbackHandler() {
        return this.callbackHandler;
    }

    final void setCallbackHandler(Handler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    final List<Request> getRequests() {
        return this.requests;
    }

    final List<Callback> getCallbacks() {
        return this.callbacks;
    }

    final String getBatchApplicationId() {
        return this.batchApplicationId;
    }

    final void setBatchApplicationId(String batchApplicationId) {
        this.batchApplicationId = batchApplicationId;
    }

    public final List<Response> executeAndWait() {
        return this.executeAndWaitImpl();
    }

    public final RequestAsyncTask executeAsync() {
        return this.executeAsyncImpl();
    }

    List<Response> executeAndWaitImpl() {
        return Request.executeBatchAndWait(this);
    }

    RequestAsyncTask executeAsyncImpl() {
        return Request.executeBatchAsync(this);
    }

    public static interface OnProgressCallback
    extends Callback {
        public void onBatchProgress(RequestBatch var1, long var2, long var4);
    }

    public static interface Callback {
        public void onBatchCompleted(RequestBatch var1);
    }
}

