/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import com.facebook.FacebookException;
import com.facebook.NativeAppCallContentProvider;
import com.facebook.internal.Utility;
import com.facebook.internal.Validate;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;

public final class NativeAppCallAttachmentStore
implements NativeAppCallContentProvider.AttachmentDataSource {
    private static final String TAG = NativeAppCallAttachmentStore.class.getName();
    static final String ATTACHMENTS_DIR_NAME = "com.facebook.NativeAppCallAttachmentStore.files";
    private static File attachmentsDirectory;

    public void addAttachmentsForCall(Context context, UUID callId, Map<String, Bitmap> imageAttachments) {
        Validate.notNull(context, "context");
        Validate.notNull(callId, "callId");
        Validate.containsNoNulls(imageAttachments.values(), "imageAttachments");
        Validate.containsNoNullOrEmpty(imageAttachments.keySet(), "imageAttachments");
        this.addAttachments(context, callId, imageAttachments, new ProcessAttachment<Bitmap>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processAttachment(Bitmap attachment, File outputFile) throws IOException {
                FileOutputStream outputStream = new FileOutputStream(outputFile);
                try {
                    attachment.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)outputStream);
                }
                finally {
                    Utility.closeQuietly(outputStream);
                }
            }
        });
    }

    public void addAttachmentFilesForCall(Context context, UUID callId, Map<String, File> imageAttachmentFiles) {
        Validate.notNull(context, "context");
        Validate.notNull(callId, "callId");
        Validate.containsNoNulls(imageAttachmentFiles.values(), "imageAttachmentFiles");
        Validate.containsNoNullOrEmpty(imageAttachmentFiles.keySet(), "imageAttachmentFiles");
        this.addAttachments(context, callId, imageAttachmentFiles, new ProcessAttachment<File>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processAttachment(File attachment, File outputFile) throws IOException {
                FileOutputStream outputStream = new FileOutputStream(outputFile);
                FileInputStream inputStream = null;
                try {
                    int len;
                    inputStream = new FileInputStream(attachment);
                    byte[] buffer = new byte[1024];
                    while ((len = inputStream.read(buffer)) > 0) {
                        outputStream.write(buffer, 0, len);
                    }
                }
                finally {
                    Utility.closeQuietly(outputStream);
                    Utility.closeQuietly(inputStream);
                }
            }
        });
    }

    private <T> void addAttachments(Context context, UUID callId, Map<String, T> attachments, ProcessAttachment<T> processor) {
        if (attachments.size() == 0) {
            return;
        }
        if (attachmentsDirectory == null) {
            this.cleanupAllAttachments(context);
        }
        this.ensureAttachmentsDirectoryExists(context);
        ArrayList<File> filesToCleanup = new ArrayList<File>();
        try {
            for (Map.Entry<String, T> entry : attachments.entrySet()) {
                String attachmentName = entry.getKey();
                T attachment = entry.getValue();
                File file = this.getAttachmentFile(callId, attachmentName, true);
                filesToCleanup.add(file);
                processor.processAttachment(attachment, file);
            }
        }
        catch (IOException exception) {
            Log.e((String)TAG, (String)("Got unexpected exception:" + exception));
            for (File file : filesToCleanup) {
                try {
                    file.delete();
                }
                catch (Exception e) {}
            }
            throw new FacebookException(exception);
        }
    }

    public void cleanupAttachmentsForCall(Context context, UUID callId) {
        File dir = this.getAttachmentsDirectoryForCall(callId, false);
        Utility.deleteDirectory(dir);
    }

    @Override
    public File openAttachment(UUID callId, String attachmentName) throws FileNotFoundException {
        if (Utility.isNullOrEmpty(attachmentName) || callId == null) {
            throw new FileNotFoundException();
        }
        try {
            return this.getAttachmentFile(callId, attachmentName, false);
        }
        catch (IOException e) {
            throw new FileNotFoundException();
        }
    }

    static synchronized File getAttachmentsDirectory(Context context) {
        if (attachmentsDirectory == null) {
            attachmentsDirectory = new File(context.getCacheDir(), ATTACHMENTS_DIR_NAME);
        }
        return attachmentsDirectory;
    }

    File ensureAttachmentsDirectoryExists(Context context) {
        File dir = NativeAppCallAttachmentStore.getAttachmentsDirectory(context);
        dir.mkdirs();
        return dir;
    }

    File getAttachmentsDirectoryForCall(UUID callId, boolean create) {
        if (attachmentsDirectory == null) {
            return null;
        }
        File dir = new File(attachmentsDirectory, callId.toString());
        if (create && !dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    File getAttachmentFile(UUID callId, String attachmentName, boolean createDirs) throws IOException {
        File dir = this.getAttachmentsDirectoryForCall(callId, createDirs);
        if (dir == null) {
            return null;
        }
        try {
            return new File(dir, URLEncoder.encode(attachmentName, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    void cleanupAllAttachments(Context context) {
        File dir = NativeAppCallAttachmentStore.getAttachmentsDirectory(context);
        Utility.deleteDirectory(dir);
    }

    static interface ProcessAttachment<T> {
        public void processAttachment(T var1, File var2) throws IOException;
    }
}

