/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads;

import android.content.Context;
import android.support.annotation.Keep;
import com.facebook.ads.internal.settings.AdInternalSettings;
import java.io.Serializable;
import java.util.Collection;

@Keep
public class AdSettings {
    public static final boolean DEBUG = false;

    public static void setDebugBuild(boolean isDebugBuild) {
        AdInternalSettings.setDebugBuild(isDebugBuild);
    }

    public static void turnOnSDKDebugger(Context context) {
        AdInternalSettings.turnOnSDKDebugger(context);
    }

    public static void addTestDevice(String deviceIdHash) {
        AdInternalSettings.addTestDevice(deviceIdHash);
    }

    public static void addTestDevices(Collection<String> deviceIdHashes) {
        AdInternalSettings.addTestDevices(deviceIdHashes);
    }

    public static void clearTestDevices() {
        AdInternalSettings.clearTestDevices();
    }

    public static boolean isTestMode(Context context) {
        return AdInternalSettings.isTestMode(context);
    }

    public static void setTestMode(boolean enabled) {
        AdInternalSettings.setTestMode(enabled);
    }

    public static void setUrlPrefix(String urlPrefix) {
        AdInternalSettings.setUrlPrefix(urlPrefix);
    }

    public static String getUrlPrefix() {
        return AdInternalSettings.getUrlPrefix();
    }

    public static boolean isVideoAutoplay() {
        return AdInternalSettings.isVideoAutoplay();
    }

    public static boolean isVideoAutoplayOnMobile() {
        return AdInternalSettings.isVideoAutoplayOnMobile();
    }

    public static void setVideoAutoplay(boolean enabled) {
        AdInternalSettings.setVideoAutoplay(enabled);
    }

    public static void setVideoAutoplayOnMobile(boolean enabled) {
        AdInternalSettings.setVideoAutoplayOnMobile(enabled);
    }

    public static void setMediationService(String mediationService) {
        AdInternalSettings.setMediationService(mediationService);
    }

    public static String getMediationService() {
        return AdInternalSettings.getMediationService();
    }

    public static void setIsChildDirected(boolean childDirected) {
        AdInternalSettings.sSettingsBundle.putBoolean("BOOL_CHILD_DIRECTED_KEY", childDirected);
    }

    public static boolean isChildDirected() {
        return AdInternalSettings.sSettingsBundle.getBoolean("BOOL_CHILD_DIRECTED_KEY", false);
    }

    public static void setTestAdType(TestAdType testAdType) {
        AdInternalSettings.sSettingsBundle.putSerializable("TEST_AD_TYPE_KEY", testAdType);
    }

    public static TestAdType getTestAdType() {
        Serializable testAdTypeKey = AdInternalSettings.sSettingsBundle.getSerializable("TEST_AD_TYPE_KEY");
        if (testAdTypeKey == null || !(testAdTypeKey instanceof TestAdType)) {
            AdInternalSettings.sSettingsBundle.putSerializable("TEST_AD_TYPE_KEY", TestAdType.DEFAULT);
            return TestAdType.DEFAULT;
        }
        return (TestAdType)testAdTypeKey;
    }

    public static void setVisibleAnimation(boolean enabled) {
        AdInternalSettings.setVisibleAnimation(enabled);
    }

    public static void setMultiprocessSupportMode(MultiprocessSupportMode mode) {
        AdInternalSettings.setMultiprocessSupportMode(mode);
    }

    public static void setIntegrationErrorMode(IntegrationErrorMode mode) {
        AdInternalSettings.sSettingsBundle.putSerializable("SRL_INTEGRATION_ERROR_MODE_KEY", (Serializable)((Object)mode));
    }

    @Keep
    public static enum TestAdType implements Serializable
    {
        DEFAULT("DEFAULT", "Default"),
        IMG_16_9_APP_INSTALL("IMG_16_9_APP_INSTALL", "Image App install"),
        IMG_16_9_LINK("IMG_16_9_LINK", "Image link"),
        VIDEO_HD_16_9_46S_APP_INSTALL("VID_HD_16_9_46S_APP_INSTALL", "Video 46 sec App install"),
        VIDEO_HD_16_9_46S_LINK("VID_HD_16_9_46S_LINK", "Video 46 sec link"),
        VIDEO_HD_16_9_15S_APP_INSTALL("VID_HD_16_9_15S_APP_INSTALL", "Video 15 sec App install"),
        VIDEO_HD_16_9_15S_LINK("VID_HD_16_9_15S_LINK", "Video 15 sec link"),
        VIDEO_HD_9_16_39S_APP_INSTALL("VID_HD_9_16_39S_APP_INSTALL", "Video 39 sec App install"),
        VIDEO_HD_9_16_39S_LINK("VID_HD_9_16_39S_LINK", "Video 39 sec link"),
        CAROUSEL_IMG_SQUARE_APP_INSTALL("CAROUSEL_IMG_SQUARE_APP_INSTALL", "Carousel App install"),
        CAROUSEL_IMG_SQUARE_LINK("CAROUSEL_IMG_SQUARE_LINK", "Carousel link");

        public static final long serialVersionUID = 1L;
        private final String adTypeString;
        private final String humanReadable;

        private TestAdType(String adTypeString, String humanReadable) {
            this.adTypeString = adTypeString;
            this.humanReadable = humanReadable;
        }

        public String getAdTypeString() {
            return this.adTypeString;
        }

        public String getHumanReadable() {
            return this.humanReadable;
        }
    }

    @Keep
    public static enum IntegrationErrorMode {
        INTEGRATION_ERROR_CRASH_DEBUG_MODE,
        INTEGRATION_ERROR_CALLBACK_MODE;

        public static final long serialVersionUID = 1L;
    }

    @Keep
    public static enum MultiprocessSupportMode {
        MULTIPROCESS_SUPPORT_MODE_ON,
        MULTIPROCESS_SUPPORT_MODE_AUTO,
        MULTIPROCESS_SUPPORT_MODE_OFF;

        public static final long serialVersionUID = 1L;
    }
}

