/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads;

import android.content.Context;
import android.support.annotation.Keep;
import android.support.annotation.Nullable;
import android.view.View;
import com.facebook.ads.Ad;
import com.facebook.ads.ExtraHints;
import com.facebook.ads.NativeAdListener;
import com.facebook.ads.NativeAdViewAttributes;
import com.facebook.ads.internal.api.NativeAdBaseApi;
import com.facebook.ads.internal.api.NativeAdImageApi;
import com.facebook.ads.internal.api.NativeAdRatingApi;
import com.facebook.ads.internal.dynamicloading.DynamicLoaderFactory;
import org.json.JSONObject;

@Keep
public abstract class NativeAdBase
implements Ad {
    final NativeAdBaseApi mNativeAdBaseApi;

    public static NativeAdBase fromBidPayload(Context context, String placementId, String bidPayload) throws Exception {
        return DynamicLoaderFactory.makeLoader(context).createNativeAdBaseFromBidPayload(context, placementId, bidPayload);
    }

    public NativeAdBase(Context context, String placementId) {
        this.mNativeAdBaseApi = DynamicLoaderFactory.makeLoader(context).createNativeAdBaseApi(context, placementId);
    }

    public NativeAdBase(NativeAdBaseApi nativeAdBaseApi) {
        this.mNativeAdBaseApi = nativeAdBaseApi;
    }

    NativeAdBase(Context context, NativeAdBase other) {
        this.mNativeAdBaseApi = DynamicLoaderFactory.makeLoader(context).createNativeAdBaseApi(other.mNativeAdBaseApi);
    }

    public NativeAdBaseApi getInternalNativeAd() {
        return this.mNativeAdBaseApi;
    }

    public void setAdListener(NativeAdListener adListener) {
        this.mNativeAdBaseApi.setAdListener(adListener, this);
    }

    @Override
    public void setExtraHints(ExtraHints extraHints) {
        this.mNativeAdBaseApi.setExtraHints(extraHints);
    }

    @Override
    public void loadAd() {
        this.mNativeAdBaseApi.loadAd();
    }

    public void loadAd(MediaCacheFlag mediaCacheFlag) {
        this.mNativeAdBaseApi.loadAd(mediaCacheFlag);
    }

    @Override
    public void loadAdFromBid(String bidPayload) {
        this.mNativeAdBaseApi.loadAdFromBid(bidPayload);
    }

    public void loadAdFromBid(String bidPayload, MediaCacheFlag mediaCacheFlag) {
        this.mNativeAdBaseApi.loadAdFromBid(bidPayload, mediaCacheFlag);
    }

    public void downloadMedia() {
        this.mNativeAdBaseApi.downloadMedia();
    }

    @Override
    public void destroy() {
        this.mNativeAdBaseApi.destroy();
    }

    @Override
    public String getPlacementId() {
        return this.mNativeAdBaseApi.getPlacementId();
    }

    @Override
    public boolean isAdInvalidated() {
        return this.mNativeAdBaseApi.isAdInvalidated();
    }

    public boolean isAdLoaded() {
        return this.mNativeAdBaseApi.isAdLoaded();
    }

    @Deprecated
    public boolean isNativeConfigEnabled() {
        return false;
    }

    public boolean hasCallToAction() {
        return this.mNativeAdBaseApi.hasCallToAction();
    }

    public Image getAdIcon() {
        return this.mNativeAdBaseApi.getAdIcon() == null ? null : new Image(this.mNativeAdBaseApi.getAdIcon());
    }

    public Image getAdCoverImage() {
        return this.mNativeAdBaseApi.getAdCoverImage() == null ? null : new Image(this.mNativeAdBaseApi.getAdCoverImage());
    }

    @Deprecated
    public NativeAdViewAttributes getAdViewAttributes() {
        return new NativeAdViewAttributes();
    }

    @Nullable
    public String getAdvertiserName() {
        return this.mNativeAdBaseApi.getAdvertiserName();
    }

    @Nullable
    public String getAdHeadline() {
        return this.mNativeAdBaseApi.getAdHeadline();
    }

    public String getAdBodyText() {
        return this.mNativeAdBaseApi.getAdBodyText();
    }

    @Nullable
    public String getAdUntrimmedBodyText() {
        return this.mNativeAdBaseApi.getAdUntrimmedBodyText();
    }

    @Nullable
    public String getAdCallToAction() {
        return this.mNativeAdBaseApi.getAdCallToAction();
    }

    @Nullable
    public String getAdSocialContext() {
        return this.mNativeAdBaseApi.getAdSocialContext();
    }

    @Nullable
    public String getAdLinkDescription() {
        return this.mNativeAdBaseApi.getAdLinkDescription();
    }

    @Nullable
    public String getSponsoredTranslation() {
        return this.mNativeAdBaseApi.getSponsoredTranslation();
    }

    @Nullable
    public String getAdTranslation() {
        return this.mNativeAdBaseApi.getAdTranslation();
    }

    @Nullable
    public String getPromotedTranslation() {
        return this.mNativeAdBaseApi.getPromotedTranslation();
    }

    @Deprecated
    public Rating getAdStarRating() {
        return this.mNativeAdBaseApi.getAdStarRating() == null ? null : new Rating(this.mNativeAdBaseApi.getAdStarRating());
    }

    public String getId() {
        return this.mNativeAdBaseApi.getId();
    }

    public Image getAdChoicesIcon() {
        return this.mNativeAdBaseApi.getAdChoicesIcon() == null ? null : new Image(this.mNativeAdBaseApi.getAdChoicesIcon());
    }

    @Nullable
    public String getAdChoicesImageUrl() {
        return this.mNativeAdBaseApi.getAdChoicesImageUrl();
    }

    public String getAdChoicesLinkUrl() {
        return this.mNativeAdBaseApi.getAdChoicesLinkUrl();
    }

    public String getAdChoicesText() {
        return this.mNativeAdBaseApi.getAdChoicesText();
    }

    public void onCtaBroadcast() {
        this.mNativeAdBaseApi.onCtaBroadcast();
    }

    public void unregisterView() {
        this.mNativeAdBaseApi.unregisterView();
    }

    public void setOnTouchListener(View.OnTouchListener touchListener) {
        this.mNativeAdBaseApi.setOnTouchListener(touchListener);
    }

    @Keep
    public static enum NativeComponentTag {
        AD_ICON,
        AD_TITLE,
        AD_COVER_IMAGE,
        AD_SUBTITLE,
        AD_BODY,
        AD_CALL_TO_ACTION,
        AD_SOCIAL_CONTEXT,
        AD_CHOICES_ICON,
        AD_OPTIONS_VIEW,
        AD_MEDIA;


        public static void tagView(View view, NativeComponentTag tag) {
            DynamicLoaderFactory.makeLoader(view.getContext()).createNativeComponentTagApi().tagView(view, tag);
        }
    }

    public static enum MediaCacheFlag {
        NONE,
        ALL;

    }

    @Keep
    public static class Rating {
        private final NativeAdRatingApi mNativeAdRatingApi;

        Rating(NativeAdRatingApi nativeAdRatingApi) {
            this.mNativeAdRatingApi = nativeAdRatingApi;
        }

        public double getValue() {
            return this.mNativeAdRatingApi.getValue();
        }

        public double getScale() {
            return this.mNativeAdRatingApi.getScale();
        }

        @Nullable
        public static Rating fromJSONObject(JSONObject dataObject) {
            NativeAdRatingApi nativeAdRatingApi = DynamicLoaderFactory.makeLoaderUnsafe().createNativeAdRatingApi(dataObject);
            return nativeAdRatingApi == null ? null : new Rating(nativeAdRatingApi);
        }
    }

    @Keep
    public static class Image {
        private final NativeAdImageApi mNativeAdImageApi;

        Image(NativeAdImageApi nativeAdImageApi) {
            this.mNativeAdImageApi = nativeAdImageApi;
        }

        public int getWidth() {
            return this.mNativeAdImageApi.getWidth();
        }

        public int getHeight() {
            return this.mNativeAdImageApi.getHeight();
        }

        @Nullable
        public static Image fromJSONObject(JSONObject dataObject) {
            NativeAdImageApi nativeAdImageApi = DynamicLoaderFactory.makeLoaderUnsafe().createNativeAdImageApi(dataObject);
            return nativeAdImageApi == null ? null : new Image(nativeAdImageApi);
        }
    }
}

