/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal;

import com.facebook.ads.AdError;
import com.facebook.ads.internal.b;

public enum AdErrorType {
    UNKNOWN_ERROR(-1, "unknown error", false),
    NETWORK_ERROR(1000, "Network Error", true),
    NO_FILL(1001, "No Fill", true),
    LOAD_TOO_FREQUENTLY(1002, "Ad was re-loaded too frequently", true),
    DISABLED_APP(1005, "App is disabled from making ad requests", true),
    SERVER_ERROR(2000, "Server Error", true),
    INTERNAL_ERROR(2001, "Internal Error", true),
    START_BEFORE_INIT(2004, "initAd must be called before startAd", true),
    AD_REQUEST_FAILED(1111, "Facebook Ads SDK request for ads failed", false),
    AD_REQUEST_TIMEOUT(1112, "Facebook Ads SDK request for ads timed out", false),
    PARSER_FAILURE(1201, "Failed to parse Facebook Ads SDK delivery response", false),
    UNKNOWN_RESPONSE(1202, "Unknown Facebook Ads SDK delivery response type", false),
    ERROR_MESSAGE(1203, "Facebook Ads SDK delivery response Error message", true),
    NO_AD_PLACEMENT(1302, "Facebook Ads SDK returned no ad placements", false),
    BID_IMPRESSION_MISMATCH(4001, "Bid payload does not match placement", true),
    BID_PAYLOAD_ERROR(4002, "Invalid bid payload", false);

    private final int a;
    private final String b;
    private final boolean c;

    private AdErrorType(int n3, String string2, boolean bl) {
        this.a = n3;
        this.b = string2;
        this.c = bl;
    }

    public int getErrorCode() {
        return this.a;
    }

    public String getDefaultErrorMessage() {
        return this.b;
    }

    boolean a() {
        return this.c;
    }

    public b getAdErrorWrapper(String string) {
        return new b(this, string);
    }

    public AdError getAdError(String string) {
        return new b(this, string).b();
    }

    public static AdErrorType adErrorTypeFromCode(int n2) {
        return AdErrorType.adErrorTypeFromCode(n2, UNKNOWN_ERROR);
    }

    public static AdErrorType adErrorTypeFromCode(int n2, AdErrorType adErrorType) {
        for (AdErrorType adErrorType2 : AdErrorType.values()) {
            if (adErrorType2.getErrorCode() != n2) continue;
            return adErrorType2;
        }
        return adErrorType;
    }
}

