/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.LeadGenQuestionOption;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeadGenQuestion
extends APINode {
    @SerializedName(value="key")
    private String mKey = null;
    @SerializedName(value="label")
    private String mLabel = null;
    @SerializedName(value="options")
    private List<LeadGenQuestionOption> mOptions = null;
    @SerializedName(value="type")
    private String mType = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static LeadGenQuestion loadJSON(String json, APIContext context) {
        LeadGenQuestion leadGenQuestion = (LeadGenQuestion)LeadGenQuestion.getGson().fromJson(json, LeadGenQuestion.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(leadGenQuestion.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        leadGenQuestion.context = context;
        leadGenQuestion.rawValue = json;
        return leadGenQuestion;
    }

    public static APINodeList<LeadGenQuestion> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block18: {
            APINodeList<LeadGenQuestion> leadGenQuestions = new APINodeList<LeadGenQuestion>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        leadGenQuestions.add(LeadGenQuestion.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return leadGenQuestions;
                }
                if (!result.isJsonObject()) break block18;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject().get("cursors").getAsJsonObject();
                        String[] before = paging.has("before") ? paging.get("before").getAsString() : null;
                        String after = paging.has("after") ? paging.get("after").getAsString() : null;
                        leadGenQuestions.setPaging((String)before, after);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            leadGenQuestions.add(LeadGenQuestion.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                leadGenQuestions.add(LeadGenQuestion.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            leadGenQuestions.add(LeadGenQuestion.loadJSON(obj.toString(), context));
                        }
                    }
                    return leadGenQuestions;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        leadGenQuestions.add(LeadGenQuestion.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return leadGenQuestions;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        leadGenQuestions.add(LeadGenQuestion.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return leadGenQuestions;
                }
                leadGenQuestions.clear();
                leadGenQuestions.add(LeadGenQuestion.loadJSON(json, context));
                return leadGenQuestions;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return LeadGenQuestion.getGson().toJson((Object)this);
    }

    public String getFieldKey() {
        return this.mKey;
    }

    public LeadGenQuestion setFieldKey(String value) {
        this.mKey = value;
        return this;
    }

    public String getFieldLabel() {
        return this.mLabel;
    }

    public LeadGenQuestion setFieldLabel(String value) {
        this.mLabel = value;
        return this;
    }

    public List<LeadGenQuestionOption> getFieldOptions() {
        return this.mOptions;
    }

    public LeadGenQuestion setFieldOptions(List<LeadGenQuestionOption> value) {
        this.mOptions = value;
        return this;
    }

    public LeadGenQuestion setFieldOptions(String value) {
        Type type = new TypeToken<List<LeadGenQuestionOption>>(){}.getType();
        this.mOptions = (List)LeadGenQuestionOption.getGson().fromJson(value, type);
        return this;
    }

    public String getFieldType() {
        return this.mType;
    }

    public LeadGenQuestion setFieldType(String value) {
        this.mType = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public LeadGenQuestion copyFrom(LeadGenQuestion instance) {
        this.mKey = instance.mKey;
        this.mLabel = instance.mLabel;
        this.mOptions = instance.mOptions;
        this.mType = instance.mType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<LeadGenQuestion> getParser() {
        return new APIRequest.ResponseParser<LeadGenQuestion>(){

            @Override
            public APINodeList<LeadGenQuestion> parseResponse(String response, APIContext context, APIRequest<LeadGenQuestion> request) throws APIException.MalformedResponseException {
                return LeadGenQuestion.parseResponse(response, context, request);
            }
        };
    }
}

