/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AppLinks;
import com.facebook.ads.sdk.HotelRoom;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hotel
extends APINode {
    @SerializedName(value="address")
    private String mAddress = null;
    @SerializedName(value="applinks")
    private AppLinks mApplinks = null;
    @SerializedName(value="brand")
    private String mBrand = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="guest_ratings")
    private String mGuestRatings = null;
    @SerializedName(value="hotel_id")
    private String mHotelId = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="images")
    private List<String> mImages = null;
    @SerializedName(value="lowest_base_price")
    private String mLowestBasePrice = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="phone")
    private String mPhone = null;
    @SerializedName(value="star_rating")
    private String mStarRating = null;
    @SerializedName(value="url")
    private String mUrl = null;
    protected static Gson gson = null;

    Hotel() {
    }

    public Hotel(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public Hotel(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public Hotel fetch() throws APIException {
        Hotel newInstance = Hotel.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static Hotel fetchById(Long id, APIContext context) throws APIException {
        return Hotel.fetchById(id.toString(), context);
    }

    public static Hotel fetchById(String id, APIContext context) throws APIException {
        Hotel hotel = new APIRequestGet(id, context).requestAllFields().execute();
        return hotel;
    }

    public static APINodeList<Hotel> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<Hotel>(context, "", "/", "GET", Hotel.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static Hotel loadJSON(String json, APIContext context) {
        Hotel hotel = (Hotel)Hotel.getGson().fromJson(json, Hotel.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(hotel.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        hotel.context = context;
        hotel.rawValue = json;
        return hotel;
    }

    public static APINodeList<Hotel> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block18: {
            APINodeList<Hotel> hotels = new APINodeList<Hotel>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        hotels.add(Hotel.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return hotels;
                }
                if (!result.isJsonObject()) break block18;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject().get("cursors").getAsJsonObject();
                        String[] before = paging.has("before") ? paging.get("before").getAsString() : null;
                        String after = paging.has("after") ? paging.get("after").getAsString() : null;
                        hotels.setPaging((String)before, after);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            hotels.add(Hotel.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                hotels.add(Hotel.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            hotels.add(Hotel.loadJSON(obj.toString(), context));
                        }
                    }
                    return hotels;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        hotels.add(Hotel.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return hotels;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        hotels.add(Hotel.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return hotels;
                }
                hotels.clear();
                hotels.add(Hotel.loadJSON(json, context));
                return hotels;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return Hotel.getGson().toJson((Object)this);
    }

    public APIRequestCreateHotelRoom createHotelRoom() {
        return new APIRequestCreateHotelRoom(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestDelete delete() {
        return new APIRequestDelete(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestUpdate update() {
        return new APIRequestUpdate(this.getPrefixedId().toString(), this.context);
    }

    public String getFieldAddress() {
        return this.mAddress;
    }

    public AppLinks getFieldApplinks() {
        if (this.mApplinks != null) {
            this.mApplinks.context = this.getContext();
        }
        return this.mApplinks;
    }

    public String getFieldBrand() {
        return this.mBrand;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldGuestRatings() {
        return this.mGuestRatings;
    }

    public String getFieldHotelId() {
        return this.mHotelId;
    }

    public String getFieldId() {
        return this.mId;
    }

    public List<String> getFieldImages() {
        return this.mImages;
    }

    public String getFieldLowestBasePrice() {
        return this.mLowestBasePrice;
    }

    public String getFieldName() {
        return this.mName;
    }

    public String getFieldPhone() {
        return this.mPhone;
    }

    public String getFieldStarRating() {
        return this.mStarRating;
    }

    public String getFieldUrl() {
        return this.mUrl;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public Hotel copyFrom(Hotel instance) {
        this.mAddress = instance.mAddress;
        this.mApplinks = instance.mApplinks;
        this.mBrand = instance.mBrand;
        this.mDescription = instance.mDescription;
        this.mGuestRatings = instance.mGuestRatings;
        this.mHotelId = instance.mHotelId;
        this.mId = instance.mId;
        this.mImages = instance.mImages;
        this.mLowestBasePrice = instance.mLowestBasePrice;
        this.mName = instance.mName;
        this.mPhone = instance.mPhone;
        this.mStarRating = instance.mStarRating;
        this.mUrl = instance.mUrl;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<Hotel> getParser() {
        return new APIRequest.ResponseParser<Hotel>(){

            @Override
            public APINodeList<Hotel> parseResponse(String response, APIContext context, APIRequest<Hotel> request) throws APIException.MalformedResponseException {
                return Hotel.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestUpdate
    extends APIRequest<Hotel> {
        Hotel lastResponse = null;
        public static final String[] PARAMS = new String[]{"address", "applinks", "brand", "description", "guest_ratings", "images", "name", "phone", "star_rating", "url"};
        public static final String[] FIELDS = new String[0];

        @Override
        public Hotel getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Hotel parseResponse(String response) throws APIException {
            return Hotel.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public Hotel execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Hotel execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestUpdate(String nodeId, APIContext context) {
            super(context, nodeId, "/", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestUpdate setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestUpdate setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestUpdate setAddress(Object address) {
            this.setParam("address", address);
            return this;
        }

        public APIRequestUpdate setAddress(String address) {
            this.setParam("address", address);
            return this;
        }

        public APIRequestUpdate setApplinks(Object applinks) {
            this.setParam("applinks", applinks);
            return this;
        }

        public APIRequestUpdate setApplinks(String applinks) {
            this.setParam("applinks", applinks);
            return this;
        }

        public APIRequestUpdate setBrand(String brand) {
            this.setParam("brand", brand);
            return this;
        }

        public APIRequestUpdate setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestUpdate setGuestRatings(List<Object> guestRatings) {
            this.setParam("guest_ratings", guestRatings);
            return this;
        }

        public APIRequestUpdate setGuestRatings(String guestRatings) {
            this.setParam("guest_ratings", guestRatings);
            return this;
        }

        public APIRequestUpdate setImages(List<Object> images) {
            this.setParam("images", images);
            return this;
        }

        public APIRequestUpdate setImages(String images) {
            this.setParam("images", images);
            return this;
        }

        public APIRequestUpdate setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestUpdate setPhone(String phone) {
            this.setParam("phone", phone);
            return this;
        }

        public APIRequestUpdate setStarRating(Double starRating) {
            this.setParam("star_rating", starRating);
            return this;
        }

        public APIRequestUpdate setStarRating(String starRating) {
            this.setParam("star_rating", starRating);
            return this;
        }

        public APIRequestUpdate setUrl(String url) {
            this.setParam("url", url);
            return this;
        }

        public APIRequestUpdate requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestUpdate requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestUpdate requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestUpdate requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<Hotel> {
        Hotel lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"address", "applinks", "brand", "description", "guest_ratings", "hotel_id", "id", "images", "lowest_base_price", "name", "phone", "star_rating", "url"};

        @Override
        public Hotel getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Hotel parseResponse(String response) throws APIException {
            return Hotel.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public Hotel execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Hotel execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAddressField() {
            return this.requestAddressField(true);
        }

        public APIRequestGet requestAddressField(boolean value) {
            this.requestField("address", value);
            return this;
        }

        public APIRequestGet requestApplinksField() {
            return this.requestApplinksField(true);
        }

        public APIRequestGet requestApplinksField(boolean value) {
            this.requestField("applinks", value);
            return this;
        }

        public APIRequestGet requestBrandField() {
            return this.requestBrandField(true);
        }

        public APIRequestGet requestBrandField(boolean value) {
            this.requestField("brand", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestGuestRatingsField() {
            return this.requestGuestRatingsField(true);
        }

        public APIRequestGet requestGuestRatingsField(boolean value) {
            this.requestField("guest_ratings", value);
            return this;
        }

        public APIRequestGet requestHotelIdField() {
            return this.requestHotelIdField(true);
        }

        public APIRequestGet requestHotelIdField(boolean value) {
            this.requestField("hotel_id", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestImagesField() {
            return this.requestImagesField(true);
        }

        public APIRequestGet requestImagesField(boolean value) {
            this.requestField("images", value);
            return this;
        }

        public APIRequestGet requestLowestBasePriceField() {
            return this.requestLowestBasePriceField(true);
        }

        public APIRequestGet requestLowestBasePriceField(boolean value) {
            this.requestField("lowest_base_price", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestPhoneField() {
            return this.requestPhoneField(true);
        }

        public APIRequestGet requestPhoneField(boolean value) {
            this.requestField("phone", value);
            return this;
        }

        public APIRequestGet requestStarRatingField() {
            return this.requestStarRatingField(true);
        }

        public APIRequestGet requestStarRatingField(boolean value) {
            this.requestField("star_rating", value);
            return this;
        }

        public APIRequestGet requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGet requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestDelete
    extends APIRequest<APINode> {
        APINode lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[0];

        @Override
        public APINode getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINode parseResponse(String response) throws APIException {
            return APINode.parseResponse(response, this.getContext(), this).head();
        }

        @Override
        public APINode execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINode execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestDelete(String nodeId, APIContext context) {
            super(context, nodeId, "/", "DELETE", Arrays.asList(PARAMS));
        }

        public APIRequestDelete setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestDelete setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestDelete requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestDelete requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestDelete requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestDelete requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestCreateHotelRoom
    extends APIRequest<HotelRoom> {
        HotelRoom lastResponse = null;
        public static final String[] PARAMS = new String[]{"applinks", "base_price", "currency", "description", "images", "margin_level", "name", "pricing_variables", "room_id", "sale_price", "url"};
        public static final String[] FIELDS = new String[0];

        @Override
        public HotelRoom getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public HotelRoom parseResponse(String response) throws APIException {
            return HotelRoom.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public HotelRoom execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public HotelRoom execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestCreateHotelRoom(String nodeId, APIContext context) {
            super(context, nodeId, "/hotel_rooms", "POST", Arrays.asList(PARAMS));
        }

        public APIRequestCreateHotelRoom setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestCreateHotelRoom setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestCreateHotelRoom setApplinks(Object applinks) {
            this.setParam("applinks", applinks);
            return this;
        }

        public APIRequestCreateHotelRoom setApplinks(String applinks) {
            this.setParam("applinks", applinks);
            return this;
        }

        public APIRequestCreateHotelRoom setBasePrice(Double basePrice) {
            this.setParam("base_price", basePrice);
            return this;
        }

        public APIRequestCreateHotelRoom setBasePrice(String basePrice) {
            this.setParam("base_price", basePrice);
            return this;
        }

        public APIRequestCreateHotelRoom setCurrency(String currency) {
            this.setParam("currency", currency);
            return this;
        }

        public APIRequestCreateHotelRoom setDescription(String description) {
            this.setParam("description", description);
            return this;
        }

        public APIRequestCreateHotelRoom setImages(List<Object> images) {
            this.setParam("images", images);
            return this;
        }

        public APIRequestCreateHotelRoom setImages(String images) {
            this.setParam("images", images);
            return this;
        }

        public APIRequestCreateHotelRoom setMarginLevel(Long marginLevel) {
            this.setParam("margin_level", marginLevel);
            return this;
        }

        public APIRequestCreateHotelRoom setMarginLevel(String marginLevel) {
            this.setParam("margin_level", marginLevel);
            return this;
        }

        public APIRequestCreateHotelRoom setName(String name) {
            this.setParam("name", name);
            return this;
        }

        public APIRequestCreateHotelRoom setPricingVariables(List<Object> pricingVariables) {
            this.setParam("pricing_variables", pricingVariables);
            return this;
        }

        public APIRequestCreateHotelRoom setPricingVariables(String pricingVariables) {
            this.setParam("pricing_variables", pricingVariables);
            return this;
        }

        public APIRequestCreateHotelRoom setRoomId(String roomId) {
            this.setParam("room_id", roomId);
            return this;
        }

        public APIRequestCreateHotelRoom setSalePrice(Double salePrice) {
            this.setParam("sale_price", salePrice);
            return this;
        }

        public APIRequestCreateHotelRoom setSalePrice(String salePrice) {
            this.setParam("sale_price", salePrice);
            return this;
        }

        public APIRequestCreateHotelRoom setUrl(String url) {
            this.setParam("url", url);
            return this;
        }

        public APIRequestCreateHotelRoom requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestCreateHotelRoom requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateHotelRoom requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestCreateHotelRoom requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestCreateHotelRoom requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestCreateHotelRoom requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }
    }
}

