/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.ProfilePictureSource;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Event
extends APINode {
    @SerializedName(value="attending_count")
    private Long mAttendingCount = null;
    @SerializedName(value="can_guests_invite")
    private Boolean mCanGuestsInvite = null;
    @SerializedName(value="category")
    private String mCategory = null;
    @SerializedName(value="cover")
    private Object mCover = null;
    @SerializedName(value="declined_count")
    private Long mDeclinedCount = null;
    @SerializedName(value="description")
    private String mDescription = null;
    @SerializedName(value="end_time")
    private String mEndTime = null;
    @SerializedName(value="guest_list_enabled")
    private Boolean mGuestListEnabled = null;
    @SerializedName(value="id")
    private String mId = null;
    @SerializedName(value="interested_count")
    private Long mInterestedCount = null;
    @SerializedName(value="is_canceled")
    private Boolean mIsCanceled = null;
    @SerializedName(value="is_page_owned")
    private Boolean mIsPageOwned = null;
    @SerializedName(value="is_viewer_admin")
    private Boolean mIsViewerAdmin = null;
    @SerializedName(value="maybe_count")
    private Long mMaybeCount = null;
    @SerializedName(value="name")
    private String mName = null;
    @SerializedName(value="noreply_count")
    private Long mNoreplyCount = null;
    @SerializedName(value="owner")
    private Object mOwner = null;
    @SerializedName(value="parent_group")
    private Object mParentGroup = null;
    @SerializedName(value="place")
    private Object mPlace = null;
    @SerializedName(value="start_time")
    private String mStartTime = null;
    @SerializedName(value="ticket_uri")
    private String mTicketUri = null;
    @SerializedName(value="timezone")
    private String mTimezone = null;
    @SerializedName(value="type")
    private EnumType mType = null;
    @SerializedName(value="updated_time")
    private String mUpdatedTime = null;
    protected static Gson gson = null;

    Event() {
    }

    public Event(Long id, APIContext context) {
        this(id.toString(), context);
    }

    public Event(String id, APIContext context) {
        this.mId = id;
        this.context = context;
    }

    public Event fetch() throws APIException {
        Event newInstance = Event.fetchById(this.getPrefixedId().toString(), this.context);
        this.copyFrom(newInstance);
        return this;
    }

    public static Event fetchById(Long id, APIContext context) throws APIException {
        return Event.fetchById(id.toString(), context);
    }

    public static Event fetchById(String id, APIContext context) throws APIException {
        Event event = new APIRequestGet(id, context).requestAllFields().execute();
        return event;
    }

    public static APINodeList<Event> fetchByIds(List<String> ids, List<String> fields, APIContext context) throws APIException {
        return (APINodeList)new APIRequest<Event>(context, "", "/", "GET", Event.getParser()).setParam("ids", APIRequest.joinStringList(ids)).requestFields(fields).execute();
    }

    private String getPrefixedId() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.getFieldId().toString();
    }

    public static Event loadJSON(String json, APIContext context) {
        Event event = (Event)Event.getGson().fromJson(json, Event.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(event.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        event.context = context;
        event.rawValue = json;
        return event;
    }

    public static APINodeList<Event> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block18: {
            APINodeList<Event> events = new APINodeList<Event>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        events.add(Event.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return events;
                }
                if (!result.isJsonObject()) break block18;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject().get("cursors").getAsJsonObject();
                        String[] before = paging.has("before") ? paging.get("before").getAsString() : null;
                        String after = paging.has("after") ? paging.get("after").getAsString() : null;
                        events.setPaging((String)before, after);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            events.add(Event.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                events.add(Event.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            events.add(Event.loadJSON(obj.toString(), context));
                        }
                    }
                    return events;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        events.add(Event.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return events;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        events.add(Event.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return events;
                }
                events.clear();
                events.add(Event.loadJSON(json, context));
                return events;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return Event.getGson().toJson((Object)this);
    }

    public APIRequestGetPicture getPicture() {
        return new APIRequestGetPicture(this.getPrefixedId().toString(), this.context);
    }

    public APIRequestGet get() {
        return new APIRequestGet(this.getPrefixedId().toString(), this.context);
    }

    public Long getFieldAttendingCount() {
        return this.mAttendingCount;
    }

    public Boolean getFieldCanGuestsInvite() {
        return this.mCanGuestsInvite;
    }

    public String getFieldCategory() {
        return this.mCategory;
    }

    public Object getFieldCover() {
        return this.mCover;
    }

    public Long getFieldDeclinedCount() {
        return this.mDeclinedCount;
    }

    public String getFieldDescription() {
        return this.mDescription;
    }

    public String getFieldEndTime() {
        return this.mEndTime;
    }

    public Boolean getFieldGuestListEnabled() {
        return this.mGuestListEnabled;
    }

    public String getFieldId() {
        return this.mId;
    }

    public Long getFieldInterestedCount() {
        return this.mInterestedCount;
    }

    public Boolean getFieldIsCanceled() {
        return this.mIsCanceled;
    }

    public Boolean getFieldIsPageOwned() {
        return this.mIsPageOwned;
    }

    public Boolean getFieldIsViewerAdmin() {
        return this.mIsViewerAdmin;
    }

    public Long getFieldMaybeCount() {
        return this.mMaybeCount;
    }

    public String getFieldName() {
        return this.mName;
    }

    public Long getFieldNoreplyCount() {
        return this.mNoreplyCount;
    }

    public Object getFieldOwner() {
        return this.mOwner;
    }

    public Object getFieldParentGroup() {
        return this.mParentGroup;
    }

    public Object getFieldPlace() {
        return this.mPlace;
    }

    public String getFieldStartTime() {
        return this.mStartTime;
    }

    public String getFieldTicketUri() {
        return this.mTicketUri;
    }

    public String getFieldTimezone() {
        return this.mTimezone;
    }

    public EnumType getFieldType() {
        return this.mType;
    }

    public String getFieldUpdatedTime() {
        return this.mUpdatedTime;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public Event copyFrom(Event instance) {
        this.mAttendingCount = instance.mAttendingCount;
        this.mCanGuestsInvite = instance.mCanGuestsInvite;
        this.mCategory = instance.mCategory;
        this.mCover = instance.mCover;
        this.mDeclinedCount = instance.mDeclinedCount;
        this.mDescription = instance.mDescription;
        this.mEndTime = instance.mEndTime;
        this.mGuestListEnabled = instance.mGuestListEnabled;
        this.mId = instance.mId;
        this.mInterestedCount = instance.mInterestedCount;
        this.mIsCanceled = instance.mIsCanceled;
        this.mIsPageOwned = instance.mIsPageOwned;
        this.mIsViewerAdmin = instance.mIsViewerAdmin;
        this.mMaybeCount = instance.mMaybeCount;
        this.mName = instance.mName;
        this.mNoreplyCount = instance.mNoreplyCount;
        this.mOwner = instance.mOwner;
        this.mParentGroup = instance.mParentGroup;
        this.mPlace = instance.mPlace;
        this.mStartTime = instance.mStartTime;
        this.mTicketUri = instance.mTicketUri;
        this.mTimezone = instance.mTimezone;
        this.mType = instance.mType;
        this.mUpdatedTime = instance.mUpdatedTime;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<Event> getParser() {
        return new APIRequest.ResponseParser<Event>(){

            @Override
            public APINodeList<Event> parseResponse(String response, APIContext context, APIRequest<Event> request) throws APIException.MalformedResponseException {
                return Event.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumType {
        VALUE_PRIVATE("private"),
        VALUE_PUBLIC("public"),
        VALUE_GROUP("group"),
        VALUE_COMMUNITY("community"),
        NULL(null);

        private String value;

        private EnumType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGet
    extends APIRequest<Event> {
        Event lastResponse = null;
        public static final String[] PARAMS = new String[0];
        public static final String[] FIELDS = new String[]{"attending_count", "can_guests_invite", "category", "cover", "declined_count", "description", "end_time", "guest_list_enabled", "id", "interested_count", "is_canceled", "is_page_owned", "is_viewer_admin", "maybe_count", "name", "noreply_count", "owner", "parent_group", "place", "start_time", "ticket_uri", "timezone", "type", "updated_time"};

        @Override
        public Event getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public Event parseResponse(String response) throws APIException {
            return Event.parseResponse(response, this.getContext(), (APIRequest)this).head();
        }

        @Override
        public Event execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public Event execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGet(String nodeId, APIContext context) {
            super(context, nodeId, "/", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGet setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGet setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGet requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGet requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGet requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGet requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGet requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGet requestAttendingCountField() {
            return this.requestAttendingCountField(true);
        }

        public APIRequestGet requestAttendingCountField(boolean value) {
            this.requestField("attending_count", value);
            return this;
        }

        public APIRequestGet requestCanGuestsInviteField() {
            return this.requestCanGuestsInviteField(true);
        }

        public APIRequestGet requestCanGuestsInviteField(boolean value) {
            this.requestField("can_guests_invite", value);
            return this;
        }

        public APIRequestGet requestCategoryField() {
            return this.requestCategoryField(true);
        }

        public APIRequestGet requestCategoryField(boolean value) {
            this.requestField("category", value);
            return this;
        }

        public APIRequestGet requestCoverField() {
            return this.requestCoverField(true);
        }

        public APIRequestGet requestCoverField(boolean value) {
            this.requestField("cover", value);
            return this;
        }

        public APIRequestGet requestDeclinedCountField() {
            return this.requestDeclinedCountField(true);
        }

        public APIRequestGet requestDeclinedCountField(boolean value) {
            this.requestField("declined_count", value);
            return this;
        }

        public APIRequestGet requestDescriptionField() {
            return this.requestDescriptionField(true);
        }

        public APIRequestGet requestDescriptionField(boolean value) {
            this.requestField("description", value);
            return this;
        }

        public APIRequestGet requestEndTimeField() {
            return this.requestEndTimeField(true);
        }

        public APIRequestGet requestEndTimeField(boolean value) {
            this.requestField("end_time", value);
            return this;
        }

        public APIRequestGet requestGuestListEnabledField() {
            return this.requestGuestListEnabledField(true);
        }

        public APIRequestGet requestGuestListEnabledField(boolean value) {
            this.requestField("guest_list_enabled", value);
            return this;
        }

        public APIRequestGet requestIdField() {
            return this.requestIdField(true);
        }

        public APIRequestGet requestIdField(boolean value) {
            this.requestField("id", value);
            return this;
        }

        public APIRequestGet requestInterestedCountField() {
            return this.requestInterestedCountField(true);
        }

        public APIRequestGet requestInterestedCountField(boolean value) {
            this.requestField("interested_count", value);
            return this;
        }

        public APIRequestGet requestIsCanceledField() {
            return this.requestIsCanceledField(true);
        }

        public APIRequestGet requestIsCanceledField(boolean value) {
            this.requestField("is_canceled", value);
            return this;
        }

        public APIRequestGet requestIsPageOwnedField() {
            return this.requestIsPageOwnedField(true);
        }

        public APIRequestGet requestIsPageOwnedField(boolean value) {
            this.requestField("is_page_owned", value);
            return this;
        }

        public APIRequestGet requestIsViewerAdminField() {
            return this.requestIsViewerAdminField(true);
        }

        public APIRequestGet requestIsViewerAdminField(boolean value) {
            this.requestField("is_viewer_admin", value);
            return this;
        }

        public APIRequestGet requestMaybeCountField() {
            return this.requestMaybeCountField(true);
        }

        public APIRequestGet requestMaybeCountField(boolean value) {
            this.requestField("maybe_count", value);
            return this;
        }

        public APIRequestGet requestNameField() {
            return this.requestNameField(true);
        }

        public APIRequestGet requestNameField(boolean value) {
            this.requestField("name", value);
            return this;
        }

        public APIRequestGet requestNoreplyCountField() {
            return this.requestNoreplyCountField(true);
        }

        public APIRequestGet requestNoreplyCountField(boolean value) {
            this.requestField("noreply_count", value);
            return this;
        }

        public APIRequestGet requestOwnerField() {
            return this.requestOwnerField(true);
        }

        public APIRequestGet requestOwnerField(boolean value) {
            this.requestField("owner", value);
            return this;
        }

        public APIRequestGet requestParentGroupField() {
            return this.requestParentGroupField(true);
        }

        public APIRequestGet requestParentGroupField(boolean value) {
            this.requestField("parent_group", value);
            return this;
        }

        public APIRequestGet requestPlaceField() {
            return this.requestPlaceField(true);
        }

        public APIRequestGet requestPlaceField(boolean value) {
            this.requestField("place", value);
            return this;
        }

        public APIRequestGet requestStartTimeField() {
            return this.requestStartTimeField(true);
        }

        public APIRequestGet requestStartTimeField(boolean value) {
            this.requestField("start_time", value);
            return this;
        }

        public APIRequestGet requestTicketUriField() {
            return this.requestTicketUriField(true);
        }

        public APIRequestGet requestTicketUriField(boolean value) {
            this.requestField("ticket_uri", value);
            return this;
        }

        public APIRequestGet requestTimezoneField() {
            return this.requestTimezoneField(true);
        }

        public APIRequestGet requestTimezoneField(boolean value) {
            this.requestField("timezone", value);
            return this;
        }

        public APIRequestGet requestTypeField() {
            return this.requestTypeField(true);
        }

        public APIRequestGet requestTypeField(boolean value) {
            this.requestField("type", value);
            return this;
        }

        public APIRequestGet requestUpdatedTimeField() {
            return this.requestUpdatedTimeField(true);
        }

        public APIRequestGet requestUpdatedTimeField(boolean value) {
            this.requestField("updated_time", value);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class APIRequestGetPicture
    extends APIRequest<ProfilePictureSource> {
        APINodeList<ProfilePictureSource> lastResponse = null;
        public static final String[] PARAMS = new String[]{"height", "redirect", "type", "width"};
        public static final String[] FIELDS = new String[]{"bottom", "height", "is_silhouette", "left", "right", "top", "url", "width"};

        @Override
        public APINodeList<ProfilePictureSource> getLastResponse() {
            return this.lastResponse;
        }

        @Override
        public APINodeList<ProfilePictureSource> parseResponse(String response) throws APIException {
            return ProfilePictureSource.parseResponse(response, this.getContext(), (APIRequest)this);
        }

        @Override
        public APINodeList<ProfilePictureSource> execute() throws APIException {
            return this.execute((Map)new HashMap());
        }

        @Override
        public APINodeList<ProfilePictureSource> execute(Map<String, Object> extraParams) throws APIException {
            this.lastResponse = this.parseResponse(this.executeInternal(extraParams));
            return this.lastResponse;
        }

        public APIRequestGetPicture(String nodeId, APIContext context) {
            super(context, nodeId, "/picture", "GET", Arrays.asList(PARAMS));
        }

        public APIRequestGetPicture setParam(String param, Object value) {
            this.setParamInternal(param, value);
            return this;
        }

        @Override
        public APIRequestGetPicture setParams(Map<String, Object> params) {
            this.setParamsInternal(params);
            return this;
        }

        public APIRequestGetPicture setHeight(Long height) {
            this.setParam("height", height);
            return this;
        }

        public APIRequestGetPicture setHeight(String height) {
            this.setParam("height", height);
            return this;
        }

        public APIRequestGetPicture setRedirect(Boolean redirect) {
            this.setParam("redirect", redirect);
            return this;
        }

        public APIRequestGetPicture setRedirect(String redirect) {
            this.setParam("redirect", redirect);
            return this;
        }

        public APIRequestGetPicture setType(ProfilePictureSource.EnumType type) {
            this.setParam("type", (Object)type);
            return this;
        }

        public APIRequestGetPicture setType(String type) {
            this.setParam("type", type);
            return this;
        }

        public APIRequestGetPicture setWidth(Long width) {
            this.setParam("width", width);
            return this;
        }

        public APIRequestGetPicture setWidth(String width) {
            this.setParam("width", width);
            return this;
        }

        public APIRequestGetPicture requestAllFields() {
            return this.requestAllFields(true);
        }

        public APIRequestGetPicture requestAllFields(boolean value) {
            for (String field : FIELDS) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPicture requestFields(List<String> fields) {
            return this.requestFields((List)fields, true);
        }

        @Override
        public APIRequestGetPicture requestFields(List<String> fields, boolean value) {
            for (String field : fields) {
                this.requestField(field, value);
            }
            return this;
        }

        @Override
        public APIRequestGetPicture requestField(String field) {
            this.requestField(field, true);
            return this;
        }

        @Override
        public APIRequestGetPicture requestField(String field, boolean value) {
            this.requestFieldInternal(field, value);
            return this;
        }

        public APIRequestGetPicture requestBottomField() {
            return this.requestBottomField(true);
        }

        public APIRequestGetPicture requestBottomField(boolean value) {
            this.requestField("bottom", value);
            return this;
        }

        public APIRequestGetPicture requestHeightField() {
            return this.requestHeightField(true);
        }

        public APIRequestGetPicture requestHeightField(boolean value) {
            this.requestField("height", value);
            return this;
        }

        public APIRequestGetPicture requestIsSilhouetteField() {
            return this.requestIsSilhouetteField(true);
        }

        public APIRequestGetPicture requestIsSilhouetteField(boolean value) {
            this.requestField("is_silhouette", value);
            return this;
        }

        public APIRequestGetPicture requestLeftField() {
            return this.requestLeftField(true);
        }

        public APIRequestGetPicture requestLeftField(boolean value) {
            this.requestField("left", value);
            return this;
        }

        public APIRequestGetPicture requestRightField() {
            return this.requestRightField(true);
        }

        public APIRequestGetPicture requestRightField(boolean value) {
            this.requestField("right", value);
            return this;
        }

        public APIRequestGetPicture requestTopField() {
            return this.requestTopField(true);
        }

        public APIRequestGetPicture requestTopField(boolean value) {
            this.requestField("top", value);
            return this;
        }

        public APIRequestGetPicture requestUrlField() {
            return this.requestUrlField(true);
        }

        public APIRequestGetPicture requestUrlField(boolean value) {
            this.requestField("url", value);
            return this;
        }

        public APIRequestGetPicture requestWidthField() {
            return this.requestWidthField(true);
        }

        public APIRequestGetPicture requestWidthField(boolean value) {
            this.requestField("width", value);
            return this;
        }
    }
}

