/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomAudiencePermission
extends APINode {
    @SerializedName(value="can_edit")
    private Boolean mCanEdit = null;
    @SerializedName(value="can_see_insight")
    private Boolean mCanSeeInsight = null;
    @SerializedName(value="can_share")
    private Boolean mCanShare = null;
    @SerializedName(value="subtype_supports_lookalike")
    private Boolean mSubtypeSupportsLookalike = null;
    @SerializedName(value="supports_recipient_lookalike")
    private Boolean mSupportsRecipientLookalike = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static CustomAudiencePermission loadJSON(String json, APIContext context) {
        CustomAudiencePermission customAudiencePermission = (CustomAudiencePermission)CustomAudiencePermission.getGson().fromJson(json, CustomAudiencePermission.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(customAudiencePermission.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        customAudiencePermission.context = context;
        customAudiencePermission.rawValue = json;
        return customAudiencePermission;
    }

    public static APINodeList<CustomAudiencePermission> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block18: {
            APINodeList<CustomAudiencePermission> customAudiencePermissions = new APINodeList<CustomAudiencePermission>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        customAudiencePermissions.add(CustomAudiencePermission.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return customAudiencePermissions;
                }
                if (!result.isJsonObject()) break block18;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject().get("cursors").getAsJsonObject();
                        String[] before = paging.has("before") ? paging.get("before").getAsString() : null;
                        String after = paging.has("after") ? paging.get("after").getAsString() : null;
                        customAudiencePermissions.setPaging((String)before, after);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            customAudiencePermissions.add(CustomAudiencePermission.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                customAudiencePermissions.add(CustomAudiencePermission.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            customAudiencePermissions.add(CustomAudiencePermission.loadJSON(obj.toString(), context));
                        }
                    }
                    return customAudiencePermissions;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        customAudiencePermissions.add(CustomAudiencePermission.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return customAudiencePermissions;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        customAudiencePermissions.add(CustomAudiencePermission.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return customAudiencePermissions;
                }
                customAudiencePermissions.clear();
                customAudiencePermissions.add(CustomAudiencePermission.loadJSON(json, context));
                return customAudiencePermissions;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return CustomAudiencePermission.getGson().toJson((Object)this);
    }

    public Boolean getFieldCanEdit() {
        return this.mCanEdit;
    }

    public CustomAudiencePermission setFieldCanEdit(Boolean value) {
        this.mCanEdit = value;
        return this;
    }

    public Boolean getFieldCanSeeInsight() {
        return this.mCanSeeInsight;
    }

    public CustomAudiencePermission setFieldCanSeeInsight(Boolean value) {
        this.mCanSeeInsight = value;
        return this;
    }

    public Boolean getFieldCanShare() {
        return this.mCanShare;
    }

    public CustomAudiencePermission setFieldCanShare(Boolean value) {
        this.mCanShare = value;
        return this;
    }

    public Boolean getFieldSubtypeSupportsLookalike() {
        return this.mSubtypeSupportsLookalike;
    }

    public CustomAudiencePermission setFieldSubtypeSupportsLookalike(Boolean value) {
        this.mSubtypeSupportsLookalike = value;
        return this;
    }

    public Boolean getFieldSupportsRecipientLookalike() {
        return this.mSupportsRecipientLookalike;
    }

    public CustomAudiencePermission setFieldSupportsRecipientLookalike(Boolean value) {
        this.mSupportsRecipientLookalike = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public CustomAudiencePermission copyFrom(CustomAudiencePermission instance) {
        this.mCanEdit = instance.mCanEdit;
        this.mCanSeeInsight = instance.mCanSeeInsight;
        this.mCanShare = instance.mCanShare;
        this.mSubtypeSupportsLookalike = instance.mSubtypeSupportsLookalike;
        this.mSupportsRecipientLookalike = instance.mSupportsRecipientLookalike;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<CustomAudiencePermission> getParser() {
        return new APIRequest.ResponseParser<CustomAudiencePermission>(){

            @Override
            public APINodeList<CustomAudiencePermission> parseResponse(String response, APIContext context, APIRequest<CustomAudiencePermission> request) throws APIException.MalformedResponseException {
                return CustomAudiencePermission.parseResponse(response, context, request);
            }
        };
    }
}

