/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LookalikeSpec
extends APINode {
    @SerializedName(value="country")
    private String mCountry = null;
    @SerializedName(value="is_financial_service")
    private Boolean mIsFinancialService = null;
    @SerializedName(value="origin")
    private List<Object> mOrigin = null;
    @SerializedName(value="ratio")
    private Double mRatio = null;
    @SerializedName(value="starting_ratio")
    private Double mStartingRatio = null;
    @SerializedName(value="target_countries")
    private List<String> mTargetCountries = null;
    @SerializedName(value="type")
    private String mType = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static LookalikeSpec loadJSON(String json, APIContext context) {
        LookalikeSpec lookalikeSpec = (LookalikeSpec)LookalikeSpec.getGson().fromJson(json, LookalikeSpec.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(lookalikeSpec.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        lookalikeSpec.context = context;
        lookalikeSpec.rawValue = json;
        return lookalikeSpec;
    }

    public static APINodeList<LookalikeSpec> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block18: {
            APINodeList<LookalikeSpec> lookalikeSpecs = new APINodeList<LookalikeSpec>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        lookalikeSpecs.add(LookalikeSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return lookalikeSpecs;
                }
                if (!result.isJsonObject()) break block18;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject().get("cursors").getAsJsonObject();
                        String[] before = paging.has("before") ? paging.get("before").getAsString() : null;
                        String after = paging.has("after") ? paging.get("after").getAsString() : null;
                        lookalikeSpecs.setPaging((String)before, after);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            lookalikeSpecs.add(LookalikeSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                lookalikeSpecs.add(LookalikeSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            lookalikeSpecs.add(LookalikeSpec.loadJSON(obj.toString(), context));
                        }
                    }
                    return lookalikeSpecs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        lookalikeSpecs.add(LookalikeSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return lookalikeSpecs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        lookalikeSpecs.add(LookalikeSpec.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return lookalikeSpecs;
                }
                lookalikeSpecs.clear();
                lookalikeSpecs.add(LookalikeSpec.loadJSON(json, context));
                return lookalikeSpecs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return LookalikeSpec.getGson().toJson((Object)this);
    }

    public String getFieldCountry() {
        return this.mCountry;
    }

    public LookalikeSpec setFieldCountry(String value) {
        this.mCountry = value;
        return this;
    }

    public Boolean getFieldIsFinancialService() {
        return this.mIsFinancialService;
    }

    public LookalikeSpec setFieldIsFinancialService(Boolean value) {
        this.mIsFinancialService = value;
        return this;
    }

    public List<Object> getFieldOrigin() {
        return this.mOrigin;
    }

    public LookalikeSpec setFieldOrigin(List<Object> value) {
        this.mOrigin = value;
        return this;
    }

    public Double getFieldRatio() {
        return this.mRatio;
    }

    public LookalikeSpec setFieldRatio(Double value) {
        this.mRatio = value;
        return this;
    }

    public Double getFieldStartingRatio() {
        return this.mStartingRatio;
    }

    public LookalikeSpec setFieldStartingRatio(Double value) {
        this.mStartingRatio = value;
        return this;
    }

    public List<String> getFieldTargetCountries() {
        return this.mTargetCountries;
    }

    public LookalikeSpec setFieldTargetCountries(List<String> value) {
        this.mTargetCountries = value;
        return this;
    }

    public String getFieldType() {
        return this.mType;
    }

    public LookalikeSpec setFieldType(String value) {
        this.mType = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public LookalikeSpec copyFrom(LookalikeSpec instance) {
        this.mCountry = instance.mCountry;
        this.mIsFinancialService = instance.mIsFinancialService;
        this.mOrigin = instance.mOrigin;
        this.mRatio = instance.mRatio;
        this.mStartingRatio = instance.mStartingRatio;
        this.mTargetCountries = instance.mTargetCountries;
        this.mType = instance.mType;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<LookalikeSpec> getParser() {
        return new APIRequest.ResponseParser<LookalikeSpec>(){

            @Override
            public APINodeList<LookalikeSpec> parseResponse(String response, APIContext context, APIRequest<LookalikeSpec> request) throws APIException.MalformedResponseException {
                return LookalikeSpec.parseResponse(response, context, request);
            }
        };
    }
}

