/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AdRuleFilters;
import com.facebook.ads.sdk.AdRuleTrigger;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdRuleEvaluationSpec
extends APINode {
    @SerializedName(value="evaluation_type")
    private EnumEvaluationType mEvaluationType = null;
    @SerializedName(value="filters")
    private List<AdRuleFilters> mFilters = null;
    @SerializedName(value="trigger")
    private AdRuleTrigger mTrigger = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdRuleEvaluationSpec loadJSON(String json, APIContext context) {
        AdRuleEvaluationSpec adRuleEvaluationSpec = (AdRuleEvaluationSpec)AdRuleEvaluationSpec.getGson().fromJson(json, AdRuleEvaluationSpec.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adRuleEvaluationSpec.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adRuleEvaluationSpec.context = context;
        adRuleEvaluationSpec.rawValue = json;
        return adRuleEvaluationSpec;
    }

    public static APINodeList<AdRuleEvaluationSpec> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block18: {
            APINodeList<AdRuleEvaluationSpec> adRuleEvaluationSpecs = new APINodeList<AdRuleEvaluationSpec>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adRuleEvaluationSpecs.add(AdRuleEvaluationSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adRuleEvaluationSpecs;
                }
                if (!result.isJsonObject()) break block18;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject().get("cursors").getAsJsonObject();
                        String[] before = paging.has("before") ? paging.get("before").getAsString() : null;
                        String after = paging.has("after") ? paging.get("after").getAsString() : null;
                        adRuleEvaluationSpecs.setPaging((String)before, after);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adRuleEvaluationSpecs.add(AdRuleEvaluationSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adRuleEvaluationSpecs.add(AdRuleEvaluationSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adRuleEvaluationSpecs.add(AdRuleEvaluationSpec.loadJSON(obj.toString(), context));
                        }
                    }
                    return adRuleEvaluationSpecs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adRuleEvaluationSpecs.add(AdRuleEvaluationSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adRuleEvaluationSpecs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adRuleEvaluationSpecs.add(AdRuleEvaluationSpec.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adRuleEvaluationSpecs;
                }
                adRuleEvaluationSpecs.clear();
                adRuleEvaluationSpecs.add(AdRuleEvaluationSpec.loadJSON(json, context));
                return adRuleEvaluationSpecs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdRuleEvaluationSpec.getGson().toJson((Object)this);
    }

    public EnumEvaluationType getFieldEvaluationType() {
        return this.mEvaluationType;
    }

    public AdRuleEvaluationSpec setFieldEvaluationType(EnumEvaluationType value) {
        this.mEvaluationType = value;
        return this;
    }

    public List<AdRuleFilters> getFieldFilters() {
        return this.mFilters;
    }

    public AdRuleEvaluationSpec setFieldFilters(List<AdRuleFilters> value) {
        this.mFilters = value;
        return this;
    }

    public AdRuleEvaluationSpec setFieldFilters(String value) {
        Type type = new TypeToken<List<AdRuleFilters>>(){}.getType();
        this.mFilters = (List)AdRuleFilters.getGson().fromJson(value, type);
        return this;
    }

    public AdRuleTrigger getFieldTrigger() {
        return this.mTrigger;
    }

    public AdRuleEvaluationSpec setFieldTrigger(AdRuleTrigger value) {
        this.mTrigger = value;
        return this;
    }

    public AdRuleEvaluationSpec setFieldTrigger(String value) {
        Type type = new TypeToken<AdRuleTrigger>(){}.getType();
        this.mTrigger = (AdRuleTrigger)AdRuleTrigger.getGson().fromJson(value, type);
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdRuleEvaluationSpec copyFrom(AdRuleEvaluationSpec instance) {
        this.mEvaluationType = instance.mEvaluationType;
        this.mFilters = instance.mFilters;
        this.mTrigger = instance.mTrigger;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdRuleEvaluationSpec> getParser() {
        return new APIRequest.ResponseParser<AdRuleEvaluationSpec>(){

            @Override
            public APINodeList<AdRuleEvaluationSpec> parseResponse(String response, APIContext context, APIRequest<AdRuleEvaluationSpec> request) throws APIException.MalformedResponseException {
                return AdRuleEvaluationSpec.parseResponse(response, context, request);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumEvaluationType {
        VALUE_SCHEDULE("SCHEDULE"),
        VALUE_TRIGGER("TRIGGER"),
        NULL(null);

        private String value;

        private EnumEvaluationType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

