/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdCreativeOfferData
extends APINode {
    @SerializedName(value="claim_limit")
    private Long mClaimLimit = null;
    @SerializedName(value="coupon_type")
    private String mCouponType = null;
    @SerializedName(value="expiration_time")
    private String mExpirationTime = null;
    @SerializedName(value="image_url")
    private String mImageUrl = null;
    @SerializedName(value="message")
    private String mMessage = null;
    @SerializedName(value="redemption_link")
    private String mRedemptionLink = null;
    @SerializedName(value="reminder_time")
    private String mReminderTime = null;
    @SerializedName(value="title")
    private String mTitle = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdCreativeOfferData loadJSON(String json, APIContext context) {
        AdCreativeOfferData adCreativeOfferData = (AdCreativeOfferData)AdCreativeOfferData.getGson().fromJson(json, AdCreativeOfferData.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCreativeOfferData.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCreativeOfferData.context = context;
        adCreativeOfferData.rawValue = json;
        return adCreativeOfferData;
    }

    public static APINodeList<AdCreativeOfferData> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block18: {
            APINodeList<AdCreativeOfferData> adCreativeOfferDatas = new APINodeList<AdCreativeOfferData>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCreativeOfferDatas.add(AdCreativeOfferData.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adCreativeOfferDatas;
                }
                if (!result.isJsonObject()) break block18;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject().get("cursors").getAsJsonObject();
                        String[] before = paging.has("before") ? paging.get("before").getAsString() : null;
                        String after = paging.has("after") ? paging.get("after").getAsString() : null;
                        adCreativeOfferDatas.setPaging((String)before, after);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCreativeOfferDatas.add(AdCreativeOfferData.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCreativeOfferDatas.add(AdCreativeOfferData.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCreativeOfferDatas.add(AdCreativeOfferData.loadJSON(obj.toString(), context));
                        }
                    }
                    return adCreativeOfferDatas;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCreativeOfferDatas.add(AdCreativeOfferData.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adCreativeOfferDatas;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCreativeOfferDatas.add(AdCreativeOfferData.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCreativeOfferDatas;
                }
                adCreativeOfferDatas.clear();
                adCreativeOfferDatas.add(AdCreativeOfferData.loadJSON(json, context));
                return adCreativeOfferDatas;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCreativeOfferData.getGson().toJson((Object)this);
    }

    public Long getFieldClaimLimit() {
        return this.mClaimLimit;
    }

    public AdCreativeOfferData setFieldClaimLimit(Long value) {
        this.mClaimLimit = value;
        return this;
    }

    public String getFieldCouponType() {
        return this.mCouponType;
    }

    public AdCreativeOfferData setFieldCouponType(String value) {
        this.mCouponType = value;
        return this;
    }

    public String getFieldExpirationTime() {
        return this.mExpirationTime;
    }

    public AdCreativeOfferData setFieldExpirationTime(String value) {
        this.mExpirationTime = value;
        return this;
    }

    public String getFieldImageUrl() {
        return this.mImageUrl;
    }

    public AdCreativeOfferData setFieldImageUrl(String value) {
        this.mImageUrl = value;
        return this;
    }

    public String getFieldMessage() {
        return this.mMessage;
    }

    public AdCreativeOfferData setFieldMessage(String value) {
        this.mMessage = value;
        return this;
    }

    public String getFieldRedemptionLink() {
        return this.mRedemptionLink;
    }

    public AdCreativeOfferData setFieldRedemptionLink(String value) {
        this.mRedemptionLink = value;
        return this;
    }

    public String getFieldReminderTime() {
        return this.mReminderTime;
    }

    public AdCreativeOfferData setFieldReminderTime(String value) {
        this.mReminderTime = value;
        return this;
    }

    public String getFieldTitle() {
        return this.mTitle;
    }

    public AdCreativeOfferData setFieldTitle(String value) {
        this.mTitle = value;
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCreativeOfferData copyFrom(AdCreativeOfferData instance) {
        this.mClaimLimit = instance.mClaimLimit;
        this.mCouponType = instance.mCouponType;
        this.mExpirationTime = instance.mExpirationTime;
        this.mImageUrl = instance.mImageUrl;
        this.mMessage = instance.mMessage;
        this.mRedemptionLink = instance.mRedemptionLink;
        this.mReminderTime = instance.mReminderTime;
        this.mTitle = instance.mTitle;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCreativeOfferData> getParser() {
        return new APIRequest.ResponseParser<AdCreativeOfferData>(){

            @Override
            public APINodeList<AdCreativeOfferData> parseResponse(String response, APIContext context, APIRequest<AdCreativeOfferData> request) throws APIException.MalformedResponseException {
                return AdCreativeOfferData.parseResponse(response, context, request);
            }
        };
    }
}

