/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.sdk;

import com.facebook.ads.sdk.APIContext;
import com.facebook.ads.sdk.APIException;
import com.facebook.ads.sdk.APINode;
import com.facebook.ads.sdk.APINodeList;
import com.facebook.ads.sdk.APIRequest;
import com.facebook.ads.sdk.AndroidAppLink;
import com.facebook.ads.sdk.IosAppLink;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdCreativeLinkDataAppLinkSpec
extends APINode {
    @SerializedName(value="android")
    private List<AndroidAppLink> mAndroid = null;
    @SerializedName(value="ios")
    private List<IosAppLink> mIos = null;
    @SerializedName(value="ipad")
    private List<IosAppLink> mIpad = null;
    @SerializedName(value="iphone")
    private List<IosAppLink> mIphone = null;
    protected static Gson gson = null;

    @Override
    public String getId() {
        return null;
    }

    public static AdCreativeLinkDataAppLinkSpec loadJSON(String json, APIContext context) {
        AdCreativeLinkDataAppLinkSpec adCreativeLinkDataAppLinkSpec = (AdCreativeLinkDataAppLinkSpec)AdCreativeLinkDataAppLinkSpec.getGson().fromJson(json, AdCreativeLinkDataAppLinkSpec.class);
        if (context.isDebug()) {
            JsonParser parser = new JsonParser();
            JsonElement o1 = parser.parse(json);
            JsonElement o2 = parser.parse(adCreativeLinkDataAppLinkSpec.toString());
            if (o1.getAsJsonObject().get("__fb_trace_id__") != null) {
                o2.getAsJsonObject().add("__fb_trace_id__", o1.getAsJsonObject().get("__fb_trace_id__"));
            }
            if (!o1.equals(o2)) {
                context.log("[Warning] When parsing response, object is not consistent with JSON:");
                context.log("[JSON]" + o1);
                context.log("[Object]" + o2);
            }
        }
        adCreativeLinkDataAppLinkSpec.context = context;
        adCreativeLinkDataAppLinkSpec.rawValue = json;
        return adCreativeLinkDataAppLinkSpec;
    }

    public static APINodeList<AdCreativeLinkDataAppLinkSpec> parseResponse(String json, APIContext context, APIRequest request) throws APIException.MalformedResponseException {
        Exception exception;
        block18: {
            APINodeList<AdCreativeLinkDataAppLinkSpec> adCreativeLinkDataAppLinkSpecs = new APINodeList<AdCreativeLinkDataAppLinkSpec>(request, json);
            JsonParser parser = new JsonParser();
            exception = null;
            try {
                JsonElement result = parser.parse(json);
                if (result.isJsonArray()) {
                    JsonArray arr = result.getAsJsonArray();
                    for (int i = 0; i < arr.size(); ++i) {
                        adCreativeLinkDataAppLinkSpecs.add(AdCreativeLinkDataAppLinkSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                    }
                    return adCreativeLinkDataAppLinkSpecs;
                }
                if (!result.isJsonObject()) break block18;
                JsonObject obj = result.getAsJsonObject();
                if (obj.has("data")) {
                    if (obj.has("paging")) {
                        JsonObject paging = obj.get("paging").getAsJsonObject().get("cursors").getAsJsonObject();
                        String[] before = paging.has("before") ? paging.get("before").getAsString() : null;
                        String after = paging.has("after") ? paging.get("after").getAsString() : null;
                        adCreativeLinkDataAppLinkSpecs.setPaging((String)before, after);
                    }
                    if (obj.get("data").isJsonArray()) {
                        JsonArray arr = obj.get("data").getAsJsonArray();
                        for (int i = 0; i < arr.size(); ++i) {
                            adCreativeLinkDataAppLinkSpecs.add(AdCreativeLinkDataAppLinkSpec.loadJSON(arr.get(i).getAsJsonObject().toString(), context));
                        }
                    } else if (obj.get("data").isJsonObject()) {
                        obj = obj.get("data").getAsJsonObject();
                        boolean isRedownload = false;
                        for (String s : new String[]{"campaigns", "adsets", "ads"}) {
                            if (!obj.has(s)) continue;
                            isRedownload = true;
                            obj = obj.getAsJsonObject(s);
                            for (Map.Entry entry : obj.entrySet()) {
                                adCreativeLinkDataAppLinkSpecs.add(AdCreativeLinkDataAppLinkSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                            }
                            break;
                        }
                        if (!isRedownload) {
                            adCreativeLinkDataAppLinkSpecs.add(AdCreativeLinkDataAppLinkSpec.loadJSON(obj.toString(), context));
                        }
                    }
                    return adCreativeLinkDataAppLinkSpecs;
                }
                if (obj.has("images")) {
                    obj = obj.get("images").getAsJsonObject();
                    for (Map.Entry entry : obj.entrySet()) {
                        adCreativeLinkDataAppLinkSpecs.add(AdCreativeLinkDataAppLinkSpec.loadJSON(((JsonElement)entry.getValue()).toString(), context));
                    }
                    return adCreativeLinkDataAppLinkSpecs;
                }
                boolean isIdIndexedArray = true;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("__fb_trace_id__")) continue;
                    JsonElement value = (JsonElement)entry.getValue();
                    if (value != null && value.isJsonObject() && value.getAsJsonObject().has("id") && value.getAsJsonObject().get("id") != null && value.getAsJsonObject().get("id").getAsString().equals(key)) {
                        adCreativeLinkDataAppLinkSpecs.add(AdCreativeLinkDataAppLinkSpec.loadJSON(value.toString(), context));
                        continue;
                    }
                    isIdIndexedArray = false;
                    break;
                }
                if (isIdIndexedArray) {
                    return adCreativeLinkDataAppLinkSpecs;
                }
                adCreativeLinkDataAppLinkSpecs.clear();
                adCreativeLinkDataAppLinkSpecs.add(AdCreativeLinkDataAppLinkSpec.loadJSON(json, context));
                return adCreativeLinkDataAppLinkSpecs;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        throw new APIException.MalformedResponseException("Invalid response string: " + json, exception);
    }

    @Override
    public APIContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(APIContext context) {
        this.context = context;
    }

    @Override
    public String toString() {
        return AdCreativeLinkDataAppLinkSpec.getGson().toJson((Object)this);
    }

    public List<AndroidAppLink> getFieldAndroid() {
        return this.mAndroid;
    }

    public AdCreativeLinkDataAppLinkSpec setFieldAndroid(List<AndroidAppLink> value) {
        this.mAndroid = value;
        return this;
    }

    public AdCreativeLinkDataAppLinkSpec setFieldAndroid(String value) {
        Type type = new TypeToken<List<AndroidAppLink>>(){}.getType();
        this.mAndroid = (List)AndroidAppLink.getGson().fromJson(value, type);
        return this;
    }

    public List<IosAppLink> getFieldIos() {
        return this.mIos;
    }

    public AdCreativeLinkDataAppLinkSpec setFieldIos(List<IosAppLink> value) {
        this.mIos = value;
        return this;
    }

    public AdCreativeLinkDataAppLinkSpec setFieldIos(String value) {
        Type type = new TypeToken<List<IosAppLink>>(){}.getType();
        this.mIos = (List)IosAppLink.getGson().fromJson(value, type);
        return this;
    }

    public List<IosAppLink> getFieldIpad() {
        return this.mIpad;
    }

    public AdCreativeLinkDataAppLinkSpec setFieldIpad(List<IosAppLink> value) {
        this.mIpad = value;
        return this;
    }

    public AdCreativeLinkDataAppLinkSpec setFieldIpad(String value) {
        Type type = new TypeToken<List<IosAppLink>>(){}.getType();
        this.mIpad = (List)IosAppLink.getGson().fromJson(value, type);
        return this;
    }

    public List<IosAppLink> getFieldIphone() {
        return this.mIphone;
    }

    public AdCreativeLinkDataAppLinkSpec setFieldIphone(List<IosAppLink> value) {
        this.mIphone = value;
        return this;
    }

    public AdCreativeLinkDataAppLinkSpec setFieldIphone(String value) {
        Type type = new TypeToken<List<IosAppLink>>(){}.getType();
        this.mIphone = (List)IosAppLink.getGson().fromJson(value, type);
        return this;
    }

    static synchronized Gson getGson() {
        if (gson != null) {
            return gson;
        }
        gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).excludeFieldsWithModifiers(new int[]{4}).disableHtmlEscaping().create();
        return gson;
    }

    public AdCreativeLinkDataAppLinkSpec copyFrom(AdCreativeLinkDataAppLinkSpec instance) {
        this.mAndroid = instance.mAndroid;
        this.mIos = instance.mIos;
        this.mIpad = instance.mIpad;
        this.mIphone = instance.mIphone;
        this.context = instance.context;
        this.rawValue = instance.rawValue;
        return this;
    }

    public static APIRequest.ResponseParser<AdCreativeLinkDataAppLinkSpec> getParser() {
        return new APIRequest.ResponseParser<AdCreativeLinkDataAppLinkSpec>(){

            @Override
            public APINodeList<AdCreativeLinkDataAppLinkSpec> parseResponse(String response, APIContext context, APIRequest<AdCreativeLinkDataAppLinkSpec> request) throws APIException.MalformedResponseException {
                return AdCreativeLinkDataAppLinkSpec.parseResponse(response, context, request);
            }
        };
    }
}

